/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.container.runner;

import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.wso2.carbon.container.runner.CommandLineBuilder;
import org.wso2.carbon.container.runner.InternalRunner;
import org.wso2.carbon.container.runner.Runner;

public class CarbonRunner
implements Runner {
    private static final boolean IS_WINDOWS_OS = System.getProperty("os.name").toLowerCase(Locale.getDefault()).contains("windows");
    private InternalRunner runner = new InternalRunner();

    @Override
    public synchronized void exec(final String[] environment, final Path carbonHome, final List<String> options) {
        Thread thread = new Thread("CarbonRunner"){

            @Override
            public void run() {
                CommandLineBuilder commandLine = new CommandLineBuilder();
                if (IS_WINDOWS_OS) {
                    commandLine.append("cmd.exe").append("/c").append(carbonHome.toAbsolutePath() + "/bin/carbon.bat");
                } else {
                    commandLine.append(carbonHome.toAbsolutePath() + "/bin/carbon.sh");
                }
                commandLine.append(options.toArray(new String[options.size()]));
                CarbonRunner.this.runner.exec(commandLine, environment);
            }
        };
        thread.start();
    }

    @Override
    public synchronized void shutdown() {
        this.runner.shutdown();
    }
}

