/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.dashboard.DashboardContext;
import org.wso2.carbon.dashboard.common.DashboardConstants;
import org.wso2.carbon.dashboard.common.IUserPrefsService;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.utils.ServerConfiguration;

public class UserPrefsService
extends AbstractAdmin
implements IUserPrefsService {
    private static final Log log = LogFactory.getLog(UserPrefsService.class);

    public Boolean setGadgetPrefs(String userId, String gadgetId, String prefId, String value, String dashboardName) {
        Boolean response;
        block5: {
            response = false;
            try {
                String gadgetPrefPath;
                Registry registry = this.getConfigSystemRegistry();
                if (dashboardName == null || "null".equals(dashboardName)) {
                    gadgetPrefPath = DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + gadgetId + DashboardConstants.GADGET_PREFERENCE_PATH;
                } else {
                    if (!this.checkUserAuthorization(userId, "setGadgetPrefs")) {
                        return false;
                    }
                    gadgetPrefPath = DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + gadgetId + DashboardConstants.GADGET_PREFERENCE_PATH;
                }
                Object gadgetPreferences = registry.resourceExists(gadgetPrefPath) ? registry.get(gadgetPrefPath) : registry.newCollection();
                gadgetPreferences.setProperty(prefId, value);
                registry.put(gadgetPrefPath, (Resource)gadgetPreferences);
                response = true;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("Failed to set preferences for user " + userId + " for prefId " + prefId), (Throwable)e);
            }
        }
        return response;
    }

    public String getGadgetPrefs(String userId, String gadgetId, String prefId, String dashboardName) {
        String response;
        block2: {
            response = "NA";
            try {
                Registry registry = this.getConfigSystemRegistry();
                String gadgetPrefPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + gadgetId + DashboardConstants.GADGET_PREFERENCE_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + gadgetId + DashboardConstants.GADGET_PREFERENCE_PATH;
                Resource gadgetPreferences = registry.get(gadgetPrefPath);
                response = gadgetPreferences.getProperty(prefId);
                response = new String(Hex.decodeHex((char[])response.toCharArray()));
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Preferences were not found for user " + userId + " for prefId " + prefId), (Throwable)e);
            }
        }
        return response;
    }

    public Boolean setGadgetLayout(String userId, String tabId, String newLayout, String dashboardName) {
        Boolean response = false;
        try {
            Registry registry = this.getConfigSystemRegistry();
            String gadgetLayoutPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH;
            if (!this.checkUserAuthorization(userId, "setGadgetLayout")) {
                return false;
            }
            Object gadgetLayout = registry.resourceExists(gadgetLayoutPath) ? registry.get(gadgetLayoutPath) : registry.newCollection();
            gadgetLayout.setProperty(DashboardConstants.CURRENT_GADGET_LAYOUT, newLayout);
            registry.put(gadgetLayoutPath, (Resource)gadgetLayout);
            response = true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to set new layout for user " + userId + " for layout info [" + newLayout + "]"), (Throwable)e);
        }
        return response;
    }

    private boolean isGadgetInValidFormat(String gadgetFormat) {
        try {
            Integer.parseInt(gadgetFormat.split("#")[1]);
            return true;
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid gadget layout format : " + gadgetFormat), (Throwable)e);
            return false;
        }
    }

    public String getGadgetLayout(String userId, String tabId, String dashboardName) {
        String response;
        try {
            Collection gadgetLayout;
            Registry registry = this.getConfigSystemRegistry();
            String gadgetLayoutPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH;
            if (registry.resourceExists(gadgetLayoutPath)) {
                gadgetLayout = registry.get(gadgetLayoutPath);
            } else {
                gadgetLayout = registry.newCollection();
                registry.put(gadgetLayoutPath, (Resource)gadgetLayout);
            }
            response = gadgetLayout.getProperty(DashboardConstants.CURRENT_GADGET_LAYOUT);
            if (response == null || "".equals(response)) {
                response = "NA";
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get layout information for user " + userId), (Throwable)e);
            response = "NA";
        }
        return response;
    }

    public String getTabLayout(String userId, String dashboardName) {
        String response = "0";
        try {
            Registry registry = this.getConfigSystemRegistry();
            String tabLayoutPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH;
            Object gadgetLayout = registry.resourceExists(tabLayoutPath) ? registry.get(tabLayoutPath) : registry.newCollection();
            response = gadgetLayout.getProperty(DashboardConstants.CURRENT_TAB_LAYOUT);
            if (response == null) {
                gadgetLayout.setProperty(DashboardConstants.CURRENT_TAB_LAYOUT, "0");
                registry.put(tabLayoutPath, (Resource)gadgetLayout);
                response = "0";
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get layout information for user " + userId), (Throwable)e);
        }
        return response;
    }

    public String[] getGadgetUrlsToLayout(String userId, String tabId, String dashboardName, String backendServerURL) {
        String laidOutGadgetIDs = this.getGadgetLayout(userId, tabId, dashboardName);
        if ("NA".equals(laidOutGadgetIDs)) {
            return null;
        }
        try {
            Registry registry = this.getConfigSystemRegistry();
            ArrayList<String> gadgetUrlsList = new ArrayList<String>();
            if (laidOutGadgetIDs != null && !laidOutGadgetIDs.equalsIgnoreCase("")) {
                String[] indGadgetIds;
                for (String indGadgetId : indGadgetIds = laidOutGadgetIDs.split(",")) {
                    if (!this.isGadgetInValidFormat(indGadgetId)) continue;
                    String gadgetPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + indGadgetId.split("#")[1] : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + indGadgetId.split("#")[1];
                    try {
                        Resource currentGadget = registry.get(gadgetPath);
                        gadgetUrlsList.add(currentGadget.getProperty(DashboardConstants.GADGET_URL));
                    }
                    catch (RegistryException e) {
                        this.removeGadgetFromLayout(userId, tabId, indGadgetId.split("#")[1], dashboardName);
                    }
                }
            }
            String[] gadgetUrls = new String[gadgetUrlsList.size()];
            gadgetUrlsList.toArray(gadgetUrls);
            if (gadgetUrls.length > 0) {
                gadgetUrls = this.sanitizeUrls(gadgetUrls, backendServerURL);
            }
            return gadgetUrls;
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while parsing the gadget urls to the layout : ", (Throwable)e);
            return null;
        }
    }

    private void removeGadgetFromLayout(String userId, String tabId, String gadgetId, String dashboardName) {
        String laidOutGadgetIDs = this.getGadgetLayout(userId, tabId, dashboardName);
        String[] indGadgets = laidOutGadgetIDs.split(",");
        String newLayout = "";
        for (String indGadget : indGadgets) {
            if (!this.isGadgetInValidFormat(indGadget) || gadgetId.equals(indGadget.split("#")[1])) continue;
            newLayout = newLayout.equals("") ? newLayout + indGadget.split("#")[1] : newLayout + "," + indGadget.split("#")[1];
        }
        this.setGadgetLayout(userId, tabId, newLayout, dashboardName);
    }

    public Boolean addGadgetToUser(String userId, String tabId, String url, String dashboardName, String gadgetGroup) {
        Boolean response;
        block7: {
            if (!this.checkUserAuthorization(userId, "addGadget")) {
                return false;
            }
            response = false;
            Registry registry = null;
            try {
                registry = this.getConfigSystemRegistry();
                registry.beginTransaction();
                String nextGadgetIdPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.NEXT_GADGET_ID_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.NEXT_GADGET_ID_PATH;
                Object nextGadgetIdResource = registry.resourceExists(nextGadgetIdPath) ? registry.get(nextGadgetIdPath) : registry.newCollection();
                String gadgetId = "0";
                if (nextGadgetIdResource.getProperty(DashboardConstants.NEXT_GADGET_ID) != null) {
                    gadgetId = nextGadgetIdResource.getProperty(DashboardConstants.NEXT_GADGET_ID);
                }
                int nextGadgetId = Integer.parseInt(gadgetId) + 1;
                nextGadgetIdResource.setProperty(DashboardConstants.NEXT_GADGET_ID, String.valueOf(nextGadgetId));
                registry.put(nextGadgetIdPath, (Resource)nextGadgetIdResource);
                String newGadgetPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + gadgetId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + gadgetId;
                Object newGadgetResource = registry.resourceExists(newGadgetPath) ? registry.get(newGadgetPath) : registry.newCollection();
                newGadgetResource.setProperty(DashboardConstants.GADGET_URL, url);
                registry.put(newGadgetPath, (Resource)newGadgetResource);
                String gadgetLayoutPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH;
                Object gadgetLayout = registry.resourceExists(gadgetLayoutPath) ? registry.get(gadgetLayoutPath) : registry.newCollection();
                String currentLayout = gadgetLayout.getProperty(DashboardConstants.CURRENT_GADGET_LAYOUT);
                if (gadgetGroup == null || gadgetGroup.equals("") || gadgetGroup.equals("null")) {
                    gadgetGroup = "G1#";
                }
                currentLayout = currentLayout == null || "".equals(currentLayout) ? gadgetGroup + gadgetId : currentLayout + "," + gadgetGroup + gadgetId;
                gadgetLayout.setProperty(DashboardConstants.CURRENT_GADGET_LAYOUT, currentLayout);
                registry.put(gadgetLayoutPath, (Resource)gadgetLayout);
                response = true;
                registry.commitTransaction();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (registry == null) break block7;
                try {
                    registry.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)e);
                }
            }
        }
        return response;
    }

    private String getGadgetUrl(String userId, String gadgetId, String dashboardName) {
        String gadgetUrl = null;
        String gadgetPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + gadgetId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + gadgetId;
        try {
            Registry registry = this.getConfigSystemRegistry();
            Resource gadgetRes = registry.get(gadgetPath);
            gadgetUrl = gadgetRes.getProperty(DashboardConstants.GADGET_URL);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return gadgetUrl;
    }

    public Boolean removeGadget(String userId, String tabId, String gadgetId, String dashboardName) {
        Boolean response;
        block7: {
            if (!this.checkUserAuthorization(userId, "removeGadget")) {
                return false;
            }
            response = false;
            Registry registry = null;
            try {
                registry = this.getConfigSystemRegistry();
                if (!Transaction.isStarted()) {
                    registry.beginTransaction();
                }
                String gadgetLayoutPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH;
                Resource gadgetLayout = registry.get(gadgetLayoutPath);
                String currentLayout = gadgetLayout.getProperty(DashboardConstants.CURRENT_GADGET_LAYOUT);
                String[] layoutgadgetIds = currentLayout.split(",");
                String newLayout = "";
                for (String layoutgadgetId : layoutgadgetIds) {
                    if (!this.isGadgetInValidFormat(layoutgadgetId) || layoutgadgetId.split("#")[1].equals(gadgetId)) continue;
                    newLayout = newLayout.equals("") ? layoutgadgetId : newLayout + "," + layoutgadgetId;
                }
                gadgetLayout.setProperty(DashboardConstants.CURRENT_GADGET_LAYOUT, newLayout);
                registry.put(gadgetLayoutPath, gadgetLayout);
                String gadgetPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.GADGET_PATH + gadgetId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.GADGET_PATH + gadgetId;
                registry.delete(gadgetPath);
                response = true;
                registry.commitTransaction();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (registry == null) break block7;
                try {
                    registry.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)e);
                }
            }
        }
        return response;
    }

    public Integer addNewTab(String userId, String tabTitle, String dashboardName) {
        Integer response;
        block7: {
            if (!this.checkUserAuthorization(userId, "addNewTab") || this.tabNameExsists(tabTitle, userId).booleanValue()) {
                return 0;
            }
            response = 0;
            String dashboardTabPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH;
            Registry registry = null;
            try {
                registry = this.getConfigSystemRegistry();
                registry.beginTransaction();
                Resource userTabResource = registry.get(dashboardTabPath);
                String nextTabId = userTabResource.getProperty(DashboardConstants.NEXT_TAB_ID);
                if (nextTabId == null) {
                    nextTabId = "1";
                }
                userTabResource.setProperty(DashboardConstants.NEXT_TAB_ID, String.valueOf(Integer.parseInt(nextTabId) + 1));
                registry.put(dashboardTabPath, userTabResource);
                Collection newTab = registry.newCollection();
                if ("".equals(tabTitle)) {
                    tabTitle = "Tab " + nextTabId;
                }
                newTab.setProperty(DashboardConstants.TAB_TITLE, tabTitle);
                String newTabPath = dashboardTabPath + nextTabId;
                registry.put(newTabPath, (Resource)newTab);
                String currentTabLayout = userTabResource.getProperty(DashboardConstants.CURRENT_TAB_LAYOUT);
                currentTabLayout = currentTabLayout + "," + String.valueOf(nextTabId);
                userTabResource.setProperty(DashboardConstants.CURRENT_TAB_LAYOUT, currentTabLayout);
                registry.put(dashboardTabPath, userTabResource);
                response = Integer.parseInt(nextTabId);
                registry.commitTransaction();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (registry == null) break block7;
                try {
                    registry.rollbackTransaction();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)e);
                }
            }
        }
        return response;
    }

    public String getTabTitle(String userId, String tabId, String dashboardName) {
        String response = "Tab " + tabId;
        if (dashboardName == null || "null".equals(dashboardName) && "0".equals(tabId)) {
            return "Home";
        }
        String tabPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH + tabId : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH + tabId;
        try {
            Registry registry = this.getConfigSystemRegistry();
            Resource tabResource = registry.get(tabPath);
            if (tabResource.getProperty(DashboardConstants.TAB_TITLE) != null) {
                return tabResource.getProperty(DashboardConstants.TAB_TITLE);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public Boolean removeTab(String userId, String tabId, String dashboardName) {
        Boolean response;
        block12: {
            if (!this.checkUserAuthorization(userId, "removeTab")) {
                return false;
            }
            if ("0".equals(tabId)) {
                return false;
            }
            response = false;
            String dashboardTabPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH;
            Registry registry = null;
            try {
                registry = this.getConfigSystemRegistry();
                if (!Transaction.isStarted()) {
                    registry.beginTransaction();
                }
                Resource userTabResource = registry.get(dashboardTabPath);
                String currentTabLayout = userTabResource.getProperty(DashboardConstants.CURRENT_TAB_LAYOUT);
                String[] tabIds = currentTabLayout.split(",");
                String newTabLayout = "";
                for (String tabId1 : tabIds) {
                    if (tabId1.equals(tabId)) continue;
                    newTabLayout = newTabLayout.equals("") ? tabId1 : newTabLayout + "," + tabId1;
                }
                userTabResource.setProperty(DashboardConstants.CURRENT_TAB_LAYOUT, newTabLayout);
                registry.put(dashboardTabPath, userTabResource);
                String gadgetLayoutPath = dashboardName == null || "null".equals(dashboardName) ? DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH : DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + dashboardName + DashboardConstants.TAB_PATH + tabId + DashboardConstants.CURRENT_GADGET_LAYOUT_PATH;
                Object gadgetLayout = registry.resourceExists(gadgetLayoutPath) ? registry.get(gadgetLayoutPath) : registry.newCollection();
                String currentLayout = gadgetLayout.getProperty(DashboardConstants.CURRENT_GADGET_LAYOUT);
                if (currentLayout != null) {
                    String[] gadgetList;
                    for (String aGadgetList : gadgetList = currentLayout.split(",")) {
                        String gadgetId;
                        if (!this.isGadgetInValidFormat(aGadgetList) || "".equals(gadgetId = aGadgetList.split("#")[1])) continue;
                        this.removeGadget(userId, tabId, gadgetId, dashboardName);
                    }
                }
                String tabPath = dashboardTabPath + tabId;
                registry.delete(tabPath);
                response = true;
                if (Transaction.isStarted()) {
                    registry.commitTransaction();
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (registry == null) break block12;
                try {
                    if (Transaction.isStarted()) {
                        registry.rollbackTransaction();
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return response;
    }

    public Boolean isReadOnlyMode(String userId) {
        if (userId == null || "null".equals(userId)) {
            return true;
        }
        Boolean resp = true;
        try {
            String[] userRoles = this.getUserRealm().getUserStoreManager().getRoleListOfUser(userId);
            for (int x = 0; x < userRoles.length; ++x) {
                if (!"admin".equals(userRoles[x])) continue;
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return resp;
    }

    public String getBackendHttpPort() {
        String httpPort = null;
        try {
            httpPort = ServerConfiguration.getInstance().getFirstProperty("RegistryHttpPort");
            if (httpPort == null) {
                httpPort = (String)DashboardContext.getConfigContext().getAxisConfiguration().getTransportIn("http").getParameter("port").getValue();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return httpPort;
    }

    public Boolean isSelfRegistrationEnabled() {
        Boolean response = false;
        try {
            Resource regAdminDataResource;
            String storedValue;
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) && (storedValue = (regAdminDataResource = registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH)).getProperty(DashboardConstants.USER_SELF_REG_PROPERTY_ID)) != null && "true".equals(storedValue)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public Boolean isExternalGadgetAdditionEnabled() {
        Boolean response = false;
        try {
            Resource regAdminDataResource;
            String storedValue;
            Registry registry = this.getConfigSystemRegistry();
            if (registry.resourceExists(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH) && (storedValue = (regAdminDataResource = registry.get(DashboardConstants.REGISTRY_ADMIN_PROPERTIES_PATH)).getProperty(DashboardConstants.USER_EXTERNAL_GADGET_ADD_PROPERTY_ID)) != null && "true".equals(storedValue)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public String[] getDefaultGadgetUrlSet(String userId) {
        try {
            if (this.isOldUser(userId).booleanValue()) {
                return null;
            }
            Registry registry = this.getConfigSystemRegistry();
            Resource comQuery = registry.newResource();
            String sql = "SELECT R.REG_NAME, R.REG_PATH_ID FROM REG_RESOURCE R, REG_PROPERTY P, REG_RESOURCE_PROPERTY RP, REG_PATH PA WHERE R.REG_VERSION=RP.REG_VERSION AND P.REG_NAME='" + DashboardConstants.DEFAULT_GADGET + "' AND " + "P.REG_VALUE='true' AND " + "P.REG_ID=RP.REG_PROPERTY_ID AND " + "PA.REG_PATH_ID=R.REG_PATH_ID";
            comQuery.setContent((Object)sql);
            comQuery.setMediaType("application/vnd.sql.query");
            comQuery.addProperty("resultType", "Resource");
            registry.put(DashboardConstants.SQL_STATEMENTS_PATH + "/query3", comQuery);
            Collection qResults = registry.executeQuery(DashboardConstants.SQL_STATEMENTS_PATH + "/query3", null);
            String[] qPaths = (String[])qResults.getContent();
            String[] urls = new String[qPaths.length];
            for (int i = 0; i < qPaths.length; ++i) {
                if (!registry.resourceExists(qPaths[i])) continue;
                Resource tempRes = registry.get(qPaths[i]);
                urls[i] = tempRes.getProperty(DashboardConstants.GADGET_URL);
                try {
                    Integer userCount = Integer.parseInt(tempRes.getProperty(DashboardConstants.USER_CONTER));
                    userCount = userCount + 1;
                    tempRes.setProperty(DashboardConstants.USER_CONTER, userCount.toString());
                    registry.put(qPaths[i], tempRes);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("could not increment the user count :" + e.getMessage()));
                }
            }
            return urls;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - could not get the default gadget url set", (Throwable)e);
            return null;
        }
    }

    private boolean checkUserAuthorization(String username, String operation) {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            String userName = (String)httpSession.getAttribute("wso2carbon.admin.username");
            if (!username.equals(userName)) {
                log.warn((Object)("Unauthorised action by user '" + username + "' to access " + operation + " denied."));
                return false;
            }
            return true;
        }
        log.warn((Object)("Unauthorised action by user '" + username + "' to access " + operation + " denied."));
        return false;
    }

    public String[] getGadgetUrlSetForUnSignedUser() {
        try {
            Registry registry = this.getConfigSystemRegistry();
            Resource comQuery = registry.newResource();
            String sql = "SELECT R.REG_NAME, R.REG_PATH_ID FROM REG_RESOURCE R, REG_PROPERTY P, REG_RESOURCE_PROPERTY RP, REG_PATH PA WHERE R.REG_VERSION=RP.REG_VERSION AND P.REG_NAME='" + DashboardConstants.UNSIGNED_USER_GADGET + "' AND " + "P.REG_VALUE='true' AND " + "P.REG_ID=RP.REG_PROPERTY_ID AND " + "PA.REG_PATH_ID=R.REG_PATH_ID";
            comQuery.setContent((Object)sql);
            comQuery.setMediaType("application/vnd.sql.query");
            comQuery.addProperty("resultType", "Resource");
            registry.put(DashboardConstants.SQL_STATEMENTS_PATH + "/query4", comQuery);
            Collection qResults = registry.executeQuery(DashboardConstants.SQL_STATEMENTS_PATH + "/query4", null);
            String[] qPaths = (String[])qResults.getContent();
            String[] NameUrlPair = new String[qPaths.length];
            for (int i = 0; i < qPaths.length; ++i) {
                if (!registry.resourceExists(qPaths[i])) continue;
                NameUrlPair[i] = registry.get(qPaths[i]).getProperty(DashboardConstants.GADGET_NAME);
                String gadgetUrl = registry.get(qPaths[i]).getProperty(DashboardConstants.GADGET_URL);
                NameUrlPair[i] = NameUrlPair[i] + "," + gadgetUrl;
            }
            return NameUrlPair;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - could not get the unsigned_user gadget url set", (Throwable)e);
            return null;
        }
    }

    private String getHttpServerRoot(String backendServerURL) {
        String response = "";
        try {
            response = backendServerURL.split("/services/")[0];
            URL newUrl = new URL(response);
            response = "".equals(newUrl.getPath()) ? "http://" + newUrl.getHost() + ":" + this.getBackendHttpPort() : "http://" + newUrl.getHost() + ":" + this.getBackendHttpPort() + newUrl.getPath();
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    private String[] sanitizeUrls(String[] gadgetUrls, String backendServerURL) {
        String[] response = new String[]{};
        if (gadgetUrls != null) {
            ArrayList<String> tempUrlHolder = new ArrayList<String>();
            for (String currentUrl : gadgetUrls) {
                if ("/".equals(String.valueOf((currentUrl = currentUrl.replaceAll("[\r\n]", "").trim()).charAt(0)))) {
                    currentUrl = this.getHttpServerRoot(backendServerURL) + currentUrl;
                }
                tempUrlHolder.add(currentUrl);
            }
            response = new String[tempUrlHolder.size()];
            tempUrlHolder.toArray(response);
        }
        return response;
    }

    public Integer duplicateTab(String userId, String dashboardName, String sourceTabId, String newTabName) {
        String[] gadgetList;
        if (!this.checkUserAuthorization(userId, "duplicateTab")) {
            return 0;
        }
        int resp = 0;
        String sourceGadgetLayout = this.getGadgetLayout(userId, sourceTabId, dashboardName);
        int newTabId = this.addNewTab(userId, newTabName, dashboardName);
        if (sourceGadgetLayout == null || "NA".equals(sourceGadgetLayout)) {
            return newTabId;
        }
        for (String aGadgetList : gadgetList = sourceGadgetLayout.split(",")) {
            if (!this.isGadgetInValidFormat(aGadgetList)) continue;
            String[] gadgets = aGadgetList.split("#");
            this.copyGadget(userId, dashboardName, gadgets[1], Integer.toString(newTabId), gadgets[0] + "#");
        }
        sourceGadgetLayout = this.getGadgetLayout(userId, Integer.toString(newTabId), dashboardName);
        if (this.setGadgetLayout(userId, String.valueOf(newTabId), sourceGadgetLayout, dashboardName).booleanValue()) {
            return newTabId;
        }
        return resp;
    }

    public Boolean copyGadget(String userId, String dashboardName, String sourceGadgetId, String tab, String grp) {
        if (!this.checkUserAuthorization(userId, "copyGadget")) {
            return false;
        }
        String gadgetUrl = this.getGadgetUrl(userId, sourceGadgetId, dashboardName);
        Boolean resp = this.addGadgetToUser(userId, tab, gadgetUrl, dashboardName, grp);
        return resp;
    }

    public Boolean moveGadgetToTab(String userId, String dashboardName, String sourceGadgetId, String tab) {
        if (!this.checkUserAuthorization(userId, "moveGadgetToTab")) {
            return false;
        }
        String gadgetUrl = this.getGadgetUrl(userId, sourceGadgetId, dashboardName);
        Boolean resp = this.addGadgetToUser(userId, tab, gadgetUrl, dashboardName, "G1#");
        return resp;
    }

    private Boolean tabNameExsists(String tabName, String userId) {
        try {
            Registry registry = this.getConfigSystemRegistry();
            Resource comQuery = registry.newResource();
            String sql = "SELECT R.REG_NAME, R.REG_PATH_ID FROM REG_RESOURCE R, REG_PROPERTY P, REG_RESOURCE_PROPERTY RP, REG_PATH PA WHERE R.REG_VERSION=RP.REG_VERSION AND P.REG_NAME='tabTitle' AND P.REG_VALUE LIKE ? AND P.REG_ID=RP.REG_PROPERTY_ID AND PA.REG_PATH_ID=R.REG_PATH_ID AND PA.REG_PATH_VALUE LIKE ?";
            comQuery.setContent((Object)sql);
            comQuery.setMediaType("application/vnd.sql.query");
            comQuery.addProperty("resultType", "Resource");
            registry.put(DashboardConstants.SQL_STATEMENTS_PATH + "/query4", comQuery);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("1", tabName);
            String tabPath = DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + "%";
            params.put("2", tabPath);
            Collection qResults = registry.executeQuery(DashboardConstants.SQL_STATEMENTS_PATH + "/query4", params);
            String[] qPaths = (String[])qResults.getContent();
            return qPaths.length != 0;
        }
        catch (Exception e) {
            log.error((Object)"Backend server error - could validate the url for duplicates", (Throwable)e);
            return false;
        }
    }

    private Boolean isOldUser(String userId) {
        String nextGadgetIdPath = DashboardConstants.USER_DASHBOARD_REGISTRY_ROOT + userId + DashboardConstants.REGISTRY_PRODUCT_ID_PATH + DashboardConstants.NEXT_GADGET_ID_PATH;
        try {
            Registry registry = this.getConfigSystemRegistry();
            Boolean newUser = registry.resourceExists(nextGadgetIdPath);
            return newUser;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Boolean isSessionValid() {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        return !httpSession.isNew();
    }
}

