/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.common.oauth;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.OAuthFetcherConfig;
import org.apache.shindig.gadgets.oauth.OAuthRequest;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.wso2.carbon.dashboard.common.OAuthUtils;
import org.wso2.carbon.dashboard.common.oauth.RegistryBasedOAuthStore;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class GSOAuthModule
extends AbstractModule {
    private static Log logger = LogFactory.getLog(GSOAuthModule.class);
    private static final String OAUTH_SIGNING_KEY_FILE = "shindig.signing.key-file";
    private static final String OAUTH_SIGNING_KEY_NAME = "shindig.signing.key-name";
    private static final String OAUTH_CALLBACK_URL = "shindig.signing.global-callback-url";

    protected void configure() {
        this.bind(BlobCrypter.class).annotatedWith((Annotation)Names.named((String)"shindig.oauth.state-crypter")).toProvider(OAuthCrypterProvider.class);
        this.bind(OAuthStore.class).toProvider(OAuthStoreProvider.class);
        this.bind(OAuthRequest.class).toProvider(OAuthRequestProvider.class);
    }

    @Singleton
    public static class OAuthStoreProvider
    implements Provider<OAuthStore> {
        private final RegistryBasedOAuthStore store;
        private final HashMap<Integer, RegistryBasedOAuthStore> mtStore = new HashMap();

        @Inject
        public OAuthStoreProvider(@Named(value="shindig.signing.key-file") String signingKeyFile, @Named(value="shindig.signing.key-name") String signingKeyName, @Named(value="shindig.signing.global-callback-url") String defaultCallbackUrl) {
            this.store = this.createNewStore();
            this.loadDefaultKey(signingKeyFile, signingKeyName);
            this.store.setDefaultCallbackUrl(defaultCallbackUrl);
            this.loadConsumers();
        }

        private void loadDefaultKey(String signingKeyFile, String signingKeyName) {
            BasicOAuthStoreConsumerKeyAndSecret key;
            block6: {
                key = null;
                if (!StringUtils.isBlank((String)signingKeyFile)) {
                    try {
                        logger.info((Object)("Loading OAuth signing key from " + signingKeyFile));
                        String privateKey = IOUtils.toString((InputStream)ResourceLoader.open((String)signingKeyFile), (String)"UTF-8");
                        privateKey = RegistryBasedOAuthStore.convertFromOpenSsl(privateKey);
                        key = new BasicOAuthStoreConsumerKeyAndSecret(null, privateKey, BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, signingKeyName, null);
                    }
                    catch (Throwable t) {
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug((Object)("Couldn't load key file " + signingKeyFile), t);
                    }
                }
            }
            if (key != null) {
                this.store.setDefaultKey(key);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Couldn't load OAuth signing key.  To create a key, run:\n  openssl req -newkey rsa:1024 -days 365 -nodes -x509 -keyout testkey.pem \\\n     -out testkey.pem -subj '/CN=mytestkey'\n  openssl pkcs8 -in testkey.pem -out oauthkey.pem -topk8 -nocrypt -outform PEM\n\nThen edit gadgets.properties and add these lines:\nshindig.signing.key-file=<path-to-oauthkey.pem>\nshindig.signing.key-name=mykey\n");
            }
        }

        private void loadConsumers() {
            block2: {
                try {
                    Integer tId = MultitenantUtils.getTenantId((ConfigurationContext)OAuthUtils.getConfigContext());
                    Registry reg = OAuthUtils.getRegistry(tId);
                    this.store.initFromConfigString(reg, (Collection)reg.get("/repository/gadget-server/oauth"));
                }
                catch (Throwable t) {
                    if (!logger.isDebugEnabled()) break block2;
                    logger.debug((Object)"Failed to initialize OAuth consumers", t);
                }
            }
        }

        public OAuthStore get() {
            return this.getStore();
        }

        public OAuthStore getStore() {
            Integer tId = null;
            try {
                tId = MultitenantUtils.getTenantId((ConfigurationContext)OAuthUtils.getConfigContext());
                return this.mtStore.get(tId);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public OAuthStore getStore(int tenantId) {
            OAuthStore store = this.mtStore.get(tenantId);
            if (store == null) {
                store = this.createNewStore();
            }
            return store;
        }

        public RegistryBasedOAuthStore createNewStore() {
            RegistryBasedOAuthStore newStore = new RegistryBasedOAuthStore();
            Integer tId = null;
            try {
                tId = MultitenantUtils.getTenantId((ConfigurationContext)OAuthUtils.getConfigContext());
                this.mtStore.put(tId, newStore);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return newStore;
        }
    }

    public static class OAuthRequestProvider
    implements Provider<OAuthRequest> {
        private final HttpFetcher fetcher;
        private final OAuthFetcherConfig config;

        @Inject
        public OAuthRequestProvider(HttpFetcher fetcher, OAuthFetcherConfig config) {
            this.fetcher = fetcher;
            this.config = config;
        }

        public OAuthRequest get() {
            return new OAuthRequest(this.config, this.fetcher);
        }
    }

    @Singleton
    public static class OAuthCrypterProvider
    implements Provider<BlobCrypter> {
        private final BlobCrypter crypter;

        @Inject
        public OAuthCrypterProvider(@Named(value="shindig.signing.state-key") String stateCrypterPath) throws IOException {
            if (StringUtils.isBlank((String)stateCrypterPath)) {
                logger.info((Object)"Using random key for OAuth client-side state encryption");
                this.crypter = new BasicBlobCrypter(Crypto.getRandomBytes((int)16));
            } else {
                logger.info((Object)("Using file " + stateCrypterPath + " for OAuth client-side state encryption"));
                this.crypter = new BasicBlobCrypter(new File(stateCrypterPath));
            }
        }

        public BlobCrypter get() {
            return this.crypter;
        }
    }
}

