/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.deployer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.dashboard.DashboardContext;
import org.wso2.carbon.dashboard.common.DashboardConstants;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class GadgetDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(GadgetDeployer.class);
    private static String REGISTRY_GADGET_STORAGE_PATH = DashboardConstants.SYSTEM_DASHBOARDS_REGISTRY_ROOT + DashboardConstants.GADGET_PATH;
    private static String GADGET_CONF_FILE = "gadget-conf.xml";
    private int tenantID = 0;

    public void init(ConfigurationContext configurationContext) {
        boolean created;
        this.tenantID = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)configurationContext).getTenantId();
        String artifactPath = CarbonUtils.getCarbonRepository() + "gadgets";
        File artifactsDir = new File(artifactPath);
        String serverName = ServerConfiguration.getInstance().getFirstProperty("Name").trim();
        if (serverName.contains("WSO2 Gadget Server") || serverName.contains("WSO2 Stratos Gadget Server")) {
            REGISTRY_GADGET_STORAGE_PATH = DashboardConstants.GS_REGISTRY_ROOT + DashboardConstants.GADGET_PATH;
        }
        if (!artifactsDir.exists() && !(created = artifactsDir.mkdir())) {
            log.debug((Object)("Directory could not be created at : " + artifactPath));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing Gadget Deployer..");
        }
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        try {
            UserRegistry registry = GadgetDeployer.getRegistry(this.tenantID);
            String extractedArchiveDir = this.extractGarArchive(deploymentFileData.getAbsolutePath());
            if (registry != null) {
                File gadgetsDir;
                AuthorizationManager accessControlAdmin = registry.getUserRealm().getAuthorizationManager();
                if (!accessControlAdmin.isRoleAuthorized("wso2.anonymous.role", "/_system/config" + REGISTRY_GADGET_STORAGE_PATH, "http://www.wso2.org/projects/registry/actions/get")) {
                    accessControlAdmin.authorizeRole("wso2.anonymous.role", "/_system/config" + REGISTRY_GADGET_STORAGE_PATH, "http://www.wso2.org/projects/registry/actions/get");
                }
                if ((gadgetsDir = new File(extractedArchiveDir)).exists()) {
                    GadgetDeployer.beginFileTansfer(gadgetsDir, this.tenantID);
                    log.info((Object)("Successfully populated gadgets from archive ." + deploymentFileData.getAbsolutePath() + " to the registry."));
                } else {
                    log.info((Object)("Couldn't find contents at '" + extractedArchiveDir + "'. Giving up."));
                }
            }
        }
        catch (RegistryException e) {
            throw new DeploymentException("An error occured while deploying gadget archive", (Throwable)e);
        }
        catch (CarbonException e) {
            throw new DeploymentException("An error occured while deploying gadget archive", (Throwable)e);
        }
        catch (UserStoreException e) {
            throw new DeploymentException("An error occured while deploying gadget archive", (Throwable)e);
        }
    }

    public void undeploy(String filePath) throws DeploymentException {
    }

    public static void beginFileTansfer(File rootDirectory, int tenantId) throws RegistryException {
        String rootPath = rootDirectory.getAbsolutePath();
        UserRegistry registry = GadgetDeployer.getRegistry(tenantId);
        Collection defaultGadgetCollection = registry.newCollection();
        try {
            registry.beginTransaction();
            registry.put(REGISTRY_GADGET_STORAGE_PATH, (Resource)defaultGadgetCollection);
            GadgetDeployer.transferDirectoryContentToRegistry(rootDirectory, (Registry)registry, rootPath, tenantId);
            registry.commitTransaction();
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void transferDirectoryContentToRegistry(File rootDirectory, Registry registry, String rootPath, int tenantId) throws Exception {
        try {
            File[] filesAndDirs = rootDirectory.listFiles();
            List<File> filesDirs = Arrays.asList(filesAndDirs);
            for (File file : filesDirs) {
                if (!file.isFile()) {
                    UserRegistry userRegistry;
                    AuthorizationManager accessControlAdmin;
                    String directoryRegistryPath = REGISTRY_GADGET_STORAGE_PATH + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
                    if (!registry.resourceExists(directoryRegistryPath)) {
                        Collection newCollection = registry.newCollection();
                        registry.put(directoryRegistryPath, (Resource)newCollection);
                    }
                    if (!(accessControlAdmin = (userRegistry = GadgetDeployer.getRegistry(tenantId)).getUserRealm().getAuthorizationManager()).isRoleAuthorized("wso2.anonymous.role", "/_system/config" + REGISTRY_GADGET_STORAGE_PATH, "http://www.wso2.org/projects/registry/actions/get")) {
                        accessControlAdmin.authorizeRole("wso2.anonymous.role", "/_system/config" + REGISTRY_GADGET_STORAGE_PATH, "http://www.wso2.org/projects/registry/actions/get");
                    }
                    GadgetDeployer.transferDirectoryContentToRegistry(file, registry, rootPath, tenantId);
                    continue;
                }
                if (file.getName().equals(GADGET_CONF_FILE)) {
                    FileInputStream fis = new FileInputStream(file);
                    XMLInputFactory xif = XMLInputFactory.newInstance();
                    XMLStreamReader reader = xif.createXMLStreamReader(fis);
                    StAXOMBuilder builder = new StAXOMBuilder(reader);
                    OMElement omEle = builder.getDocumentElement();
                    String gadgetName = omEle.getFirstChildWithName(new QName("name")).getText();
                    String gadgetPath = omEle.getFirstChildWithName(new QName("path")).getText();
                    String gadgetDesc = omEle.getFirstChildWithName(new QName("description")).getText();
                    Resource res = registry.newResource();
                    res.setProperty(DashboardConstants.GADGET_NAME, gadgetName);
                    res.setProperty(DashboardConstants.GADGET_DESC, gadgetDesc);
                    res.setProperty(DashboardConstants.GADGET_URL, gadgetPath);
                    registry.put(DashboardConstants.SYSTEM_GADGETREPO_REGISTRY_ROOT + DashboardConstants.GADGETS_COL + "/" + gadgetName, res);
                    continue;
                }
                GadgetDeployer.addToRegistry(rootPath, file, tenantId);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    private static void addToRegistry(String rootPath, File file, int tenantId) {
        try {
            UserRegistry registry = GadgetDeployer.getRegistry(tenantId);
            String fileRegistryPath = REGISTRY_GADGET_STORAGE_PATH + file.getAbsolutePath().substring(rootPath.length()).replaceAll("[/\\\\]+", "/");
            Resource fileResource = registry.newResource();
            fileResource.setMediaType("application/vnd.wso2-gadget+xml");
            fileResource.setContentStream((InputStream)new FileInputStream(file));
            registry.put(fileRegistryPath, fileResource);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String extractGarArchive(String garPath) throws CarbonException {
        garPath = AppDeployerUtils.formatPath((String)garPath);
        String fileName = garPath.substring(garPath.lastIndexOf(47) + 1);
        String destinationDir = AppDeployerUtils.APP_UNZIP_DIR + File.separator + System.currentTimeMillis() + fileName + File.separator;
        AppDeployerUtils.createDir((String)destinationDir);
        try {
            GadgetDeployer.extract(garPath, destinationDir);
        }
        catch (IOException e) {
            throw new CarbonException("Error while extracting cApp artifact : " + fileName, (Throwable)e);
        }
        return destinationDir;
    }

    private static void extract(String sourcePath, String destPath) throws IOException {
        ZipFile zipFile = new ZipFile(sourcePath);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                AppDeployerUtils.createDir((String)(destPath + entry.getName()));
                continue;
            }
            GadgetDeployer.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(destPath + entry.getName())));
        }
        zipFile.close();
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[40960];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    private static UserRegistry getRegistry(int tenantId) {
        UserRegistry registry = null;
        try {
            registry = (UserRegistry)DashboardContext.getRegistry(tenantId);
        }
        catch (Exception e) {
            registry = (UserRegistry)CarbonContext.getCurrentContext().getRegistry(RegistryType.SYSTEM_CONFIGURATION);
        }
        return registry;
    }

    public void setDirectory(String s) {
    }

    public void setExtension(String s) {
    }
}

