/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventing.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.savan.SavanException;
import org.apache.savan.configuration.Configurator;
import org.apache.savan.configuration.FilterBean;
import org.apache.savan.configuration.MappingRules;
import org.apache.savan.configuration.Protocol;
import org.apache.savan.configuration.SubscriberBean;
import org.apache.savan.filters.Filter;
import org.apache.savan.storage.SubscriberStore;
import org.apache.savan.subscribers.Subscriber;
import org.apache.savan.util.UtilFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.core.ServerManager;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryBasedConfigurator
implements Configurator {
    private final String PROTOCOLS = "protocols";
    private final String PROTOCOL = "protocol";
    private final String NAME = "name";
    private final String UTIL_FACTORY = "utilFactory";
    private final String MAPPING_RULES = "mapping-rules";
    private final String ACTION = "action";
    private final String SUBSCRIBER_STORES = "subscriberStores";
    private final String SUBSCRIBER_STORE = "subscriberStore";
    private final String FILTERS = "filters";
    private final String FILTER = "filter";
    private final String KEY = "key";
    private final String CLASS = "class";
    private final String IDENTIFIER = "identifier";
    private final String SUBSCRIBERS = "subscribers";
    private final String SUBSCRIBER = "subscriber";
    private final String DEFAULT_SUBSCRIBER = "defaultSubscriber";
    private final String DEFAULT_FILTER = "defaultFilter";
    private final String URL_APPENDER = "urlAppender";
    private HashMap protocolMap = null;
    private HashMap subscriberStoreNamesMap = null;
    private HashMap filterMap = null;
    private HashMap subscribersMap = null;

    public void configure() throws SavanException {
        this.updateRegitry();
        this.protocolMap = new HashMap();
        this.subscriberStoreNamesMap = new HashMap();
        this.filterMap = new HashMap();
        this.subscribersMap = new HashMap();
        this.loadRegistryConfiguration();
    }

    public void configure(ClassLoader arg0) throws SavanException {
        this.configure();
    }

    public void configure(File arg0) throws SavanException {
        this.configure();
    }

    public HashMap getFilters() {
        return this.filterMap;
    }

    public HashMap getProtocolMap() {
        return this.protocolMap;
    }

    public HashMap getSubscriberStoreNames() {
        return this.subscriberStoreNamesMap;
    }

    public HashMap getSubscribers() {
        return this.subscribersMap;
    }

    protected void loadRegistryConfiguration() throws SavanException {
        ServerManager manager = null;
        BundleContext context = null;
        ServiceReference reference = null;
        RegistryService registryService = null;
        UserRegistry systemRegistry = null;
        Resource resource = null;
        String content = null;
        try {
            manager = ServerManager.getInstance();
            context = manager.getBundleContext();
            reference = context.getServiceReference(RegistryService.class.getName());
            registryService = (RegistryService)context.getService(reference);
            systemRegistry = registryService.getSystemRegistry();
            if (systemRegistry.resourceExists("/carbon/eventing/protocols")) {
                resource = systemRegistry.get("/carbon/eventing/protocols");
                content = new String((byte[])resource.getContent());
                this.processProtocols(AXIOMUtil.stringToOM((String)content));
            }
            if (systemRegistry.resourceExists("/carbon/eventing/subscribers")) {
                resource = systemRegistry.get("/carbon/eventing/subscribers");
                content = new String((byte[])resource.getContent());
                this.processSubscribers(AXIOMUtil.stringToOM((String)content));
            }
            if (systemRegistry.resourceExists("/carbon/eventing/subscriberStores")) {
                resource = systemRegistry.get("/carbon/eventing/subscriberStores");
                content = new String((byte[])resource.getContent());
                this.processSubscriberStores(AXIOMUtil.stringToOM((String)content));
            }
            if (systemRegistry.resourceExists("/carbon/eventing/filters")) {
                resource = systemRegistry.get("/carbon/eventing/filters");
                content = new String((byte[])resource.getContent());
                this.processFilters(AXIOMUtil.stringToOM((String)content));
            }
        }
        catch (Exception e) {
            throw new SavanException(e);
        }
    }

    protected void updateRegitry() throws SavanException {
        ServerManager manager = null;
        BundleContext context = null;
        ServiceReference reference = null;
        RegistryService registryService = null;
        UserRegistry systemRegistry = null;
        Resource resource = null;
        try {
            manager = ServerManager.getInstance();
            context = manager.getBundleContext();
            reference = context.getServiceReference(RegistryService.class.getName());
            registryService = (RegistryService)context.getService(reference);
            systemRegistry = registryService.getSystemRegistry();
            if (!systemRegistry.resourceExists("/carbon/eventing/subscribers")) {
                resource = systemRegistry.newResource();
                resource.setContent((Object)this.getDefaultSubcribers().toString());
                systemRegistry.put("/carbon/eventing/subscribers", resource);
            }
            if (!systemRegistry.resourceExists("/carbon/eventing/subscriberStores")) {
                resource = systemRegistry.newResource();
                resource.setContent((Object)this.getDefaultSubcriberStores().toString());
                systemRegistry.put("/carbon/eventing/subscriberStores", resource);
            }
            if (!systemRegistry.resourceExists("/carbon/eventing/filters")) {
                resource = systemRegistry.newResource();
                resource.setContent((Object)this.getDefaultFilters().toString());
                systemRegistry.put("/carbon/eventing/filters", resource);
            }
            if (!systemRegistry.resourceExists("/carbon/eventing/protocols")) {
                resource = systemRegistry.newResource();
                resource.setContent((Object)this.getDefaultProtocols().toString());
                systemRegistry.put("/carbon/eventing/protocols", resource);
            }
        }
        catch (Exception e) {
            throw new SavanException(e);
        }
    }

    private OMElement getDefaultSubcriberStores() {
        OMElement subscriberStores = null;
        OMFactory factory = null;
        OMElement subscriberStore = null;
        OMElement key = null;
        OMElement clazz = null;
        factory = OMAbstractFactory.getOMFactory();
        subscriberStores = factory.createOMElement(new QName("subscriberStores"));
        subscriberStore = factory.createOMElement(new QName("subscriberStore"));
        key = factory.createOMElement(new QName("key"));
        key.setText("default");
        clazz = factory.createOMElement(new QName("class"));
        clazz.setText("org.wso2.carbon.eventing.subscription.SubscriptionManagerAdapter");
        subscriberStore.addChild((OMNode)key);
        subscriberStore.addChild((OMNode)clazz);
        subscriberStores.addChild((OMNode)subscriberStore);
        return subscriberStores;
    }

    private OMElement getDefaultSubcribers() {
        OMElement subscribers = null;
        OMFactory factory = null;
        OMElement subscriber = null;
        OMElement name = null;
        OMElement clazz = null;
        factory = OMAbstractFactory.getOMFactory();
        subscribers = factory.createOMElement(new QName("subscribers"));
        subscriber = factory.createOMElement(new QName("subscriber"));
        name = factory.createOMElement(new QName("name"));
        name.setText("eventing");
        clazz = factory.createOMElement(new QName("class"));
        clazz.setText("org.apache.savan.eventing.subscribers.EventingSubscriber");
        subscriber.addChild((OMNode)name);
        subscriber.addChild((OMNode)clazz);
        subscribers.addChild((OMNode)subscriber);
        return subscribers;
    }

    private OMElement getDefaultFilters() {
        OMElement filters = null;
        OMFactory factory = null;
        OMElement filter = null;
        OMElement name = null;
        OMElement identifier = null;
        OMElement clazz = null;
        OMElement filterXpath = null;
        OMElement nameXpath = null;
        OMElement identifierXpath = null;
        OMElement clazzXpath = null;
        factory = OMAbstractFactory.getOMFactory();
        filters = factory.createOMElement(new QName("filters"));
        filter = factory.createOMElement(new QName("filter"));
        name = factory.createOMElement(new QName("name"));
        name.setText("empty");
        identifier = factory.createOMElement(new QName("identifier"));
        identifier.setText("empty");
        clazz = factory.createOMElement(new QName("class"));
        clazz.setText("org.apache.savan.filters.EmptyFilter");
        filter.addChild((OMNode)name);
        filter.addChild((OMNode)clazz);
        filterXpath = factory.createOMElement(new QName("filter"));
        nameXpath = factory.createOMElement(new QName("name"));
        nameXpath.setText("xpath");
        identifierXpath = factory.createOMElement(new QName("identifier"));
        identifierXpath.setText("http:// www.w3.org/TR/1999/REC-xpath-19991116");
        clazzXpath = factory.createOMElement(new QName("class"));
        clazzXpath.setText("org.apache.savan.filters.XPathBasedFilter");
        filterXpath.addChild((OMNode)nameXpath);
        filterXpath.addChild((OMNode)clazzXpath);
        filters.addChild((OMNode)filter);
        filters.addChild((OMNode)filterXpath);
        return filter;
    }

    private OMElement getDefaultProtocols() {
        OMElement protocols = null;
        OMFactory factory = null;
        OMElement protocol = null;
        OMElement name = null;
        OMElement utilFactory = null;
        OMElement mappingRules = null;
        OMElement action = null;
        OMElement defaultSubscriber = null;
        OMElement defaultFilter = null;
        factory = OMAbstractFactory.getOMFactory();
        protocols = factory.createOMElement(new QName("protocols"));
        protocol = factory.createOMElement(new QName("protocol"));
        name = factory.createOMElement(new QName("name"));
        name.setText("eventing");
        utilFactory = factory.createOMElement(new QName("utilFactory"));
        utilFactory.setText("org.apache.savan.eventing.EventingUtilFactory");
        mappingRules = factory.createOMElement(new QName("mapping-rules"));
        action = factory.createOMElement(new QName("action"));
        action.setText("http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe");
        mappingRules.addChild((OMNode)action);
        action = factory.createOMElement(new QName("action"));
        action.setText("http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew");
        mappingRules.addChild((OMNode)action);
        action = factory.createOMElement(new QName("action"));
        action.setText("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus");
        mappingRules.addChild((OMNode)action);
        action = factory.createOMElement(new QName("action"));
        action.setText("http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe");
        mappingRules.addChild((OMNode)action);
        action = factory.createOMElement(new QName("action"));
        action.setText("http://wso2.com/ws/2007/05/eventing/Publish");
        mappingRules.addChild((OMNode)action);
        defaultSubscriber = factory.createOMElement(new QName("defaultSubscriber"));
        defaultSubscriber.setText("eventing");
        defaultFilter = factory.createOMElement(new QName("defaultFilter"));
        defaultFilter.setText("empty");
        protocol.addChild((OMNode)name);
        protocol.addChild((OMNode)utilFactory);
        protocol.addChild((OMNode)mappingRules);
        protocol.addChild((OMNode)defaultSubscriber);
        protocol.addChild((OMNode)defaultFilter);
        protocols.addChild((OMNode)protocol);
        return protocols;
    }

    private void processProtocols(OMElement element) throws SavanException {
        Iterator protocolElementsIterator = null;
        protocolElementsIterator = element.getChildrenWithName(new QName("protocol"));
        while (protocolElementsIterator.hasNext()) {
            OMElement protocolElement = null;
            protocolElement = (OMElement)protocolElementsIterator.next();
            this.processProtocol(protocolElement);
        }
    }

    private void processProtocol(OMElement element) throws SavanException {
        Protocol protocol = null;
        OMElement nameElement = null;
        String name = null;
        OMElement utilFactoryNameElement = null;
        String utilFactoryName = null;
        Object utilFactory = null;
        OMElement mappingRulesElement = null;
        OMElement defaultSubscriberElement = null;
        String defaultSubscriber = null;
        OMElement defaultFilterElement = null;
        String defaultFilter = null;
        protocol = new Protocol();
        nameElement = element.getFirstChildWithName(new QName("name"));
        if (nameElement == null) {
            throw new SavanException("Protocol must have a 'Name' subelement");
        }
        name = nameElement.getText();
        protocol.setName(name);
        utilFactoryNameElement = element.getFirstChildWithName(new QName("utilFactory"));
        if (utilFactoryNameElement == null) {
            throw new SavanException("Protocol must have a 'UtilFactory' subelement");
        }
        utilFactoryName = utilFactoryNameElement.getText();
        utilFactory = this.getObject(utilFactoryName);
        if (!(utilFactory instanceof UtilFactory)) {
            throw new SavanException("UtilFactory element" + utilFactoryName + "is not a subtype of the UtilFactory class");
        }
        protocol.setUtilFactory((UtilFactory)utilFactory);
        mappingRulesElement = element.getFirstChildWithName(new QName("mapping-rules"));
        if (mappingRulesElement == null) {
            throw new SavanException("Protocol must have a 'mappingRules' sub-element");
        }
        this.processMappingRules(mappingRulesElement, protocol);
        defaultSubscriberElement = element.getFirstChildWithName(new QName("defaultSubscriber"));
        if (defaultSubscriberElement == null) {
            throw new SavanException("Protocols must have a 'defaultSubscriber' sub-element");
        }
        defaultSubscriber = defaultSubscriberElement.getText();
        protocol.setDefaultSubscriber(defaultSubscriber);
        defaultFilterElement = element.getFirstChildWithName(new QName("defaultFilter"));
        if (defaultFilterElement == null) {
            throw new SavanException("Protocols must have a 'defaultFilter' sub-element");
        }
        defaultFilter = defaultFilterElement.getText();
        protocol.setDefaultFilter(defaultFilter);
        this.protocolMap.put(protocol.getName(), protocol);
    }

    private void processMappingRules(OMElement element, Protocol protocol) {
        MappingRules mappingRules = null;
        Iterator actionsIterator = null;
        mappingRules = protocol.getMappingRules();
        actionsIterator = element.getChildrenWithName(new QName("action"));
        while (actionsIterator.hasNext()) {
            OMElement actionElement = null;
            String action = null;
            actionElement = (OMElement)actionsIterator.next();
            action = actionElement.getText();
            mappingRules.addRule(1, action);
        }
    }

    private void processSubscriberStores(OMElement element) throws SavanException {
        Iterator subscriberStoreElementsIterator = null;
        subscriberStoreElementsIterator = element.getChildrenWithName(new QName("subscriberStore"));
        while (subscriberStoreElementsIterator.hasNext()) {
            OMElement subscriberStoreElement = (OMElement)subscriberStoreElementsIterator.next();
            this.processSubscriberStore(subscriberStoreElement);
        }
    }

    private void processSubscriberStore(OMElement element) throws SavanException {
        OMElement keyElement = null;
        String key = null;
        OMElement classElement = null;
        String clazz = null;
        Object subscriberStore = null;
        keyElement = element.getFirstChildWithName(new QName("key"));
        if (keyElement == null) {
            throw new SavanException("SubscriberStore must have a 'key' subelement");
        }
        key = keyElement.getText();
        classElement = element.getFirstChildWithName(new QName("class"));
        if (classElement == null) {
            throw new SavanException("SubscriberStore must have a 'Clazz' subelement'");
        }
        clazz = classElement.getText();
        subscriberStore = this.getObject(clazz);
        if (!(subscriberStore instanceof SubscriberStore)) {
            String message = "Class " + clazz + " does not implement the  SubscriberStore interface.";
            throw new SavanException(message);
        }
        this.subscriberStoreNamesMap.put(key, clazz);
    }

    private Object getObject(String className) throws SavanException {
        Object obj = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            String message = "Can't instantiate the class:" + className;
            throw new SavanException(message, e);
        }
        return obj;
    }

    private void processFilters(OMElement element) throws SavanException {
        Iterator filterElementsIterator = element.getChildrenWithName(new QName("filter"));
        while (filterElementsIterator.hasNext()) {
            OMElement filterElement = (OMElement)filterElementsIterator.next();
            this.processFilter(filterElement);
        }
    }

    private void processFilter(OMElement element) throws SavanException {
        OMElement nameElement = null;
        OMElement identifierElement = null;
        OMElement classElement = null;
        String name = null;
        String identifier = null;
        String clazz = null;
        Object filter = null;
        FilterBean bean = null;
        nameElement = element.getFirstChildWithName(new QName("name"));
        identifierElement = element.getFirstChildWithName(new QName("identifier"));
        classElement = element.getFirstChildWithName(new QName("class"));
        if (nameElement == null) {
            throw new SavanException("Name element is not present within the Filter");
        }
        if (identifierElement == null) {
            throw new SavanException("Identifier element is not present within the Filter");
        }
        if (classElement == null) {
            throw new SavanException("Class element is not present within the Filter");
        }
        name = nameElement.getText();
        identifier = identifierElement.getText();
        clazz = classElement.getText();
        filter = this.getObject(clazz);
        if (!(filter instanceof Filter)) {
            String message = "Class " + clazz + " does not implement the  Filter interface.";
            throw new SavanException(message);
        }
        bean = new FilterBean();
        bean.setName(name);
        bean.setIdentifier(identifier);
        bean.setClazz(clazz);
        this.filterMap.put(identifier, bean);
    }

    private void processSubscribers(OMElement element) throws SavanException {
        Iterator subscriberElementsIterator = element.getChildrenWithName(new QName("subscriber"));
        while (subscriberElementsIterator.hasNext()) {
            OMElement subscriberElement = (OMElement)subscriberElementsIterator.next();
            this.processSubscriber(subscriberElement);
        }
    }

    private void processSubscriber(OMElement element) throws SavanException {
        OMElement nameElement = null;
        OMElement urlAppenderElement = null;
        OMElement classElement = null;
        String name = null;
        String clazz = null;
        Object subscriber = null;
        SubscriberBean bean = null;
        nameElement = element.getFirstChildWithName(new QName("name"));
        urlAppenderElement = element.getFirstChildWithName(new QName("urlAppender"));
        classElement = element.getFirstChildWithName(new QName("class"));
        if (nameElement == null) {
            throw new SavanException("Name element is not present within the AbstractSubscriber");
        }
        if (classElement == null) {
            throw new SavanException("Class element is not present within the Filter");
        }
        name = nameElement.getText();
        clazz = classElement.getText();
        subscriber = this.getObject(clazz);
        if (!(subscriber instanceof Subscriber)) {
            String message = "Class " + clazz + " does not implement the  Subscriber interface.";
            throw new SavanException(message);
        }
        bean = new SubscriberBean();
        bean.setName(name);
        bean.setClazz(clazz);
        this.subscribersMap.put(name, bean);
    }
}

