/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventing.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.eventing.service.dto.SubscriptionDTO;
import org.wso2.eventing.Subscription;
import org.wso2.eventing.SubscriptionManager;
import org.wso2.eventing.exceptions.EventException;

public class EventingAdminService {
    private static final Log log = LogFactory.getLog(EventingAdminService.class);

    public String[] getValidSubscriptions(String serviceName) throws AxisFault {
        AxisService service = null;
        SubscriptionManager manager = null;
        Parameter parameter = null;
        ArrayList<String> subscribers = null;
        service = this.getAxisService(serviceName);
        parameter = service.getParameter("SubscriberStore");
        if (parameter == null) {
            parameter = service.getParameter("subscriptionManager");
        }
        if (parameter == null) {
            return null;
        }
        subscribers = new ArrayList<String>();
        List list = null;
        Subscription subscription2 = null;
        manager = (SubscriptionManager)parameter.getValue();
        try {
            list = manager.getSubscribers();
            for (Subscription subscription2 : list) {
                if (this.checkExpired(subscription2)) continue;
                subscribers.add(subscription2.getId());
            }
        }
        catch (EventException e) {
            String message = "Error while retrieving valid subscriptions";
            log.error((Object)message, (Throwable)e);
            throw new AxisFault(message, (Throwable)e);
        }
        return subscribers.toArray(new String[subscribers.size()]);
    }

    public String[] getExpiredSubscriptions(String serviceName) throws AxisFault {
        AxisService service = null;
        SubscriptionManager manager = null;
        Parameter parameter = null;
        ArrayList<String> subscribers = null;
        service = this.getAxisService(serviceName);
        parameter = service.getParameter("SubscriberStore");
        if (parameter == null) {
            parameter = service.getParameter("subscriptionManager");
        }
        if (parameter == null) {
            return null;
        }
        subscribers = new ArrayList<String>();
        List list = null;
        Subscription subscription2 = null;
        manager = (SubscriptionManager)parameter.getValue();
        try {
            list = manager.getSubscribers();
            for (Subscription subscription2 : list) {
                if (!this.checkExpired(subscription2)) continue;
                subscribers.add(subscription2.getId());
            }
        }
        catch (EventException e) {
            String message = "Error while retrieving expired subscriptions";
            log.error((Object)message, (Throwable)e);
            throw new AxisFault(message, (Throwable)e);
        }
        return subscribers.toArray(new String[subscribers.size()]);
    }

    public SubscriptionDTO getSubscriptionDetails(String serviceName, String subscriberId) throws AxisFault {
        AxisService service = null;
        Parameter parameter = null;
        SubscriptionDTO details = null;
        SubscriptionManager manager = null;
        service = this.getAxisService(serviceName);
        parameter = service.getParameter("SubscriberStore");
        if (parameter == null) {
            parameter = service.getParameter("subscriptionManager");
        }
        if (parameter == null) {
            return null;
        }
        Subscription subscription = null;
        manager = (SubscriptionManager)parameter.getValue();
        try {
            subscription = manager.getSubscription(subscriberId);
        }
        catch (EventException e) {
            String message = "Error while retrieving subscription details for " + subscriberId;
            log.error((Object)message, (Throwable)e);
            throw new AxisFault(message, (Throwable)e);
        }
        details = new SubscriptionDTO();
        if (subscription.getExpires() != null) {
            details.setSubscriptionEndingTime(subscription.getExpires().getTime());
        }
        details.setEpr(subscription.getAddressUrl());
        details.setDiliveryMode(subscription.getDeliveryMode());
        if (subscription.getSubscriptionData() != null) {
            String dialect;
            String filterVal = (String)subscription.getSubscriptionData().getProperty("filter");
            if (filterVal != null) {
                details.setFilterValue(filterVal);
            }
            if ((dialect = (String)subscription.getSubscriptionData().getProperty("dialect")) != null) {
                details.setDialect(dialect);
            }
        }
        return details;
    }

    private AxisService getAxisService(String serviceName) throws AxisFault {
        AxisConfiguration axisConfig = MessageContext.getCurrentMessageContext().getConfigurationContext().getAxisConfiguration();
        return axisConfig.getServiceForActivation(serviceName);
    }

    private boolean checkExpired(Subscription subscription) {
        if (subscription.getExpires() != null) {
            Calendar calendarSubscription;
            Calendar calendarCurrent = Calendar.getInstance();
            return !calendarCurrent.before(calendarSubscription = subscription.getExpires());
        }
        return false;
    }
}

