/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventing.subscription;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.savan.eventing.subscribers.EventingSubscriber;
import org.apache.savan.storage.DefaultSubscriberStore;
import org.wso2.eventing.Subscription;
import org.wso2.eventing.SubscriptionManager;
import org.wso2.eventing.exceptions.EventException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionManagerAdapter
extends DefaultSubscriberStore
implements SubscriptionManager {
    public List<Subscription> getAllSubscribers() throws EventException {
        return this.getSubscribers();
    }

    public List<Subscription> getSubscribers() throws EventException {
        ArrayList<Subscription> subscriptions = null;
        subscriptions = new ArrayList<Subscription>();
        Iterator iter = this.retrieveAllSubscribers();
        while (iter.hasNext()) {
            EventingSubscriber subscriber = (EventingSubscriber)iter.next();
            if (subscriber == null || subscriber.getId() == null) continue;
            subscriptions.add(this.getSubscription(subscriber));
        }
        return subscriptions;
    }

    public Subscription getSubscription(String subscriptionID) throws EventException {
        return this.getSubscription((EventingSubscriber)this.retrieve(subscriptionID));
    }

    public String renew(Subscription subscription) throws EventException {
        return null;
    }

    public String subscribe(Subscription subscription) throws EventException {
        return null;
    }

    public boolean unsubscribe(Subscription subscription) throws EventException {
        return false;
    }

    public Subscription getStatus(Subscription subscription) throws EventException {
        return null;
    }

    private Subscription getSubscription(EventingSubscriber subscriber) {
        Subscription subscription = null;
        Calendar calender = null;
        subscription = new Subscription();
        subscription.setId(subscriber.getId().toASCIIString());
        if (subscriber.getDelivery() != null) {
            subscription.setDeliveryMode(subscriber.getDelivery().getDeliveryMode());
            if (subscriber.getDelivery().getDeliveryEPR() != null) {
                subscription.setAddressUrl(subscriber.getDelivery().getDeliveryEPR().getAddress());
                subscription.setEndpointUrl(subscriber.getDelivery().getDeliveryEPR().getAddress());
            }
        }
        if (subscriber.getSubscriptionEndingTime() != null) {
            calender = Calendar.getInstance();
            calender.setTime(subscriber.getSubscriptionEndingTime());
            subscription.setExpires(calender);
        }
        return subscription;
    }
}

