/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventing.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.savan.configuration.ConfigurationManager;
import org.apache.savan.configuration.Configurator;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.eventing.configuration.RegistryBasedConfigurator;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class EventingServiceComponent {
    private static Log log = LogFactory.getLog(EventingServiceComponent.class);
    private ConfigurationContext configContext;
    private static Registry registry;

    protected void activate(ComponentContext ctxt) {
        ConfigurationManager manager = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Eventing bundle is activated ");
            }
            manager = new ConfigurationManager((Configurator)new RegistryBasedConfigurator());
            manager.configure();
            this.configContext.setProperty("SavanConfigurationManager", (Object)manager);
        }
        catch (Throwable e) {
            log.error((Object)"Error occured while activating Eventing bundle", e);
        }
    }

    public static Registry getRegistry() {
        return registry;
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Eventing bundle is deactivated");
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ConfigurationContextService set in Eventing bundle");
        }
        this.configContext = contextService.getServerConfigContext();
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ConfigurationContextService unset in Eventing bundle");
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"RegistryService set in Eventing bundle");
        }
        try {
            registry = registryService.getSystemRegistry();
        }
        catch (Throwable e) {
            log.error((Object)"Failed to set RegistryService in eventing bundle", e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"RegistryService unset in Eventing bundle");
        }
    }
}

