/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.eventing.subscription;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMAttributeImpl;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.savan.SavanException;
import org.apache.savan.SavanMessageContext;
import org.apache.savan.eventing.Delivery;
import org.apache.savan.eventing.subscribers.EventingSubscriber;
import org.apache.savan.filters.Filter;
import org.apache.savan.filters.XPathBasedFilter;
import org.apache.savan.storage.DefaultSubscriberStore;
import org.apache.savan.subscribers.Subscriber;
import org.wso2.carbon.core.RegistryResources;
import org.wso2.carbon.eventing.internal.EventingServiceComponent;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;

public class RegistryBasedSubscriberStore
extends DefaultSubscriberStore {
    private String serviceName;
    private SavanMessageContext config;
    private static final Log log = LogFactory.getLog(RegistryBasedSubscriberStore.class);
    private static final String SUBSCRIPTION = "subscription";

    public void init(SavanMessageContext savanContext) throws SavanException {
        this.config = savanContext;
        this.serviceName = this.config.getMessageContext().getAxisService().getName();
    }

    public Subscriber retrieve(String subscriberId) {
        Registry systemRegistry = null;
        Resource resource = null;
        try {
            systemRegistry = EventingServiceComponent.getRegistry();
            if (systemRegistry.resourceExists(RegistryResources.ROOT + "eventing/" + this.serviceName + "/subscribers/" + subscriberId)) {
                resource = systemRegistry.get(RegistryResources.ROOT + "eventing/" + this.serviceName + "/subscribers/" + subscriberId);
                return this.getSubscriber(resource);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while retrieving subscribers for event source " + this.serviceName), (Throwable)e);
            return null;
        }
        return null;
    }

    public Iterator retrieveAllSubscribers() {
        Registry systemRegistry = null;
        CollectionImpl resourceCollection = null;
        ArrayList<Subscriber> allSubscribers = new ArrayList<Subscriber>();
        try {
            systemRegistry = EventingServiceComponent.getRegistry();
            if (systemRegistry.resourceExists(RegistryResources.ROOT + "eventing/" + this.serviceName + "/subscribers")) {
                resourceCollection = (CollectionImpl)systemRegistry.get(RegistryResources.ROOT + "eventing/" + this.serviceName + "/subscribers");
                String[] resources = resourceCollection.getChildren();
                for (int i = 0; i < resources.length; ++i) {
                    allSubscribers.add(this.getSubscriber(systemRegistry.get(resources[i])));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while retrieving subscribers for event source " + this.serviceName), (Throwable)e);
            return null;
        }
        return allSubscribers.iterator();
    }

    public void store(Subscriber subscriber) {
        Registry systemRegistry = null;
        Resource resource = null;
        try {
            systemRegistry = EventingServiceComponent.getRegistry();
            resource = this.getResource(subscriber, systemRegistry);
            systemRegistry.put(RegistryResources.ROOT + "eventing/" + this.serviceName + "/subscribers/" + subscriber.getId().toASCIIString(), resource);
        }
        catch (Exception e) {
            log.error((Object)("Error while storing subscribers for event source " + this.serviceName), (Throwable)e);
        }
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    private Subscriber getSubscriber(Resource resource) throws Exception {
        EventingSubscriber subscriber = null;
        String content = null;
        OMElement payload = null;
        subscriber = new EventingSubscriber();
        if (this.config != null) {
            subscriber.setConfigurationContext(this.config.getConfigurationContext());
        }
        content = new String((byte[])resource.getContent());
        payload = AXIOMUtil.stringToOM((String)content);
        subscriber.setEndToEPr(this.getEndToEpr(payload));
        subscriber.setDelivery(this.getDelivery(payload));
        subscriber.setFilter(this.getFilter(payload));
        subscriber.setId(this.getId(payload));
        subscriber.setSubscriptionEndingTime(this.getSubscriptionEndingTime(payload));
        return subscriber;
    }

    private EndpointReference getEndToEpr(OMElement payload) {
        EndpointReference epr = null;
        OMElement eprElement = null;
        epr = new EndpointReference();
        eprElement = payload.getFirstChildWithName(new QName("http://wso2.org/eventing/epr", "EndpointReference", "epr"));
        if (eprElement != null) {
            epr.setAddress(eprElement.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "Address", "wsa")).getText());
        }
        return epr;
    }

    private Date getSubscriptionEndingTime(OMElement payload) {
        OMElement endTimeElement = null;
        endTimeElement = payload.getFirstChildWithName(new QName("EndTime"));
        if (endTimeElement != null) {
            return new Date(endTimeElement.getText());
        }
        return null;
    }

    private URI getId(OMElement payload) throws URISyntaxException {
        return new URI(payload.getAttributeValue(new QName("id")));
    }

    private Delivery getDelivery(OMElement payload) {
        Delivery delivery = null;
        OMElement deliveryElement = null;
        delivery = new Delivery();
        deliveryElement = payload.getFirstChildWithName(new QName("Delivery"));
        if (deliveryElement != null) {
            String mode = deliveryElement.getAttributeValue(new QName("mode"));
            delivery.setDeliveryMode(mode);
            delivery.setDeliveryEPR(this.getEndToEpr(deliveryElement));
        }
        return delivery;
    }

    private Filter getFilter(OMElement payload) {
        OMElement endTimeElement = null;
        XPathBasedFilter filter = null;
        endTimeElement = payload.getFirstChildWithName(new QName("Filter"));
        if (endTimeElement != null) {
            filter = new XPathBasedFilter();
            filter.setXPathString(endTimeElement.getText());
        }
        return filter;
    }

    private Resource getResource(Subscriber subscriber, Registry registry) throws Exception {
        EventingSubscriber eventingSub = null;
        Resource resource = null;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement payload = factory.createOMElement(SUBSCRIPTION, null);
        if (subscriber instanceof EventingSubscriber) {
            eventingSub = (EventingSubscriber)subscriber;
            this.addId(payload, eventingSub.getId());
            this.addSubscriptionEndingTime(payload, eventingSub.getSubscriptionEndingTime());
            if (eventingSub.getDelivery() != null) {
                this.addDelivery(payload, eventingSub.getDelivery());
            }
            if (eventingSub.getEndToEPr() != null) {
                this.addEndToEpr(payload, eventingSub.getEndToEPr());
            }
            if (eventingSub.getFilter() != null) {
                this.addFilter(payload, eventingSub.getFilter());
            }
            resource = registry.newResource();
            resource.setContent((Object)payload.toString());
        }
        return resource;
    }

    private void addEndToEpr(OMElement payload, EndpointReference epr) throws AxisFault {
        payload.addChild((OMNode)epr.toOM("http://wso2.org/eventing/epr", "EndpointReference", "epr"));
    }

    private void addSubscriptionEndingTime(OMElement payload, Date endtime) {
        OMFactory factory = null;
        OMElement endTimeElement = null;
        factory = OMAbstractFactory.getOMFactory();
        endTimeElement = factory.createOMElement(new QName("EndTime"));
        endTimeElement.setText(endtime.toLocaleString());
        payload.addChild((OMNode)endTimeElement);
    }

    private void addId(OMElement payload, URI id) {
        OMFactory factory = null;
        OMAttributeImpl attribute = null;
        factory = OMAbstractFactory.getOMFactory();
        attribute = new OMAttributeImpl("id", null, id.toString(), factory);
        payload.addAttribute((OMAttribute)attribute);
    }

    private void addDelivery(OMElement payload, Delivery delivery) throws AxisFault {
        OMFactory factory = null;
        OMAttributeImpl attribute = null;
        OMElement deliveryElement = null;
        factory = OMAbstractFactory.getOMFactory();
        attribute = new OMAttributeImpl("mode", null, delivery.getDeliveryMode(), factory);
        deliveryElement = factory.createOMElement(new QName("Delivery"));
        deliveryElement.addAttribute((OMAttribute)attribute);
        this.addEndToEpr(deliveryElement, delivery.getDeliveryEPR());
        payload.addChild((OMNode)deliveryElement);
    }

    private void addFilter(OMElement payload, Filter filter) {
        OMFactory factory = null;
        OMElement filterElement = null;
        factory = OMAbstractFactory.getOMFactory();
        filterElement = factory.createOMElement(new QName("Filter"));
        if (filter.getFilterValue() != null) {
            filterElement.setText(filter.getFilterValue().toString());
            payload.addChild((OMNode)filterElement);
        }
    }
}

