/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.api.event.HumanTaskEventListener;
import org.wso2.carbon.humantask.core.api.scheduler.Scheduler;
import org.wso2.carbon.humantask.core.configuration.HumanTaskServerConfiguration;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnectionFactory;
import org.wso2.carbon.humantask.core.db.Database;
import org.wso2.carbon.humantask.core.engine.HumanTaskEngine;
import org.wso2.carbon.humantask.core.engine.HumanTaskServerException;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.engine.event.processor.EventProcessor;
import org.wso2.carbon.humantask.core.scheduler.JobProcessorImpl;
import org.wso2.carbon.humantask.core.scheduler.SimpleScheduler;
import org.wso2.carbon.humantask.core.store.HumanTaskStoreManager;
import org.wso2.carbon.humantask.core.utils.GUID;
import org.wso2.carbon.utils.CarbonUtils;

public class HumanTaskServer {
    private static final Log log = LogFactory.getLog(HumanTaskServer.class);
    private HumanTaskServerConfiguration serverConfig;
    private HumanTaskEngine taskEngine;
    private Database database;
    private HumanTaskStoreManager taskStoreManager;
    private TransactionManager tnxManager;
    private HumanTaskDAOConnectionFactory daoConnectionFactory;
    private Scheduler scheduler;
    private EventProcessor eventProcessor;

    public void init() throws HumanTaskServerException {
        this.loadHumanTaskServerConfiguration();
        this.initTransactionManager();
        this.initDataSource();
        this.initDAO();
        this.initEventProcessor();
        this.initHumanTaskEngine();
        this.initPeopleQueryEvaluator();
        this.initHumanTaskStore();
        this.initScheduler();
    }

    private void initScheduler() {
        ThreadFactory threadFactory = new ThreadFactory(){
            private int threadNumber = 0;

            public Thread newThread(Runnable r) {
                ++this.threadNumber;
                Thread t = new Thread(r, "HumanTaskServer-" + this.threadNumber);
                t.setDaemon(true);
                return t;
            }
        };
        ExecutorService executorService = Executors.newFixedThreadPool(this.serverConfig.getThreadPoolMaxSize(), threadFactory);
        SimpleScheduler simpleScheduler = new SimpleScheduler(new GUID().toString());
        simpleScheduler.setExecutorService(executorService);
        simpleScheduler.setTransactionManager(this.tnxManager);
        this.taskEngine.setScheduler(simpleScheduler);
        simpleScheduler.setJobProcessor(new JobProcessorImpl());
        simpleScheduler.start();
        this.scheduler = simpleScheduler;
    }

    private void initPeopleQueryEvaluator() throws HumanTaskServerException {
        try {
            PeopleQueryEvaluator peopleQueryEvaluator = (PeopleQueryEvaluator)Class.forName(this.serverConfig.getPeopleQueryEvaluatorClass()).newInstance();
            this.taskEngine.setPeopleQueryEvaluator(peopleQueryEvaluator);
        }
        catch (Exception ex) {
            String errMsg = "Error instantiating the PeopleQueryEvaluator Class :" + this.serverConfig.getPeopleQueryEvaluatorClass();
            log.error((Object)errMsg);
            throw new HumanTaskServerException(errMsg, ex);
        }
    }

    private void initHumanTaskEngine() {
        HumanTaskEngine humanTaskEngine = new HumanTaskEngine();
        humanTaskEngine.setDaoConnectionFactory(this.daoConnectionFactory);
        humanTaskEngine.setEventProcessor(this.eventProcessor);
        this.taskEngine = humanTaskEngine;
    }

    private void initDataSource() throws HumanTaskServerException {
        this.database = new Database(this.serverConfig);
        this.database.setTransactionManager(this.tnxManager);
        try {
            this.database.start();
        }
        catch (Exception e) {
            String errMsg = "Humantask Database Initialization failed.";
            log.error((Object)errMsg);
            throw new HumanTaskServerException(errMsg, e);
        }
    }

    private void initDAO() throws HumanTaskServerException {
        try {
            this.daoConnectionFactory = this.database.createDAOConnectionFactory();
        }
        catch (Exception e) {
            String errMsg = "Error instantiating the DAO Connection Factory Class :" + this.serverConfig.getDaoConnectionFactoryClass();
            throw new HumanTaskServerException(errMsg, e);
        }
    }

    private void initEventProcessor() throws HumanTaskServerException {
        EventProcessor eventProcessor = new EventProcessor();
        for (String eventListenerClassName : this.serverConfig.getEventListenerClassNames()) {
            try {
                Class<?> eventListenerClass = this.getClass().getClassLoader().loadClass(eventListenerClassName);
                HumanTaskEventListener eventListener = (HumanTaskEventListener)eventListenerClass.newInstance();
                eventProcessor.addEventListener(eventListener);
            }
            catch (Exception e) {
                log.fatal((Object)("Couldn't initialize the event listener for class: " + eventListenerClassName), (Throwable)e);
                throw new HumanTaskServerException("Couldn't initialize a event listener: " + eventListenerClassName, e);
            }
        }
        this.eventProcessor = eventProcessor;
    }

    private void initHumanTaskStore() {
        this.taskStoreManager = new HumanTaskStoreManager();
    }

    private void loadHumanTaskServerConfiguration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading Human Task Server Configuration...");
        }
        if (this.isHumanTaskConfigurationFileAvailable()) {
            File htServerConfigFile = new File(this.calculateHumanTaskServerConfigurationFilePath());
            this.serverConfig = new HumanTaskServerConfiguration(htServerConfigFile);
        } else {
            log.info((Object)"Humantask configuration file: humantask.xml not found. Loading default configurations.");
            this.serverConfig = new HumanTaskServerConfiguration();
        }
    }

    private boolean isHumanTaskConfigurationFileAvailable() {
        File humanTaskConfigurationFile = new File(this.calculateHumanTaskServerConfigurationFilePath());
        return humanTaskConfigurationFile.exists();
    }

    private String calculateHumanTaskServerConfigurationFilePath() {
        return CarbonUtils.getCarbonConfigDirPath() + File.separator + "humantask.xml";
    }

    public HumanTaskStoreManager getTaskStoreManager() {
        return this.taskStoreManager;
    }

    public HumanTaskEngine getTaskEngine() {
        return this.taskEngine;
    }

    public Database getDatabase() {
        return this.database;
    }

    private void initTransactionManager() throws HumanTaskServerException {
        String transactionFactoryName = this.serverConfig.getTransactionFactoryClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing transaction manager using " + transactionFactoryName));
        }
        try {
            Class<?> txFactoryClass = this.getClass().getClassLoader().loadClass(transactionFactoryName);
            Object txFactory = txFactoryClass.newInstance();
            this.tnxManager = (TransactionManager)txFactoryClass.getMethod("getTransactionManager", null).invoke(txFactory, new Object[0]);
        }
        catch (Exception e) {
            log.fatal((Object)("Couldn't initialize a transaction manager with factory: " + transactionFactoryName), (Throwable)e);
            throw new HumanTaskServerException("Couldn't initialize a transaction manager with factory: " + transactionFactoryName, e);
        }
    }

    public HumanTaskServerConfiguration getServerConfig() {
        return this.serverConfig;
    }

    public HumanTaskDAOConnectionFactory getDaoConnectionFactory() {
        return this.daoConnectionFactory;
    }

    public void shutdown() {
        if (this.scheduler != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"shutting down scheduler.");
                }
                this.scheduler.shutdown();
                this.scheduler = null;
            }
            catch (Exception ex) {
                log.error((Object)"Scheduler couldn't be shutdown.", (Throwable)ex);
            }
        }
    }
}

