/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.api.client;

import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.databinding.types.NCName;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.humantask.client.api.HumanTaskClientAPIAdminSkeletonInterface;
import org.wso2.carbon.humantask.client.api.IllegalAccessFault;
import org.wso2.carbon.humantask.client.api.IllegalArgumentFault;
import org.wso2.carbon.humantask.client.api.IllegalOperationFault;
import org.wso2.carbon.humantask.client.api.IllegalStateFault;
import org.wso2.carbon.humantask.client.api.RecipientNotAllowedException;
import org.wso2.carbon.humantask.client.api.TBatchResponse;
import org.wso2.carbon.humantask.client.api.types.TAttachment;
import org.wso2.carbon.humantask.client.api.types.TAttachmentInfo;
import org.wso2.carbon.humantask.client.api.types.TComment;
import org.wso2.carbon.humantask.client.api.types.TFault;
import org.wso2.carbon.humantask.client.api.types.TOrganizationalEntity;
import org.wso2.carbon.humantask.client.api.types.TPriority;
import org.wso2.carbon.humantask.client.api.types.TRenderingTypes;
import org.wso2.carbon.humantask.client.api.types.TSimpleQueryInput;
import org.wso2.carbon.humantask.client.api.types.TStatus;
import org.wso2.carbon.humantask.client.api.types.TTaskAbstract;
import org.wso2.carbon.humantask.client.api.types.TTaskAuthorisationParams;
import org.wso2.carbon.humantask.client.api.types.TTaskDetails;
import org.wso2.carbon.humantask.client.api.types.TTaskEventType;
import org.wso2.carbon.humantask.client.api.types.TTaskEvents;
import org.wso2.carbon.humantask.client.api.types.TTaskHistoryFilter;
import org.wso2.carbon.humantask.client.api.types.TTaskInstanceData;
import org.wso2.carbon.humantask.client.api.types.TTaskOperations;
import org.wso2.carbon.humantask.client.api.types.TTaskQueryResultSet;
import org.wso2.carbon.humantask.client.api.types.TTaskSimpleQueryResultSet;
import org.wso2.carbon.humantask.client.api.types.TTime;
import org.wso2.carbon.humantask.client.api.types.TUser;
import org.wso2.carbon.humantask.core.api.client.TransformerUtils;
import org.wso2.carbon.humantask.core.dao.AttachmentDAO;
import org.wso2.carbon.humantask.core.dao.CommentDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnection;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.SimpleQueryCriteria;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.engine.HumanTaskEngine;
import org.wso2.carbon.humantask.core.engine.HumanTaskException;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.engine.commands.Activate;
import org.wso2.carbon.humantask.core.engine.commands.AddComment;
import org.wso2.carbon.humantask.core.engine.commands.Claim;
import org.wso2.carbon.humantask.core.engine.commands.Complete;
import org.wso2.carbon.humantask.core.engine.commands.Delegate;
import org.wso2.carbon.humantask.core.engine.commands.DeleteComment;
import org.wso2.carbon.humantask.core.engine.commands.DeleteFault;
import org.wso2.carbon.humantask.core.engine.commands.DeleteOutput;
import org.wso2.carbon.humantask.core.engine.commands.Fail;
import org.wso2.carbon.humantask.core.engine.commands.GetComments;
import org.wso2.carbon.humantask.core.engine.commands.GetFault;
import org.wso2.carbon.humantask.core.engine.commands.GetInput;
import org.wso2.carbon.humantask.core.engine.commands.GetOutput;
import org.wso2.carbon.humantask.core.engine.commands.GetTaskDescription;
import org.wso2.carbon.humantask.core.engine.commands.Nominate;
import org.wso2.carbon.humantask.core.engine.commands.Release;
import org.wso2.carbon.humantask.core.engine.commands.Remove;
import org.wso2.carbon.humantask.core.engine.commands.Resume;
import org.wso2.carbon.humantask.core.engine.commands.SetFault;
import org.wso2.carbon.humantask.core.engine.commands.SetOutput;
import org.wso2.carbon.humantask.core.engine.commands.SetPriority;
import org.wso2.carbon.humantask.core.engine.commands.Skip;
import org.wso2.carbon.humantask.core.engine.commands.Start;
import org.wso2.carbon.humantask.core.engine.commands.Stop;
import org.wso2.carbon.humantask.core.engine.commands.Suspend;
import org.wso2.carbon.humantask.core.engine.commands.UpdateComment;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalAccessException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalArgumentException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalOperationException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalStateException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.engine.util.CommonTaskUtil;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.utils.DOMUtils;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class TaskOperationsImpl
extends AbstractAdmin
implements HumanTaskClientAPIAdminSkeletonInterface {
    private static Log log = LogFactory.getLog(TaskOperationsImpl.class);

    public TTaskSimpleQueryResultSet simpleQuery(final TSimpleQueryInput tSimpleQueryInput) throws IllegalStateFault, IllegalArgumentFault {
        try {
            List<TaskDAO> matchingTasks = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<List<TaskDAO>>(){

                @Override
                public List<TaskDAO> call() throws Exception {
                    HumanTaskDAOConnection daoConn = HumanTaskServiceComponent.getHumanTaskServer().getDaoConnectionFactory().getConnection();
                    SimpleQueryCriteria queryCriteria = TransformerUtils.transformSimpleTaskQuery(tSimpleQueryInput);
                    queryCriteria.setCallerTenantId(CarbonContext.getCurrentContext().getTenantId());
                    queryCriteria.setCaller(TaskOperationsImpl.this.getCaller());
                    return daoConn.searchTasks(queryCriteria);
                }
            });
            int pageNumber = tSimpleQueryInput.getPageNumber();
            if (pageNumber < 0 || pageNumber == Integer.MAX_VALUE) {
                pageNumber = 0;
            }
            int startIndexOfCurrentPage = pageNumber * 20;
            int endIndexOfCurrentPage = (pageNumber + 1) * 20;
            int taskListSize = matchingTasks.size();
            int pages = (int)Math.ceil((double)taskListSize / 20.0);
            TaskDAO[] instanceArray = matchingTasks.toArray(new TaskDAO[taskListSize]);
            TTaskSimpleQueryResultSet resultSet = new TTaskSimpleQueryResultSet();
            resultSet.setPages(pages);
            for (int i = startIndexOfCurrentPage; i < endIndexOfCurrentPage && i < taskListSize; ++i) {
                resultSet.addRow(TransformerUtils.transformToSimpleQueryRow(instanceArray[i]));
            }
            return resultSet;
        }
        catch (HumanTaskIllegalStateException ex) {
            log.error((Object)ex);
            throw new IllegalStateFault((Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalArgumentFault((Throwable)ex);
        }
    }

    public TBatchResponse[] batchStop(URI[] uris) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    private void handleUnsupportedOperation() {
        throw new UnsupportedOperationException("This operation is not currently supported in this version of WSO2 BPS.");
    }

    public TTaskAbstract[] getMyTaskAbstracts(String s, String s1, String s2, TStatus[] tStatuses, String s3, String s4, String s5, int i, int i1) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TTaskAbstract[0];
    }

    public void stop(final URI taskId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            this.validateTaskId(taskId);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Stop stop = new Stop(TaskOperationsImpl.this.getCaller(), new Long(taskId.toString()));
                    stop.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TBatchResponse[] batchComplete(URI[] taskIds, OMElement o) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public void resume(final URI taskId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            this.validateTaskId(taskId);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Resume resumeCommand = new Resume(TaskOperationsImpl.this.getCaller(), new Long(taskId.toString()));
                    resumeCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public QName[] getRenderingTypes(URI taskId) throws IllegalArgumentFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new QName[0];
    }

    public void setTaskCompletionDeadlineExpression(URI taskId, NCName ncName, String s) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(taskId);
        this.handleUnsupportedOperation();
    }

    public void setOutput(URI taskIdURI, NCName ncName, OMElement o) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            if (ncName == null || o == null) {
                throw new IllegalArgumentFault("The output data cannot be empty!");
            }
            final String outputName = ncName.toString();
            final Element outputData = DOMUtils.getElementFromObject(o);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SetOutput setOutputCommand = new SetOutput(TaskOperationsImpl.this.getCaller(), taskId, outputName, outputData);
                    setOutputCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TTaskOperations getTaskOperations(URI taskId) throws IllegalOperationFault, IllegalArgumentFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(taskId);
        this.handleUnsupportedOperation();
        return null;
    }

    public TBatchResponse[] batchRelease(URI[] taskId) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public TTaskDetails getTaskDetails(URI taskId) throws IllegalArgumentFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(taskId);
        this.handleUnsupportedOperation();
        return null;
    }

    public void forward(URI taskId, TOrganizationalEntity tOrganizationalEntity) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(taskId);
        this.handleUnsupportedOperation();
    }

    public boolean isSubtask(URI taskId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        this.validateTaskId(taskId);
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        return false;
    }

    public void suspend(final URI taskId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            this.validateTaskId(taskId);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Suspend suspendCommand = new Suspend(TaskOperationsImpl.this.getCaller(), new Long(taskId.toString()));
                    suspendCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TUser[] getAssignableUserList(URI taskIdURI) throws IllegalStateFault, IllegalArgumentFault {
        final int tenantId = CarbonContext.getCurrentContext().getTenantId();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<TUser[]>(){

                @Override
                public TUser[] call() throws Exception {
                    HumanTaskEngine engine = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine();
                    HumanTaskDAOConnection daoConn = engine.getDaoConnectionFactory().getConnection();
                    TaskDAO task = daoConn.getTask(taskId);
                    String roleName = CommonTaskUtil.getPotentialOwnerRoleName(task);
                    String actualOwnerUserName = null;
                    OrganizationalEntityDAO actualOwner = CommonTaskUtil.getUserEntityForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
                    if (actualOwner != null) {
                        actualOwnerUserName = actualOwner.getName();
                    }
                    return TaskOperationsImpl.this.getUserListForRole(roleName, tenantId, actualOwnerUserName);
                }
            });
        }
        catch (HumanTaskIllegalStateException ex) {
            log.error((Object)ex);
            throw new IllegalStateFault((Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalArgumentFault((Throwable)ex);
        }
    }

    public void updateComment(URI taskIdURI, final URI commentId, final String s) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    UpdateComment updateCommentCommand = new UpdateComment(TaskOperationsImpl.this.getCaller(), taskId, new Long(commentId.toString()), s);
                    updateCommentCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TTaskAbstract loadTask(URI taskIdURI) throws IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            TaskDAO task = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<TaskDAO>(){

                @Override
                public TaskDAO call() throws Exception {
                    HumanTaskEngine engine = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine();
                    HumanTaskDAOConnection daoConn = engine.getDaoConnectionFactory().getConnection();
                    return daoConn.getTask(taskId);
                }
            });
            return TransformerUtils.transformTask(task, this.getCaller());
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalAccessFault((Throwable)ex);
        }
    }

    public TTaskDetails[] getMyTaskDetails(String s, String s1, String s2, TStatus[] tStatuses, String s3, String s4, String s5, int i, int i1) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TTaskDetails[0];
    }

    public TBatchResponse[] batchNominate(URI[] uris) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public URI[] getSubtaskIdentifiers(URI uri) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new URI[0];
    }

    public String getOutcome(URI uri) throws IllegalOperationFault, IllegalArgumentFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(uri);
        this.handleUnsupportedOperation();
        return null;
    }

    public Object getRendering(URI uri, QName qName) throws IllegalArgumentFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(uri);
        this.handleUnsupportedOperation();
        return null;
    }

    public void skip(URI taskIdURI) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Skip skipCommand = new Skip(TaskOperationsImpl.this.getCaller(), taskId);
                    skipCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TBatchResponse[] batchFail(URI[] taskIds, TFault tFault) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public void setTaskCompletionDurationExpression(URI uri, NCName ncName, String s) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
    }

    public void start(final URI taskId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            this.validateTaskId(taskId);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Start startCommand = new Start(TaskOperationsImpl.this.getCaller(), new Long(taskId.toString()));
                    startCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void fail(URI taskIdURI, final TFault tFault) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskID = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String faultName = null;
                    Element faultData = null;
                    if (tFault != null) {
                        faultName = tFault.getFaultName().toString();
                        faultData = DOMUtils.getElementFromObject(tFault.getFaultData());
                    }
                    Fail failCommand = new Fail(TaskOperationsImpl.this.getCaller(), taskID, faultName, faultData);
                    failCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void activate(URI taskIdURI) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskID = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Activate activateCommand = new Activate(TaskOperationsImpl.this.getCaller(), taskID);
                    activateCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public URI addComment(final URI taskIdURI, final String commentString) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            this.validateTaskId(taskIdURI);
            Validate.notEmpty((String)commentString, (String)"The comment string cannot be empty");
            return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<URI>(){

                @Override
                public URI call() throws Exception {
                    AddComment addComment = new AddComment(TaskOperationsImpl.this.getCaller(), new Long(taskIdURI.toString()), commentString);
                    addComment.execute();
                    CommentDAO persisted = addComment.getPersistedComment();
                    if (persisted != null) {
                        return ConverterUtil.convertToURI((String)persisted.getId().toString());
                    }
                    throw new IllegalStateFault("The persisted comment is null. See error log for more details.");
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    public void deleteComment(URI taskIdURI, final URI commentId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DeleteComment deleteComment = new DeleteComment(TaskOperationsImpl.this.getCaller(), taskId, new Long(commentId.toString()));
                    deleteComment.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void delegate(final URI taskId, final TOrganizationalEntity delegatee) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, RecipientNotAllowedException, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            this.validateTaskId(taskId);
            if (delegatee == null) {
                throw new IllegalArgumentFault("The delegatee cannot be null!");
            }
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    List<OrganizationalEntityDAO> orgEntities = TransformerUtils.transformOrganizationalEntityList(delegatee);
                    if (orgEntities.size() > 1) {
                        throw new IllegalArgumentFault("There can be only 1 delegatee of type user!");
                    }
                    Delegate delegateCommand = new Delegate(TaskOperationsImpl.this.getCaller(), new Long(taskId.toString()), orgEntities.get(0));
                    delegateCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TComment[] getComments(URI taskIdURI) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<TComment[]>(){

                @Override
                public TComment[] call() throws Exception {
                    GetComments getComments = new GetComments(TaskOperationsImpl.this.getCaller(), taskId);
                    getComments.execute();
                    List<TComment> comments = TransformerUtils.transformComments(getComments.getComments());
                    return comments.toArray(new TComment[comments.size()]);
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    public TTaskInstanceData getTaskInstanceData(URI taskId, String s, TRenderingTypes[] tRenderingTypeses) throws IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return null;
    }

    public TTaskDetails getParentTask(URI taskId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return null;
    }

    public TBatchResponse[] batchResume(URI[] taskIds) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public TBatchResponse[] batchRemove(URI[] taskIds) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public TAttachment[] getAttachment(URI taskIdentifier, URI attachmentIdentifier) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TAttachment[0];
    }

    public boolean addAttachment(URI taskIdentifier, String name, String accessType, String contentType, Object attachment) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        final Long taskId = this.validateTaskId(taskIdentifier);
        final String attachmentID = (String)attachment;
        try {
            Boolean isAdded = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    HumanTaskEngine engine = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine();
                    HumanTaskDAOConnection daoConn = engine.getDaoConnectionFactory().getConnection();
                    TaskDAO taskDAO = daoConn.getTask(taskId);
                    try {
                        boolean isAdded = taskDAO.addAttachment(TransformerUtils.generateAttachmentDAOFromID(taskDAO, attachmentID));
                        if (!isAdded) {
                            throw new HumanTaskException("Attachment with id: " + attachmentID + "was not associated " + "task with id:" + taskId);
                        }
                        return isAdded;
                    }
                    catch (HumanTaskException ex) {
                        String errMsg = "getAttachmentInfos operation failed. Reason: ";
                        log.error((Object)(errMsg + ex.getLocalizedMessage()), (Throwable)ex);
                        throw ex;
                    }
                }
            });
            return isAdded;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return false;
        }
    }

    public TAttachmentInfo[] getAttachmentInfos(URI taskIdentifier) throws IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        final Long taskId = this.validateTaskId(taskIdentifier);
        try {
            List<AttachmentDAO> attachmentList = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<List<AttachmentDAO>>(){

                @Override
                public List<AttachmentDAO> call() throws Exception {
                    HumanTaskEngine engine = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine();
                    HumanTaskDAOConnection daoConn = engine.getDaoConnectionFactory().getConnection();
                    return daoConn.getTask(taskId).getAttachments();
                }
            });
            return TransformerUtils.transformAttachments(attachmentList);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalAccessFault((Throwable)ex);
        }
    }

    public void remove(URI taskId) throws IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long notificationId = this.validateTaskId(taskId);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Remove removeCommand = new Remove(TaskOperationsImpl.this.getCaller(), notificationId);
                    removeCommand.execute();
                    return null;
                }
            });
        }
        catch (HumanTaskIllegalOperationException ex) {
            log.error((Object)ex);
            throw new IllegalOperationFault((Throwable)ex);
        }
        catch (HumanTaskIllegalAccessException ex) {
            log.error((Object)ex);
            throw new IllegalAccessFault((Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalArgumentFault((Throwable)ex);
        }
    }

    public TBatchResponse[] batchStart(URI[] taskIds) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public URI instantiateSubtask(URI taskId, String s) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return null;
    }

    public TTaskAuthorisationParams loadAuthorisationParams(URI taskIdURI) throws IllegalStateFault, IllegalArgumentFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<TTaskAuthorisationParams>(){

                @Override
                public TTaskAuthorisationParams call() throws Exception {
                    HumanTaskEngine engine = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine();
                    HumanTaskDAOConnection daoConn = engine.getDaoConnectionFactory().getConnection();
                    TaskDAO task = daoConn.getTask(taskId);
                    return TransformerUtils.transformTaskAuthorization(task, TaskOperationsImpl.this.getCaller());
                }
            });
        }
        catch (HumanTaskIllegalArgumentException ex) {
            log.error((Object)ex);
            throw new IllegalArgumentFault((Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalStateFault((Throwable)ex);
        }
    }

    public TTaskEventType[] getTaskHistory(URI uri, TTaskHistoryFilter tTaskHistoryFilter, int i, int i1, boolean b) throws IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TTaskEventType[0];
    }

    public void setTaskStartDeadlineExpression(URI uri, NCName ncName, String s) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
    }

    public TTaskEvents loadTaskEvents(URI taskIdURI) throws IllegalArgumentFault, IllegalStateFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<TTaskEvents>(){

                @Override
                public TTaskEvents call() throws Exception {
                    HumanTaskEngine engine = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine();
                    HumanTaskDAOConnection daoConn = engine.getDaoConnectionFactory().getConnection();
                    TaskDAO task = daoConn.getTask(taskId);
                    return TransformerUtils.transformTaskEvents(task, TaskOperationsImpl.this.getCaller());
                }
            });
        }
        catch (HumanTaskIllegalArgumentException ex) {
            log.error((Object)ex);
            throw new IllegalArgumentFault((Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalStateFault((Throwable)ex);
        }
    }

    public TBatchResponse[] batchDelegate(URI[] uris, TOrganizationalEntity tOrganizationalEntity) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public TBatchResponse[] batchSetGenericHumanRole(URI[] uris, String s, TOrganizationalEntity tOrganizationalEntity) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public void setGenericHumanRole(URI uri, String s, TOrganizationalEntity tOrganizationalEntity) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(uri);
        this.handleUnsupportedOperation();
    }

    public Object getInput(final URI taskIdURI, final NCName inputIdentifier) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            this.validateTaskId(taskIdURI);
            return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Long taskId = TaskOperationsImpl.this.validateTaskId(taskIdURI);
                    String partName = "";
                    if (inputIdentifier != null) {
                        partName = inputIdentifier.toString().trim();
                    }
                    GetInput getInput = new GetInput(TaskOperationsImpl.this.getCaller(), taskId, partName);
                    getInput.execute();
                    Element input = getInput.getInputElement();
                    return DOMUtils.domToString(input);
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    public TBatchResponse[] batchSkip(URI[] taskIds) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public void complete(URI taskIdURI, final String outputStr) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Element output = DOMUtils.stringToDOM(outputStr);
                    Complete completeCommand = new Complete(TaskOperationsImpl.this.getCaller(), taskId, output);
                    completeCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public boolean hasSubtasks(URI taskId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(taskId);
        return false;
    }

    public TBatchResponse[] batchActivate(URI[] taskIds) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public void claim(URI taskIdURI) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Claim claim = new Claim(TaskOperationsImpl.this.getCaller(), taskId);
                    claim.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TTaskQueryResultSet query(String s, String s1, String s2, int i, int i1) throws IllegalStateFault, IllegalArgumentFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return null;
    }

    public TBatchResponse[] batchClaim(URI[] uris) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public TBatchResponse[] batchSetPriority(URI[] uris, TPriority tPriority) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public void setFault(URI taskIdURI, final TFault tFault) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String faultName = null;
                    Element faultData = null;
                    if (tFault != null) {
                        faultName = tFault.getFaultName().toString();
                        faultData = DOMUtils.getElementFromObject(tFault.getFaultData());
                    }
                    SetFault setFault = new SetFault(TaskOperationsImpl.this.getCaller(), taskId, faultName, faultData);
                    setFault.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void suspendUntil(URI taskId, TTime suspendUntilTime) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(taskId);
        this.handleUnsupportedOperation();
    }

    public void setTaskStartDurationExpression(URI taskId, NCName ncName, String s) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(taskId);
        this.handleUnsupportedOperation();
    }

    public String getTaskDescription(URI taskIdURI, final String contentTypeStr) throws IllegalArgumentFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String contentType = StringUtils.isNotEmpty((String)contentTypeStr) ? contentTypeStr : "text/plain";
                    GetTaskDescription taskDescriptionCommand = new GetTaskDescription(TaskOperationsImpl.this.getCaller(), taskId, contentType);
                    taskDescriptionCommand.execute();
                    return taskDescriptionCommand.getTaskDescription();
                }
            });
        }
        catch (HumanTaskIllegalArgumentException ex) {
            log.error((Object)ex);
            throw new IllegalArgumentFault((Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalArgumentFault((Throwable)ex);
        }
    }

    public void deleteAttachment(URI taskId, URI attachmentId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(taskId);
        this.handleUnsupportedOperation();
    }

    public void nominate(URI taskIdURI, final TOrganizationalEntity nomineeOrgEntity) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    List<OrganizationalEntityDAO> nominees = TransformerUtils.transformOrganizationalEntityList(nomineeOrgEntity);
                    Nominate nominateCommand = new Nominate(TaskOperationsImpl.this.getCaller(), taskId, nominees);
                    nominateCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void deleteOutput(URI taskIdURI) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DeleteOutput deleteOutput = new DeleteOutput(TaskOperationsImpl.this.getCaller(), taskId);
                    deleteOutput.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TBatchResponse[] batchForward(URI[] taskIds, TOrganizationalEntity tOrganizationalEntity) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public TBatchResponse[] batchSuspend(URI[] taskIds) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public TTaskDetails[] getSubtasks(URI taskId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.validateTaskId(taskId);
        this.handleUnsupportedOperation();
        return new TTaskDetails[0];
    }

    public void deleteFault(URI taskIdURI) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DeleteFault deleteFaultCommand = new DeleteFault(TaskOperationsImpl.this.getCaller(), taskId);
                    deleteFaultCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public Object getOutput(URI taskIdURI, final NCName partNCName) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String partName = "";
                    if (partNCName != null) {
                        partName = partNCName.toString().trim();
                    }
                    GetOutput getOutputCommand = new GetOutput(TaskOperationsImpl.this.getCaller(), taskId, partName);
                    getOutputCommand.execute();
                    Node outputElement = getOutputCommand.getOutputData().getFirstChild();
                    try {
                        return DOMUtils.domToString(outputElement);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error occurred when converting the output to OMElement", (Throwable)e);
                        throw new IllegalStateFault("Error occurred when converting the output to OMElement", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    public void release(final URI taskId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            this.validateTaskId(taskId);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Release releaseCommand = new Release(TaskOperationsImpl.this.getCaller(), new Long(taskId.toString()));
                    releaseCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TFault getFault(URI taskIdURI) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            return HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<TFault>(){

                @Override
                public TFault call() throws Exception {
                    GetFault getFault = new GetFault(TaskOperationsImpl.this.getCaller(), taskId);
                    getFault.execute();
                    TFault fault = new TFault();
                    if (getFault.getFaultData() != null && StringUtils.isNotEmpty((String)getFault.getFaultName())) {
                        fault.setFaultName(new NCName(getFault.getFaultName()));
                        fault.setFaultData((Object)DOMUtils.domToString(getFault.getFaultData()));
                    }
                    return fault;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    public void setPriority(URI taskIdURI, final TPriority tPriority) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        if (tPriority.getTPriority().intValue() < 1 || tPriority.getTPriority().intValue() > 10) {
            log.warn((Object)("The priority value should be between 1 and 10. Hence ignoring the provided priority :" + tPriority.getTPriority()));
        }
        try {
            final Long taskId = this.validateTaskId(taskIdURI);
            HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getScheduler().execTransaction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    int newPriority = tPriority.getTPriority().intValue();
                    SetPriority setPriorityCommand = new SetPriority(TaskOperationsImpl.this.getCaller(), taskId, newPriority);
                    setPriorityCommand.execute();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TBatchResponse[] batchSuspendUntil(URI[] taskIds, TTime suspendUntilTime) {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return new TBatchResponse[0];
    }

    public URI getParentTaskIdentifier(URI taskId) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(CarbonContext.getCurrentContext().getTenantId());
        this.handleUnsupportedOperation();
        return null;
    }

    private Long validateTaskId(URI taskId) {
        if (taskId == null || StringUtils.isEmpty((String)taskId.toString())) {
            throw new IllegalArgumentException("The task id cannot be null or empty");
        }
        try {
            return Long.valueOf(taskId.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The task id must be a number", e);
        }
    }

    private String getCaller() {
        String userName = "admin";
        PeopleQueryEvaluator pqe = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getPeopleQueryEvaluator();
        if (StringUtils.isNotEmpty((String)pqe.getLoggedInUser())) {
            userName = pqe.getLoggedInUser();
        }
        if (StringUtils.isEmpty((String)userName)) {
            throw new HumanTaskRuntimeException("Cannot determine the user name of the user performing the task operation!");
        }
        return userName;
    }

    private TUser[] getUserListForRole(String roleName, int tenantId, String actualOwnerUserName) throws RegistryException, UserStoreException {
        TUser[] userList = new TUser[]{};
        RegistryService registryService = HumanTaskServiceComponent.getRegistryService();
        if (registryService != null && registryService.getUserRealm(tenantId) != null) {
            UserRealm userRealm = registryService.getUserRealm(tenantId);
            String[] assignableUserNameList = userRealm.getUserStoreManager().getUserListOfRole(roleName);
            if (assignableUserNameList != null) {
                userList = new TUser[assignableUserNameList.length];
                for (int i = 0; i < assignableUserNameList.length; ++i) {
                    TUser user = new TUser();
                    user.setTUser(assignableUserNameList[i]);
                    if (StringUtils.isEmpty((String)actualOwnerUserName)) {
                        userList[i] = user;
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((String)actualOwnerUserName) || actualOwnerUserName.equals(assignableUserNameList[i])) continue;
                    userList[i] = user;
                }
            }
        } else {
            log.warn((Object)("Cannot load User Realm for Tenant Id: " + tenantId));
        }
        return userList;
    }

    private void handleException(Exception ex) throws IllegalStateFault, IllegalOperationFault, IllegalArgumentFault, IllegalAccessFault {
        log.error((Object)ex);
        if (ex instanceof HumanTaskIllegalAccessException) {
            throw new IllegalAccessFault((Throwable)ex);
        }
        if (ex instanceof HumanTaskIllegalArgumentException) {
            throw new IllegalArgumentFault((Throwable)ex);
        }
        if (ex instanceof HumanTaskIllegalOperationException) {
            throw new IllegalOperationFault((Throwable)ex);
        }
        if (ex instanceof HumanTaskIllegalStateException) {
            throw new IllegalStateFault((Throwable)ex);
        }
        throw new IllegalStateFault((Throwable)ex);
    }
}

