/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.api.client;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.attachment.mgt.skeleton.AttachmentMgtException;
import org.wso2.carbon.attachment.mgt.skeleton.types.TAttachment;
import org.wso2.carbon.humantask.client.api.types.TAttachmentInfo;
import org.wso2.carbon.humantask.client.api.types.TComment;
import org.wso2.carbon.humantask.client.api.types.TGroup;
import org.wso2.carbon.humantask.client.api.types.TOrganizationalEntity;
import org.wso2.carbon.humantask.client.api.types.TOrganizationalEntityChoice;
import org.wso2.carbon.humantask.client.api.types.TPresentationDescription;
import org.wso2.carbon.humantask.client.api.types.TPresentationName;
import org.wso2.carbon.humantask.client.api.types.TPresentationSubject;
import org.wso2.carbon.humantask.client.api.types.TPriority;
import org.wso2.carbon.humantask.client.api.types.TSimpleQueryCategory;
import org.wso2.carbon.humantask.client.api.types.TSimpleQueryInput;
import org.wso2.carbon.humantask.client.api.types.TStatus;
import org.wso2.carbon.humantask.client.api.types.TTaskAbstract;
import org.wso2.carbon.humantask.client.api.types.TTaskAuthorisationParams;
import org.wso2.carbon.humantask.client.api.types.TTaskEvent;
import org.wso2.carbon.humantask.client.api.types.TTaskEvents;
import org.wso2.carbon.humantask.client.api.types.TTaskSimpleQueryResultRow;
import org.wso2.carbon.humantask.client.api.types.TUser;
import org.wso2.carbon.humantask.core.dao.AttachmentDAO;
import org.wso2.carbon.humantask.core.dao.CommentDAO;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnection;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.PresentationDescriptionDAO;
import org.wso2.carbon.humantask.core.dao.PresentationNameDAO;
import org.wso2.carbon.humantask.core.dao.PresentationSubjectDAO;
import org.wso2.carbon.humantask.core.dao.SimpleQueryCriteria;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.dao.TaskType;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.OrganizationalEntity;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task;
import org.wso2.carbon.humantask.core.engine.HumanTaskEngine;
import org.wso2.carbon.humantask.core.engine.HumanTaskException;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.engine.util.CommonTaskUtil;
import org.wso2.carbon.humantask.core.engine.util.OperationAuthorizationUtil;
import org.wso2.carbon.humantask.core.internal.HumanTaskServerHolder;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.store.TaskConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransformerUtils {
    public static final Log log = LogFactory.getLog(TransformerUtils.class);

    private TransformerUtils() {
    }

    public static List<TComment> transformComments(List<CommentDAO> comments) {
        ArrayList<TComment> transformedComments = new ArrayList<TComment>();
        for (CommentDAO comment : comments) {
            TComment transformedComment = TransformerUtils.transformComment(comment);
            transformedComments.add(transformedComment);
        }
        return transformedComments;
    }

    public static TComment transformComment(CommentDAO comment) {
        TComment transformedComment = new TComment();
        Calendar addedAt = Calendar.getInstance();
        addedAt.setTime(comment.getCommentedDate());
        transformedComment.setAddedTime(addedAt);
        TUser commentedBy = new TUser();
        commentedBy.setTUser(comment.getCommentedBy());
        transformedComment.setAddedBy(commentedBy);
        transformedComment.setText(comment.getCommentText());
        transformedComment.setId(ConverterUtil.convertToURI((String)comment.getId().toString()));
        TUser lastModifiedBy = new TUser();
        if (StringUtils.isNotEmpty((String)comment.getModifiedBy())) {
            lastModifiedBy.setTUser(comment.getModifiedBy());
        } else {
            lastModifiedBy.setTUser(comment.getCommentedBy());
        }
        transformedComment.setLastModifiedBy(lastModifiedBy);
        Calendar modifiedAt = Calendar.getInstance();
        if (comment.getModifiedDate() != null) {
            modifiedAt.setTime(comment.getModifiedDate());
        } else {
            modifiedAt.setTime(comment.getCommentedDate());
        }
        transformedComment.setLastModifiedTime(modifiedAt);
        return transformedComment;
    }

    public static TTaskSimpleQueryResultRow transformToSimpleQueryRow(TaskDAO matchingTask) {
        TTaskSimpleQueryResultRow row = new TTaskSimpleQueryResultRow();
        row.setName(QName.valueOf(matchingTask.getName()));
        row.setTaskType(matchingTask.getType().toString());
        try {
            row.setId(new URI(matchingTask.getId().toString()));
        }
        catch (URI.MalformedURIException e) {
            throw new HumanTaskRuntimeException("The task id :[" + matchingTask.getId() + "] is invalid", e);
        }
        Calendar createdTime = Calendar.getInstance();
        createdTime.setTime(matchingTask.getCreatedOn());
        row.setCreatedTime(createdTime);
        TPriority priority = new TPriority();
        priority.setTPriority(BigInteger.valueOf(matchingTask.getPriority().intValue()));
        row.setPriority(priority);
        TStatus taskStatus = new TStatus();
        taskStatus.setTStatus(matchingTask.getStatus().toString());
        row.setStatus(taskStatus);
        row.setPresentationSubject(TransformerUtils.transformPresentationSubject(CommonTaskUtil.getDefaultPresentationSubject(matchingTask)));
        row.setPresentationName(TransformerUtils.transformPresentationName(CommonTaskUtil.getDefaultPresentationName(matchingTask)));
        return row;
    }

    public static List<OrganizationalEntityDAO> transformOrganizationalEntityList(TOrganizationalEntity tOEntity) {
        TOrganizationalEntityChoice[] usersAndGroups;
        HumanTaskEngine taskEngine = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine();
        HumanTaskDAOConnection daoConn = taskEngine.getDaoConnectionFactory().getConnection();
        ArrayList<OrganizationalEntityDAO> organizationalEntities = new ArrayList<OrganizationalEntityDAO>();
        for (TOrganizationalEntityChoice userOrGroup : usersAndGroups = tOEntity.getTOrganizationalEntityChoice()) {
            String userName = null;
            OrganizationalEntityDAO.OrganizationalEntityType type = null;
            if (userOrGroup.getUser() != null) {
                TUser user = userOrGroup.getUser();
                userName = user.getTUser().trim();
                type = OrganizationalEntityDAO.OrganizationalEntityType.USER;
            } else if (userOrGroup.getGroup() != null) {
                TGroup group = userOrGroup.getGroup();
                userName = group.getTGroup().trim();
                type = OrganizationalEntityDAO.OrganizationalEntityType.GROUP;
            }
            if (org.h2.util.StringUtils.isNullOrEmpty(userName) || type == null) {
                throw new HumanTaskRuntimeException("Cannot extract OrganizationalEntity from :" + tOEntity);
            }
            OrganizationalEntityDAO orgEntity = daoConn.createNewOrgEntityObject(userName, type);
            organizationalEntities.add(orgEntity);
        }
        return organizationalEntities;
    }

    public static SimpleQueryCriteria transformSimpleTaskQuery(TSimpleQueryInput tSimpleQueryInput) {
        if (tSimpleQueryInput == null) {
            throw new IllegalArgumentException("TSimpleQueryInput parameter passed to transformSimpleTaskQuery cannot be null");
        }
        SimpleQueryCriteria simpleQueryCriteria = new SimpleQueryCriteria();
        simpleQueryCriteria.setCreatedBy("");
        if (tSimpleQueryInput.getCreatedDate() != null) {
            simpleQueryCriteria.setCreatedOn(tSimpleQueryInput.getCreatedDate().getTime());
        }
        simpleQueryCriteria.setUpdatedBy("");
        if (tSimpleQueryInput.getUndatedDate() != null) {
            simpleQueryCriteria.setUpdatedOn(tSimpleQueryInput.getUndatedDate().getTime());
        }
        simpleQueryCriteria.setPageNumber(tSimpleQueryInput.getPageNumber());
        simpleQueryCriteria.setPageSize(tSimpleQueryInput.getPageSize());
        simpleQueryCriteria.setTaskName(tSimpleQueryInput.getTaskName());
        simpleQueryCriteria.setSimpleQueryType(TransformerUtils.transformQueryCategory(tSimpleQueryInput.getSimpleQueryCategory()));
        return simpleQueryCriteria;
    }

    private static SimpleQueryCriteria.QueryType transformQueryCategory(TSimpleQueryCategory tSimpleQueryInput) {
        if (TSimpleQueryCategory.ALL_TASKS.equals((Object)tSimpleQueryInput)) {
            return SimpleQueryCriteria.QueryType.ALL_TASKS;
        }
        if (TSimpleQueryCategory.ASSIGNED_TO_ME.equals((Object)tSimpleQueryInput)) {
            return SimpleQueryCriteria.QueryType.ASSIGNED_TO_ME;
        }
        if (TSimpleQueryCategory.CLAIMABLE.equals((Object)tSimpleQueryInput)) {
            return SimpleQueryCriteria.QueryType.CLAIMABLE;
        }
        if (TSimpleQueryCategory.ASSIGNABLE.equals((Object)tSimpleQueryInput)) {
            return SimpleQueryCriteria.QueryType.ASSIGNABLE;
        }
        if (TSimpleQueryCategory.NOTIFICATIONS.equals((Object)tSimpleQueryInput)) {
            return SimpleQueryCriteria.QueryType.NOTIFICATIONS;
        }
        if (TSimpleQueryCategory.ADVANCED_QUERY.equals((Object)tSimpleQueryInput)) {
            return SimpleQueryCriteria.QueryType.ADVANCED;
        }
        return SimpleQueryCriteria.QueryType.ALL_TASKS;
    }

    public static TTaskAbstract transformTask(TaskDAO task, String callerUserName) {
        TTaskAbstract taskAbstract = new TTaskAbstract();
        try {
            taskAbstract.setId(new URI(task.getId().toString()));
        }
        catch (URI.MalformedURIException e) {
            log.warn((Object)"Invalid task Id found");
        }
        taskAbstract.setName(QName.valueOf(task.getName()));
        taskAbstract.setRenderingMethodExists(true);
        Calendar calCreatedOn = Calendar.getInstance();
        calCreatedOn.setTime(task.getCreatedOn());
        taskAbstract.setCreatedTime(calCreatedOn);
        if (task.getUpdatedOn() != null) {
            Calendar updatedTime = Calendar.getInstance();
            updatedTime.setTime(task.getUpdatedOn());
            taskAbstract.setUpdatedTime(updatedTime);
        }
        if (task.getActivationTime() != null) {
            Calendar calActivationTime = Calendar.getInstance();
            calActivationTime.setTime(task.getActivationTime());
            taskAbstract.setActivationTime(calActivationTime);
        }
        if (task.getExpirationTime() != null) {
            Calendar expirationTime = Calendar.getInstance();
            expirationTime.setTime(task.getExpirationTime());
            taskAbstract.setExpirationTime(expirationTime);
        }
        if (task.getStartByTime() != null) {
            taskAbstract.setStartByTimeExists(true);
        } else {
            taskAbstract.setStartByTimeExists(false);
        }
        if (task.getCompleteByTime() != null) {
            taskAbstract.setCompleteByTimeExists(true);
        } else {
            taskAbstract.setCompleteByTimeExists(false);
        }
        taskAbstract.setTaskType(task.getType().toString());
        taskAbstract.setHasSubTasks(CommonTaskUtil.hasSubTasks(task).booleanValue());
        taskAbstract.setHasComments(CommonTaskUtil.hasComments(task).booleanValue());
        taskAbstract.setHasAttachments(CommonTaskUtil.hasAttachments(task).booleanValue());
        taskAbstract.setHasFault(CommonTaskUtil.hasFault(task).booleanValue());
        taskAbstract.setHasOutput(CommonTaskUtil.hasOutput(task).booleanValue());
        taskAbstract.setEscalated(task.isEscalated().booleanValue());
        taskAbstract.setIsSkipable(task.isSkipable().booleanValue());
        taskAbstract.setStatus(TransformerUtils.transformStatus(task.getStatus()));
        taskAbstract.setPriority(TransformerUtils.transformPriority(task.getPriority()));
        taskAbstract.setPreviousStatus(TransformerUtils.transformStatus(task.getStatusBeforeSuspension()));
        taskAbstract.setHasPotentialOwners(CommonTaskUtil.hasPotentialOwners(task));
        if (CommonTaskUtil.getUserEntityForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER) != null) {
            taskAbstract.setActualOwner(TransformerUtils.createTUser(CommonTaskUtil.getUserEntityForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER)));
        }
        taskAbstract.setPotentialOwners(TransformerUtils.transformOrganizationalEntityList(CommonTaskUtil.getOrgEntitiesForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS)));
        taskAbstract.setBusinessAdministrators(TransformerUtils.transformOrganizationalEntityList(CommonTaskUtil.getOrgEntitiesForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS)));
        taskAbstract.setNotificationRecipients(TransformerUtils.transformOrganizationalEntityList(CommonTaskUtil.getOrgEntitiesForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.NOTIFICATION_RECIPIENTS)));
        taskAbstract.setTaskStakeholders(TransformerUtils.transformOrganizationalEntityList(CommonTaskUtil.getOrgEntitiesForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS)));
        taskAbstract.setTaskInitiator(TransformerUtils.createTUser(CommonTaskUtil.getUserEntityForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.TASK_INITIATOR)));
        HumanTaskBaseConfiguration baseConfiguration = CommonTaskUtil.getTaskConfiguration(task);
        if (baseConfiguration == null) {
            throw new HumanTaskRuntimeException("There's not matching task configuration for task" + task.getName());
        }
        taskAbstract.setPackageName(baseConfiguration.getPackageName());
        taskAbstract.setTenantId(task.getTenantId().intValue());
        if (TaskType.TASK.equals((Object)task.getType())) {
            TaskConfiguration taskConfig = (TaskConfiguration)baseConfiguration;
            taskAbstract.setResponseOperationName(taskConfig.getResponseOperation());
            taskAbstract.setResponseServiceName(taskConfig.getResponsePortType().toString());
        }
        taskAbstract.setPresentationName(TransformerUtils.transformPresentationName(CommonTaskUtil.getDefaultPresentationName(task)));
        taskAbstract.setPresentationSubject(TransformerUtils.transformPresentationSubject(CommonTaskUtil.getDefaultPresentationSubject(task)));
        taskAbstract.setPresentationDescription(TransformerUtils.transformPresentationDescription(CommonTaskUtil.getDefaultPresentationDescription(task)));
        taskAbstract.setHasAttachments(!task.getAttachments().isEmpty());
        taskAbstract.setNumberOfAttachments(task.getAttachments().size());
        return taskAbstract;
    }

    public static TOrganizationalEntity transformOrganizationalEntityList(List<OrganizationalEntityDAO> orgEntitiesForRole) {
        TOrganizationalEntity organizationalEntity = null;
        if (orgEntitiesForRole != null && orgEntitiesForRole.size() > 0) {
            organizationalEntity = new TOrganizationalEntity();
            TOrganizationalEntityChoice[] orgEntityChoiceArray = new TOrganizationalEntityChoice[orgEntitiesForRole.size()];
            for (int i = 0; i < orgEntitiesForRole.size(); ++i) {
                TOrganizationalEntityChoice choice = new TOrganizationalEntityChoice();
                OrganizationalEntityDAO orgEntity = orgEntitiesForRole.get(i);
                if (OrganizationalEntityDAO.OrganizationalEntityType.USER.equals((Object)orgEntity.getOrgEntityType())) {
                    TUser user = new TUser();
                    user.setTUser(orgEntity.getName());
                    choice.setUser(user);
                } else if (OrganizationalEntityDAO.OrganizationalEntityType.USER.equals((Object)orgEntity.getOrgEntityType())) {
                    TGroup group = new TGroup();
                    group.setTGroup(orgEntity.getName());
                    choice.setGroup(group);
                }
                orgEntityChoiceArray[i] = choice;
            }
            organizationalEntity.setTOrganizationalEntityChoice(orgEntityChoiceArray);
        }
        return organizationalEntity;
    }

    public static TPresentationSubject transformPresentationSubject(PresentationSubjectDAO presentationSubjectDAO) {
        if (presentationSubjectDAO != null && StringUtils.isNotEmpty((String)presentationSubjectDAO.getValue())) {
            TPresentationSubject presentationSubject = new TPresentationSubject();
            presentationSubject.setTPresentationSubject(presentationSubjectDAO.getValue().replaceAll("\\s+", " "));
            return presentationSubject;
        }
        return null;
    }

    public static TPresentationDescription transformPresentationDescription(PresentationDescriptionDAO presentationDescription) {
        if (presentationDescription != null && StringUtils.isNotEmpty((String)presentationDescription.getValue())) {
            TPresentationDescription pDesc = new TPresentationDescription();
            pDesc.setTPresentationDescription(presentationDescription.getValue().replaceAll("\\s+", " "));
            return pDesc;
        }
        return null;
    }

    public static TPresentationName transformPresentationName(PresentationNameDAO presentationNameDAO) {
        if (presentationNameDAO != null && StringUtils.isNotEmpty((String)presentationNameDAO.getValue())) {
            TPresentationName presentationName = new TPresentationName();
            presentationName.setTPresentationName(presentationNameDAO.getValue().replaceAll("\\s+", " "));
            return presentationName;
        }
        return null;
    }

    private static TUser createTUser(OrganizationalEntityDAO actualOwnerOrgEntity) {
        TUser actualOwner = new TUser();
        if (actualOwnerOrgEntity != null && StringUtils.isNotEmpty((String)actualOwnerOrgEntity.getName())) {
            actualOwner.setTUser(actualOwnerOrgEntity.getName());
        } else {
            actualOwner.setTUser("");
        }
        return actualOwner;
    }

    public static TPriority transformPriority(Integer priorityValue) {
        TPriority priority = new TPriority();
        priority.setTPriority(BigInteger.valueOf(priorityValue.intValue()));
        return priority;
    }

    public static TStatus transformStatus(TaskStatus ts) {
        TStatus status = new TStatus();
        if (ts != null) {
            status.setTStatus(ts.toString());
        } else {
            status.setTStatus("");
        }
        return status;
    }

    public static TTaskAuthorisationParams transformTaskAuthorization(TaskDAO task, String callerName) {
        PeopleQueryEvaluator pqe = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getPeopleQueryEvaluator();
        OrganizationalEntityDAO caller = pqe.createUserOrgEntityForName(callerName);
        TTaskAuthorisationParams authParams = new TTaskAuthorisationParams();
        authParams.setAuthorisedToActivate(OperationAuthorizationUtil.authorisedToActivate(task, caller, pqe));
        authParams.setAuthorisedToClaim(OperationAuthorizationUtil.authorisedToClaim(task, caller, pqe));
        authParams.setAuthorisedToComment(OperationAuthorizationUtil.authorisedToComment(task, caller, pqe));
        authParams.setAuthorisedToComplete(OperationAuthorizationUtil.authorisedToComplete(task, caller, pqe));
        authParams.setAuthorisedToDelegate(OperationAuthorizationUtil.authorisedToDelegate(task, caller, pqe));
        authParams.setAuthorisedToDeleteFault(OperationAuthorizationUtil.authorisedToDeleteFault(task, caller, pqe));
        authParams.setAuthorisedToDeleteComment(OperationAuthorizationUtil.authorisedToDeleteComment(task, caller, pqe));
        authParams.setAuthorisedToDeleteOutput(OperationAuthorizationUtil.authorisedToDeleteOutput(task, caller, pqe));
        authParams.setAuthorisedToExit(OperationAuthorizationUtil.authorisedToExit(task, caller, pqe));
        authParams.setAuthorisedToFail(OperationAuthorizationUtil.authorisedToFail(task, caller, pqe));
        authParams.setAuthorisedToForward(OperationAuthorizationUtil.authorisedToForward(task, caller, pqe));
        authParams.setAuthorisedToGetComments(OperationAuthorizationUtil.authorisedToGetComments(task, caller, pqe));
        authParams.setAuthorisedToGetDescription(OperationAuthorizationUtil.authorisedToGetDescription(task, caller, pqe));
        authParams.setAuthorisedToGetInput(OperationAuthorizationUtil.authorisedToGetInput(task, caller, pqe));
        authParams.setAuthorisedToNominate(OperationAuthorizationUtil.authorisedToNominate(task, caller, pqe));
        authParams.setAuthorisedToRelease(OperationAuthorizationUtil.authorisedToRelease(task, caller, pqe));
        authParams.setAuthorisedToResume(OperationAuthorizationUtil.authorisedToResume(task, caller, pqe));
        authParams.setAuthorisedToRemove(OperationAuthorizationUtil.authorisedToRemove(task, caller, pqe));
        authParams.setAuthorisedToSetFault(OperationAuthorizationUtil.authorisedToSetFault(task, caller, pqe));
        authParams.setAuthorisedToSetOutput(OperationAuthorizationUtil.authorisedToSetOutput(task, caller, pqe));
        authParams.setAuthorisedToSetPriority(OperationAuthorizationUtil.authorisedToSetPriority(task, caller, pqe));
        authParams.setAuthorisedToSkip(OperationAuthorizationUtil.authorisedToSkip(task, caller, pqe));
        authParams.setAuthorisedToStart(OperationAuthorizationUtil.authorisedToStart(task, caller, pqe));
        authParams.setAuthorisedToStop(OperationAuthorizationUtil.authorisedToStop(task, caller, pqe));
        authParams.setAuthorisedToSuspend(OperationAuthorizationUtil.authorisedToSuspend(task, caller, pqe));
        authParams.setAuthorisedToUpdateComment(OperationAuthorizationUtil.authorisedToUpdateComment(task, caller, pqe));
        return authParams;
    }

    public static TTaskEvents transformTaskEvents(TaskDAO task, String caller) {
        TTaskEvents taskEvents = new TTaskEvents();
        if (task.getEvents() != null) {
            for (EventDAO taskEvent : task.getEvents()) {
                TTaskEvent tEvent = new TTaskEvent();
                tEvent.setEventDetail(taskEvent.getDetails());
                tEvent.setEventId(ConverterUtil.convertToURI((String)taskEvent.getId().toString()));
                TUser user = new TUser();
                user.setTUser(taskEvent.getUser());
                tEvent.setEventInitiator(user);
                Calendar eventTime = Calendar.getInstance();
                eventTime.setTime(taskEvent.getTimeStamp());
                tEvent.setEventTime(eventTime);
                tEvent.setEventType(taskEvent.getType().toString().toLowerCase());
                tEvent.setNewState(TransformerUtils.transformStatus(taskEvent.getNewState()));
                tEvent.setOldState(TransformerUtils.transformStatus(taskEvent.getOldState()));
                taskEvents.addEvent(tEvent);
            }
        }
        return taskEvents;
    }

    public static TAttachmentInfo[] transformAttachments(List<AttachmentDAO> attachmentList) {
        TAttachmentInfo[] array = new TAttachmentInfo[attachmentList.size()];
        int counter = 0;
        for (AttachmentDAO attachmentDAO : attachmentList) {
            TAttachmentInfo attachmentInfo = new TAttachmentInfo();
            attachmentInfo.setAccessType(attachmentDAO.getAccessType());
            try {
                log.warn((Object)"TAttachmentInfo(DTO) has the contentCategory, but the AttachmentDAO(DAO) doesn't support that attribute. So using a dummy value: AnonymousContentCategory");
                attachmentInfo.setContentCategory(new URI("AnonymousContentCategory"));
            }
            catch (URI.MalformedURIException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            try {
                String attachmentURI = attachmentDAO.getValue();
                URI attachmentURL = HumanTaskServerHolder.getInstance().getAttachmentService().getAttachmentService().getAttachmentInfoFromURL(attachmentURI).getUrl();
                attachmentInfo.setIdentifier(attachmentURL);
            }
            catch (AttachmentMgtException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            attachmentInfo.setContentType(attachmentDAO.getContentType());
            Calendar cal = Calendar.getInstance();
            cal.setTime(attachmentDAO.getAttachedAt());
            attachmentInfo.setAttachedTime(cal);
            TUser user = new TUser();
            user.setTUser(attachmentDAO.getAttachedBy().getName());
            attachmentInfo.setAttachedBy(user);
            attachmentInfo.setName(attachmentDAO.getName());
            array[counter] = attachmentInfo;
            ++counter;
        }
        return array;
    }

    public static AttachmentDAO generateAttachmentDAOFromID(TaskDAO task, String attachmentID) throws HumanTaskException {
        try {
            TAttachment attachment = HumanTaskServerHolder.getInstance().getAttachmentService().getAttachmentService().getAttachmentInfo(attachmentID);
            AttachmentDAO dao = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getDaoConnectionFactory().getConnection().createAttachment();
            dao.setName(attachment.getName());
            dao.setContentType(attachment.getContentType());
            dao.setTask((Task)task);
            String attachmentURL = attachment.getUrl().toString();
            String attachmentUniqueID = attachmentURL.substring(attachmentURL.lastIndexOf("/") + 1);
            dao.setValue(attachmentUniqueID);
            dao.setAttachedAt(attachment.getCreatedTime().getTime());
            OrganizationalEntityDAO orgEntityDAO = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getDaoConnectionFactory().getConnection().createNewOrgEntityObject(attachment.getCreatedBy(), OrganizationalEntityDAO.OrganizationalEntityType.USER);
            dao.setAttachedBy((OrganizationalEntity)orgEntityDAO);
            dao.setAccessType("AnonymousAccessType");
            return dao;
        }
        catch (AttachmentMgtException e) {
            String errorMsg = "Attachment Data retrieval operation failed for attachment id:" + attachmentID + ". " + "Reason:";
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new HumanTaskException(errorMsg + e.getLocalizedMessage(), e);
        }
    }

    public static List<AttachmentDAO> generateAttachmentDAOListFromIDs(TaskDAO task, List<String> attachmentIDs) throws HumanTaskException {
        ArrayList<AttachmentDAO> attachmentDAOList = new ArrayList<AttachmentDAO>();
        for (String attachmentID : attachmentIDs) {
            AttachmentDAO dao = TransformerUtils.generateAttachmentDAOFromID(task, attachmentID);
            attachmentDAOList.add(dao);
        }
        return attachmentDAOList;
    }
}

