/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.api.scheduler;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.wso2.carbon.humantask.core.api.scheduler.InvalidJobsInDbException;
import org.wso2.carbon.humantask.core.api.scheduler.InvalidUpdateRequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Scheduler {
    public void setJobProcessor(JobProcessor var1);

    public boolean isTransacted();

    public void start();

    public void stop();

    public void shutdown();

    public long scheduleJob(long var1, long var3, JobType var5, String var6, long var7, String var9);

    public void cancelJobsForTask(long var1);

    public void updateJob(Long var1, String var2, Long var3) throws InvalidJobsInDbException, InvalidUpdateRequestException;

    public <T> T execTransaction(Callable<T> var1) throws Exception;

    public <T> T execTransaction(Callable<T> var1, int var2) throws Exception;

    public static class JobProcessorException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JobProcessorException(Throwable cause) {
            super(cause);
        }

        public JobProcessorException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public JobProcessorException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobType {
        TIMER_DEADLINE,
        TIMER_SUSPEND;

    }

    public static class JobInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long jobId;
        private final long scheduledTime;
        private final long taskId;
        private final String name;
        private final JobType type;

        public long getJobId() {
            return this.jobId;
        }

        public long getScheduledTime() {
            return this.scheduledTime;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public String getName() {
            return this.name;
        }

        public JobType getType() {
            return this.type;
        }

        public JobInfo(long jobId, long scheduledTime, long taskId, String name, String type) {
            this.jobId = jobId;
            this.scheduledTime = scheduledTime;
            this.taskId = taskId;
            this.name = name;
            this.type = JobType.valueOf(type);
        }

        public String toString() {
            return Long.toString(this.jobId) + " : time: " + Long.toString(this.scheduledTime) + " : taskID: " + Long.toString(this.taskId) + " : name: " + this.name + " : Type: " + (Object)((Object)this.type);
        }
    }

    public static interface JobProcessor {
        public void onScheduledJob(JobInfo var1) throws JobProcessorException;
    }
}

