/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.quartz.CronExpression;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.server.config.HumanTaskServerConfigDocument;
import org.wso2.carbon.humantask.server.config.THumanTaskServerConfig;
import org.wso2.carbon.humantask.server.config.TPeopleQueryEvaluatorConfig;
import org.wso2.carbon.humantask.server.config.TPersistenceConfig;
import org.wso2.carbon.humantask.server.config.TSchedulerConfig;
import org.wso2.carbon.humantask.server.config.TTaskCleanupConfig;
import org.wso2.carbon.humantask.server.config.TTaskEventListeners;
import org.wso2.carbon.humantask.server.config.TTransactionManagerConfig;
import org.wso2.carbon.utils.CarbonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTaskServerConfiguration {
    private static final Log log = LogFactory.getLog(HumanTaskServerConfiguration.class);
    private HumanTaskServerConfigDocument htServerConfigDocument;
    private String dataSourceName;
    private String dataSourceJNDIRepoInitialContextFactory;
    private String dataSourceJNDIRepoProviderURL;
    private boolean generateDdl = false;
    private boolean showSql = false;
    private String daoConnectionFactoryClass;
    private String peopleQueryEvaluatorClass = "org.wso2.carbon.humantask.core.integration.CarbonUserManagerBasedPeopleQueryEvaluator";
    private int threadPoolMaxSize = 50;
    private String transactionFactoryClass = "org.apache.ode.il.EmbeddedGeronimoFactory";
    private List<TaskStatus> removableTaskStatuses = Collections.emptyList();
    private List<String> eventListenerClassNames = new ArrayList<String>();
    private String taskCleanupCronExpression;
    private boolean uiRenderingEnabled = false;

    public HumanTaskServerConfiguration(File htServerConfig) {
        this.htServerConfigDocument = this.readConfigurationFromFile(htServerConfig);
        if (this.htServerConfigDocument == null) {
            return;
        }
        this.initConfigurationFromFile();
    }

    public HumanTaskServerConfiguration() {
        this.dataSourceName = "bpsds";
        this.daoConnectionFactoryClass = "org.wso2.carbon.humantask.dao.jpa.openjpa.HumanTaskDAOConnectionFactoryImpl";
        this.dataSourceJNDIRepoInitialContextFactory = "com.sun.jndi.rmi.registry.RegistryContextFactory";
        this.dataSourceJNDIRepoProviderURL = "rmi://localhost:2199";
        this.peopleQueryEvaluatorClass = "org.wso2.carbon.humantask.core.integration.CarbonUserManagerBasedPeopleQueryEvaluator";
    }

    private HumanTaskServerConfigDocument readConfigurationFromFile(File htServerConfiguration) {
        try {
            return HumanTaskServerConfigDocument.Factory.parse(new FileInputStream(htServerConfiguration));
        }
        catch (XmlException e) {
            log.error((Object)"Error parsing human task server configuration.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.info((Object)("Cannot find the human task server configuration in specified location " + htServerConfiguration.getPath() + " . Loads the default configuration."));
        }
        catch (IOException e) {
            log.error((Object)("Error reading human task server configuration file" + htServerConfiguration.getPath() + " ."));
        }
        return null;
    }

    private void initConfigurationFromFile() {
        THumanTaskServerConfig tHumanTaskServerConfig = this.htServerConfigDocument.getHumanTaskServerConfig();
        if (tHumanTaskServerConfig == null) {
            return;
        }
        if (tHumanTaskServerConfig.getPersistenceConfig() != null) {
            this.initPersistenceConfig(tHumanTaskServerConfig.getPersistenceConfig());
        }
        if (tHumanTaskServerConfig.getPeopleQueryEvaluatorConfig() != null) {
            this.initPeopleQueryEvaluator(tHumanTaskServerConfig.getPeopleQueryEvaluatorConfig());
        }
        if (tHumanTaskServerConfig.getSchedulerConfig() != null) {
            this.initSchedulerConfig(tHumanTaskServerConfig.getSchedulerConfig());
        }
        if (tHumanTaskServerConfig.getTransactionManagerConfig() != null) {
            this.initTransactionManagerConfig(tHumanTaskServerConfig.getTransactionManagerConfig());
        }
        if (tHumanTaskServerConfig.getTaskCleanupConfig() != null) {
            this.iniTaskCleanupConfig(tHumanTaskServerConfig.getTaskCleanupConfig());
        }
        if (tHumanTaskServerConfig.getTaskEventListeners() != null) {
            this.initEventListeners(tHumanTaskServerConfig.getTaskEventListeners());
        }
        if (tHumanTaskServerConfig.getUIRenderingEnabled()) {
            this.uiRenderingEnabled = true;
        }
    }

    private void iniTaskCleanupConfig(TTaskCleanupConfig taskCleanupConfig) {
        if (taskCleanupConfig != null) {
            if (StringUtils.isNotEmpty((String)taskCleanupConfig.getCronExpression())) {
                if (CronExpression.isValidExpression((String)taskCleanupConfig.getCronExpression().trim())) {
                    this.taskCleanupCronExpression = taskCleanupConfig.getCronExpression();
                } else {
                    String warnMsg = String.format("The task clean up cron expression[%s] is invalid. Ignoring task clean up configurations! ", taskCleanupConfig.getCronExpression());
                    log.warn((Object)warnMsg);
                    return;
                }
            }
            if (StringUtils.isNotEmpty((String)taskCleanupConfig.getStatuses())) {
                String[] removableStatusesArray = taskCleanupConfig.getStatuses().split(",");
                ArrayList<TaskStatus> removableTaskStatusList = new ArrayList<TaskStatus>();
                block0: for (String removableStatus : removableStatusesArray) {
                    for (TaskStatus taskStatusEnum : TaskStatus.values()) {
                        if (!taskStatusEnum.toString().equals(removableStatus.trim())) continue;
                        removableTaskStatusList.add(taskStatusEnum);
                        continue block0;
                    }
                }
                this.removableTaskStatuses = removableTaskStatusList;
            }
        }
    }

    private void initEventListeners(TTaskEventListeners taskEventListeners) {
        if (taskEventListeners.getClassNameArray() != null) {
            for (String eventListenerClassName : taskEventListeners.getClassNameArray()) {
                if (!StringUtils.isNotEmpty((String)eventListenerClassName)) continue;
                this.eventListenerClassNames.add(eventListenerClassName.trim());
            }
        }
    }

    private void initTransactionManagerConfig(TTransactionManagerConfig tTransactionManagerConfig) {
        if (tTransactionManagerConfig.getTransactionManagerClass() != null) {
            this.transactionFactoryClass = tTransactionManagerConfig.getTransactionManagerClass().trim();
        } else {
            log.debug((Object)("TransactionManagerClass not provided with HumanTask configuration.Using default TransactionManagerClass :" + this.transactionFactoryClass));
        }
    }

    private void initSchedulerConfig(TSchedulerConfig tSchedulerConfig) {
        if (tSchedulerConfig.getMaxThreadPoolSize() > 0) {
            this.threadPoolMaxSize = tSchedulerConfig.getMaxThreadPoolSize();
        } else {
            log.debug((Object)("ThreadPoolMaxSize not provided with HumanTask configuration.Using default thread pool max value of :" + this.threadPoolMaxSize));
        }
    }

    private void initPeopleQueryEvaluator(TPeopleQueryEvaluatorConfig tUserManagerConfig) {
        if (tUserManagerConfig.getPeopleQueryEvaluatorClass() != null) {
            this.peopleQueryEvaluatorClass = tUserManagerConfig.getPeopleQueryEvaluatorClass().trim();
        } else {
            log.debug((Object)("PeopleQueryEvaluatorConfig is not provided with HumanTask configuration.Using default PeopleQueryEvaluatorClass: " + this.peopleQueryEvaluatorClass));
        }
    }

    private void initPersistenceConfig(TPersistenceConfig tPersistenceConfig) {
        if (tPersistenceConfig.getDataSource() != null) {
            this.dataSourceName = tPersistenceConfig.getDataSource().trim();
        }
        if (tPersistenceConfig.getJNDIInitialContextFactory() != null) {
            this.dataSourceJNDIRepoInitialContextFactory = tPersistenceConfig.getJNDIInitialContextFactory().trim();
        }
        if (tPersistenceConfig.getJNDIProviderUrl() != null) {
            this.dataSourceJNDIRepoProviderURL = tPersistenceConfig.getJNDIProviderUrl().trim();
            int portOffset = this.getCarbonPortOffset();
            String portValueString = this.dataSourceJNDIRepoProviderURL.substring(this.dataSourceJNDIRepoProviderURL.lastIndexOf(58) + 1, this.dataSourceJNDIRepoProviderURL.length());
            String urlWithoutPort = this.dataSourceJNDIRepoProviderURL.substring(0, this.dataSourceJNDIRepoProviderURL.lastIndexOf(58) + 1);
            int actualPortValue = Integer.parseInt(portValueString);
            int correctedPortValue = actualPortValue + portOffset;
            this.dataSourceJNDIRepoProviderURL = urlWithoutPort.concat(Integer.toString(correctedPortValue));
        }
        if (tPersistenceConfig.getDAOConnectionFactoryClass() != null) {
            this.daoConnectionFactoryClass = tPersistenceConfig.getDAOConnectionFactoryClass().trim();
        }
        this.generateDdl = tPersistenceConfig.getGenerateDdl();
        this.showSql = tPersistenceConfig.getShowSql();
    }

    private int getCarbonPortOffset() {
        String offset = CarbonUtils.getServerConfiguration().getFirstProperty("Ports.Offset");
        try {
            return offset != null ? Integer.parseInt(offset.trim()) : 0;
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Error occurred while reading port offset. Invalid port offset: " + offset + " Setting the port offset to 0"), (Throwable)e);
            return 0;
        }
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDataSourceJNDIRepoInitialContextFactory() {
        return this.dataSourceJNDIRepoInitialContextFactory;
    }

    public String getDataSourceJNDIRepoProviderURL() {
        return this.dataSourceJNDIRepoProviderURL;
    }

    public boolean isGenerateDdl() {
        return this.generateDdl;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public String getDaoConnectionFactoryClass() {
        return this.daoConnectionFactoryClass;
    }

    public String getPeopleQueryEvaluatorClass() {
        return this.peopleQueryEvaluatorClass;
    }

    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    public String getTransactionFactoryClass() {
        return this.transactionFactoryClass;
    }

    public String getTaskCleanupCronExpression() {
        return this.taskCleanupCronExpression;
    }

    public List<String> getEventListenerClassNames() {
        return this.eventListenerClassNames;
    }

    public List<TaskStatus> getRemovableTaskStatuses() {
        return this.removableTaskStatuses;
    }

    public boolean isTaskCleanupEnabled() {
        return StringUtils.isNotEmpty((String)this.taskCleanupCronExpression) && CronExpression.isValidExpression((String)this.taskCleanupCronExpression) && this.removableTaskStatuses.size() > 0;
    }

    public boolean isUiRenderingEnabled() {
        return this.uiRenderingEnabled;
    }
}

