/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.dao;

import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.humantask.core.dao.MessageDAO;
import org.wso2.carbon.humantask.core.dao.TaskCreationContext;
import org.wso2.carbon.humantask.core.utils.DOMUtils;

public class MessageHelper {
    private MessageDAO messageDao;

    public MessageHelper(MessageDAO messageDao) {
        this.messageDao = messageDao;
    }

    public MessageDAO createMessage(TaskCreationContext taskCreationContext) {
        for (Map.Entry<String, Element> part : taskCreationContext.getMessageBodyParts().entrySet()) {
            this.setPart(part.getKey(), part.getValue());
        }
        for (Map.Entry<String, Element> part : taskCreationContext.getMessageHeaderParts().entrySet()) {
            this.setHeaderPart(part.getKey(), part.getValue());
        }
        return this.messageDao;
    }

    public Element getPart(String partName) {
        Element message = this.messageDao.getBodyData();
        NodeList eltList = message.getElementsByTagName(partName);
        if (eltList.getLength() == 0) {
            return null;
        }
        return (Element)eltList.item(0);
    }

    public void setPart(String partName, Element content) {
        Element message = this.messageDao.getBodyData();
        if (message == null) {
            Document doc = DOMUtils.newDocument();
            message = doc.createElement("message");
            doc.appendChild(message);
        }
        Element partElement = message.getOwnerDocument().createElement(partName);
        partElement.appendChild(partElement.getOwnerDocument().importNode(content, true));
        message.appendChild(partElement);
        this.messageDao.setData(message);
    }

    public Element getHeaderPart(String partName) {
        Element header = this.messageDao.getHeader();
        if (header == null) {
            return null;
        }
        NodeList eltList = header.getElementsByTagName(partName);
        if (eltList.getLength() == 0) {
            return null;
        }
        return (Element)eltList.item(0);
    }

    public void setHeaderPart(String name, Element content) {
        Element header = this.messageDao.getHeader();
        if (header == null) {
            Document doc = DOMUtils.newDocument();
            header = doc.createElement("header");
            doc.appendChild(header);
        }
        Element part = header.getOwnerDocument().createElement(name);
        header.appendChild(part);
        part.appendChild(header.getOwnerDocument().importNode(content, true));
        this.messageDao.setHeader(header);
    }

    public MessageDAO getMessageDao() {
        return this.messageDao;
    }
}

