/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.engine.runtime.ExpressionEvaluationContext;
import org.wso2.carbon.humantask.core.engine.runtime.api.EvaluationContext;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskCreationContext {
    private static Log log = LogFactory.getLog(TaskCreationContext.class);
    private HumanTaskBaseConfiguration taskConfiguration;
    private Integer tenantId;
    private Map<String, Element> messageBodyParts;
    private Map<String, Element> messageHeaderParts;
    private QName messageName;
    private String createdBy;
    private PeopleQueryEvaluator peopleQueryEvaluator;
    private EvaluationContext evalContext;

    public HumanTaskBaseConfiguration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public void setTaskConfiguration(HumanTaskBaseConfiguration taskConfiguration) {
        this.taskConfiguration = taskConfiguration;
    }

    public Integer getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Integer tenantId) {
        this.tenantId = tenantId;
    }

    public PeopleQueryEvaluator getPeopleQueryEvaluator() {
        return this.peopleQueryEvaluator;
    }

    public void setPeopleQueryEvaluator(PeopleQueryEvaluator peopleQueryEvaluator) {
        this.peopleQueryEvaluator = peopleQueryEvaluator;
    }

    public EvaluationContext getEvalContext() {
        return this.evalContext;
    }

    public void setEvalContext(EvaluationContext evalContext) {
        this.evalContext = evalContext;
    }

    public void injectExpressionEvaluationContext(TaskDAO task) {
        if (this.taskConfiguration == null) {
            throw new RuntimeException("The task configuration is empty in the task creation context");
        }
        ExpressionEvaluationContext evaluationContext = new ExpressionEvaluationContext(task, this.getTaskConfiguration());
        this.setEvalContext(evaluationContext);
    }

    public QName getMessageName() {
        return this.messageName;
    }

    public void setMessageName(QName messageName) {
        this.messageName = messageName;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void addMessageBodyPart(String name, Element part) {
        this.messageBodyParts.put(name, part);
    }

    public void addMessageHeaderPart(String name, Element part) {
        this.messageHeaderParts.put(name, part);
    }

    public Map<String, Element> getMessageBodyParts() {
        return this.messageBodyParts;
    }

    public Map<String, Element> getMessageHeaderParts() {
        return this.messageHeaderParts;
    }

    public void setMessageBodyParts(Map<String, Element> messageBodyParts) {
        this.messageBodyParts = messageBodyParts;
    }

    public void setMessageHeaderParts(Map<String, Element> messageHeaderParts) {
        this.messageHeaderParts = messageHeaderParts;
    }

    public List<String> getAttachmentIDs() {
        ArrayList<String> attachmentIDs = new ArrayList<String>();
        String NAMESPACE = "http://wso2.org/bps/attachments";
        String NAMESPACE_PREFIX = "attch";
        String PARENT_ELEMENT_NAME = "attachmentIDs";
        String CHILD_ELEMENT_NAME = "attachmentID";
        Element attachmentElement = this.messageHeaderParts.get("attachmentIDs");
        if (attachmentElement != null && "http://wso2.org/bps/attachments".equals(attachmentElement.getNamespaceURI())) {
            NodeList childElementList = attachmentElement.getElementsByTagNameNS("http://wso2.org/bps/attachments", "attachmentID");
            int size = childElementList.getLength();
            for (int i = 0; i < size; ++i) {
                Element child = (Element)childElementList.item(i);
                attachmentIDs.add(child.getTextContent());
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No header elements found with :attachmentIDs");
        }
        return attachmentIDs;
    }
}

