/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.dao.jpa;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.dao.DatabaseType;
import org.wso2.carbon.humantask.core.dao.jpa.JPAVendorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractJPAVendorAdapter
implements JPAVendorAdapter {
    protected final Log log = LogFactory.getLog(AbstractJPAVendorAdapter.class);
    private DataSource dataSource;
    private boolean generateDDL;
    private boolean showSQL;

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setGenerateDdl(boolean generateDDl) {
        this.generateDDL = generateDDl;
    }

    public boolean isShowSQL() {
        return this.showSQL;
    }

    public boolean isGenerateDDL() {
        return this.generateDDL;
    }

    @Override
    public void setShowSql(boolean showSQL) {
        this.showSQL = showSQL;
    }

    @Override
    public Map<String, ?> getJpaPropertyMap(TransactionManager tnxManager) {
        return Collections.emptyMap();
    }

    @Override
    public Class<? extends EntityManagerFactory> getEntityManagerFactoryInterface() {
        return EntityManagerFactory.class;
    }

    @Override
    public Class<? extends EntityManager> getEntityManagerInterface() {
        return EntityManager.class;
    }

    protected Connection getDBConnection() throws SQLException {
        Connection c = this.dataSource.getConnection();
        c.setTransactionIsolation(2);
        return c;
    }

    protected void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Exception while closing connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseType determineDbType() {
        Connection con = null;
        DatabaseType dbType = null;
        try {
            con = this.getDBConnection();
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData != null) {
                String dbProductName = metaData.getDatabaseProductName().toLowerCase();
                int dbMajorVer = metaData.getDatabaseMajorVersion();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Using database " + dbProductName + " major version " + dbMajorVer));
                }
                if (dbProductName.contains("db2")) {
                    dbType = DatabaseType.DB2;
                } else if (dbProductName.contains("oracle")) {
                    dbType = DatabaseType.ORACLE;
                } else if (dbProductName.contains("derby")) {
                    dbType = DatabaseType.DERBY;
                } else if (dbProductName.contains("h2")) {
                    dbType = DatabaseType.H2;
                } else if (dbProductName.contains("hsql")) {
                    dbType = DatabaseType.HSQL;
                } else if (dbProductName.contains("microsoft sql")) {
                    dbType = DatabaseType.SQL_SERVER;
                } else if (dbProductName.contains("mysql")) {
                    dbType = DatabaseType.MYSQL;
                } else if (dbProductName.contains("postgresql")) {
                    dbType = DatabaseType.POSTGRESQL;
                } else if (dbProductName.contains("sybase")) {
                    dbType = DatabaseType.SYBASE;
                }
            }
        }
        catch (SQLException e) {
            this.log.warn((Object)"Unable to determine database dialect.", (Throwable)e);
        }
        finally {
            this.close(con);
        }
        return dbType;
    }
}

