/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.dao.jpa.openjpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnection;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnectionFactoryJDBC;
import org.wso2.carbon.humantask.core.dao.jpa.JPAVendorAdapter;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.HumanTaskDAOConnectionImpl;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.OpenJPAVendorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTaskDAOConnectionFactoryImpl
implements HumanTaskDAOConnectionFactoryJDBC {
    private EntityManagerFactory entityManagerFactory;
    private DataSource dataSource;
    private TransactionManager tnxManager;
    private Map<String, Object> jpaPropertiesMap;
    private static ThreadLocal<HumanTaskDAOConnectionImpl> connections = new ThreadLocal();

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void setTransactionManager(TransactionManager tnxManager) {
        this.tnxManager = tnxManager;
    }

    @Override
    public void setDAOConnectionFactoryProperties(Map<String, Object> propertiesMap) {
        this.jpaPropertiesMap = propertiesMap;
    }

    @Override
    public HumanTaskDAOConnection getConnection() {
        try {
            this.tnxManager.getTransaction().registerSynchronization(new Synchronization(){

                public void afterCompletion(int i) {
                    if (connections.get() != null) {
                        ((HumanTaskDAOConnectionImpl)connections.get()).getEntityManager().close();
                    }
                    connections.set(null);
                }

                public void beforeCompletion() {
                }
            });
        }
        catch (RollbackException e) {
            throw new RuntimeException("Coulnd't register synchronizer!", e);
        }
        catch (SystemException e) {
            throw new RuntimeException("Coulnd't register synchronizer!", e);
        }
        if (connections.get() != null) {
            return connections.get();
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("openjpa.TransactionMode", "managed");
        EntityManager em = this.entityManagerFactory.createEntityManager(propMap);
        HumanTaskDAOConnectionImpl conn = this.createHumanTaskDAOConnection(em);
        connections.set(conn);
        return conn;
    }

    protected HumanTaskDAOConnectionImpl createHumanTaskDAOConnection(EntityManager entityManager) {
        return new HumanTaskDAOConnectionImpl(entityManager);
    }

    @Override
    public void init() {
        JPAVendorAdapter vendorAdapter = this.getJPAVendorAdapter();
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"HT-PU", vendorAdapter.getJpaPropertyMap(this.tnxManager));
    }

    private JPAVendorAdapter getJPAVendorAdapter() {
        OpenJPAVendorAdapter vendorAdapter = new OpenJPAVendorAdapter();
        vendorAdapter.setDataSource(this.dataSource);
        Object generateDDL = this.jpaPropertiesMap.get("org.wso2.carbon.humantask.DDLGeneration");
        Object showSQL = this.jpaPropertiesMap.get("org.wso2.carbon.humantask.SQLTracing");
        if (generateDDL == null) {
            generateDDL = Boolean.FALSE.toString();
        }
        if (showSQL == null) {
            showSQL = Boolean.FALSE.toString();
        }
        vendorAdapter.setGenerateDdl((Boolean)generateDDL);
        vendorAdapter.setShowSql((Boolean)showSQL);
        return vendorAdapter;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void shutdown() {
        this.entityManagerFactory.close();
    }
}

