/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.dao.jpa.openjpa;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.api.scheduler.InvalidJobsInDbException;
import org.wso2.carbon.humantask.core.dao.AttachmentDAO;
import org.wso2.carbon.humantask.core.dao.CommentDAO;
import org.wso2.carbon.humantask.core.dao.DeadlineDAO;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnection;
import org.wso2.carbon.humantask.core.dao.HumanTaskJobDAO;
import org.wso2.carbon.humantask.core.dao.MessageDAO;
import org.wso2.carbon.humantask.core.dao.MessageHelper;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.SimpleQueryCriteria;
import org.wso2.carbon.humantask.core.dao.TaskCreationContext;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.dao.TaskType;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.JPATaskUtil;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Attachment;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Comment;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Deadline;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Event;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.GenericHumanRole;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Message;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.OrganizationalEntity;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.util.HumanTaskBuilderImpl;
import org.wso2.carbon.humantask.core.dao.sql.HumanTaskJPQLQueryBuilder;
import org.wso2.carbon.humantask.core.engine.HumanTaskException;
import org.wso2.carbon.humantask.core.engine.util.CommonTaskUtil;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.store.TaskConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTaskDAOConnectionImpl
implements HumanTaskDAOConnection {
    private static final Log log = LogFactory.getLog(HumanTaskDAOConnectionImpl.class);
    private EntityManager entityManager;

    public HumanTaskDAOConnectionImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public TaskDAO createTask(TaskCreationContext creationContext) throws HumanTaskException {
        HumanTaskBuilderImpl taskBuilder = new HumanTaskBuilderImpl();
        MessageDAO inputMessage = this.createMessage(creationContext);
        inputMessage.setMessageType(MessageDAO.MessageType.INPUT);
        taskBuilder.addTaskCreationContext(creationContext).addInputMessage(inputMessage);
        TaskDAO task = taskBuilder.build();
        this.entityManager.persist((Object)task);
        creationContext.injectExpressionEvaluationContext(task);
        JPATaskUtil.processGenericHumanRoles(task, creationContext.getTaskConfiguration(), creationContext.getPeopleQueryEvaluator(), creationContext.getEvalContext());
        JPATaskUtil.processPresentationElements(task, creationContext.getTaskConfiguration(), creationContext);
        CommonTaskUtil.nominate(task, creationContext.getPeopleQueryEvaluator());
        task.setPriority(CommonTaskUtil.calculateTaskPriority(creationContext.getTaskConfiguration(), creationContext.getEvalContext()));
        CommonTaskUtil.setTaskToMessage(task);
        if (TaskType.TASK.equals((Object)task.getType())) {
            CommonTaskUtil.processDeadlines(task, (TaskConfiguration)creationContext.getTaskConfiguration(), creationContext.getEvalContext());
            CommonTaskUtil.scheduleDeadlines(task);
        }
        HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getEventProcessor().processEvent(CommonTaskUtil.createNewTaskEvent(task));
        return task;
    }

    @Override
    public TaskDAO getTask(Long taskId) {
        TaskDAO matchingTask = (TaskDAO)this.entityManager.find(Task.class, (Object)taskId);
        matchingTask.getHumanRoles();
        matchingTask.getParentTask();
        matchingTask.getInputMessage();
        matchingTask.getOutputMessage();
        matchingTask.getFailureMessage();
        matchingTask.getComments();
        matchingTask.getAttachments();
        matchingTask.getPresentationDescriptions();
        matchingTask.getPresentationNames();
        matchingTask.getPresentationSubjects();
        matchingTask.getPresentationParameters();
        matchingTask.getEvents();
        return matchingTask;
    }

    @Override
    public List<TaskDAO> getTasksForUser(String userName) {
        return null;
    }

    @Override
    public MessageDAO createMessage(TaskCreationContext taskCreationContext) {
        Message message = new Message();
        MessageHelper msgHelper = new MessageHelper(message);
        return msgHelper.createMessage(taskCreationContext);
    }

    @Override
    public MessageDAO createMessage() {
        return new Message();
    }

    @Override
    public OrganizationalEntityDAO createNewOrgEntityObject(String userName, OrganizationalEntityDAO.OrganizationalEntityType type) {
        OrganizationalEntity orgEntity = new OrganizationalEntity();
        orgEntity.setName(userName);
        orgEntity.setOrgEntityType(type);
        return orgEntity;
    }

    @Override
    public GenericHumanRoleDAO createNewGHRObject(GenericHumanRoleDAO.GenericHumanRoleType type) {
        GenericHumanRole ghr = new GenericHumanRole();
        ghr.setType(type);
        return ghr;
    }

    @Override
    public void obsoleteTasks(String taskName, Integer tenantId) {
        this.entityManager.createQuery("UPDATE org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task t SET t.status = :statusToSet WHERE t.name = :taskName AND t.tenantId = :tenantId").setParameter("taskName", (Object)taskName).setParameter("tenantId", (Object)tenantId).setParameter("statusToSet", (Object)TaskStatus.OBSOLETE).executeUpdate();
    }

    @Override
    public List<TaskDAO> simpleTaskQuery(SimpleQueryCriteria simpleQueryCriteria) {
        Query taskQuery = this.entityManager.createQuery("SELECT t FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task t WHERE t.status <> :obsoleteStatus ").setParameter("obsoleteStatus", (Object)TaskStatus.OBSOLETE);
        return taskQuery.getResultList();
    }

    @Override
    public List<TaskDAO> searchTasks(SimpleQueryCriteria queryCriteria) {
        HumanTaskJPQLQueryBuilder queryBuilder = new HumanTaskJPQLQueryBuilder(queryCriteria, this.entityManager);
        Query taskQuery = queryBuilder.build();
        return taskQuery.getResultList();
    }

    @Override
    public void removeTasks(SimpleQueryCriteria queryCriteria) {
        HumanTaskJPQLQueryBuilder queryBuilder = new HumanTaskJPQLQueryBuilder(queryCriteria, this.entityManager);
        Query taskQuery = queryBuilder.build();
        taskQuery.executeUpdate();
    }

    @Override
    public CommentDAO getCommentDAO(String commentString, String commentedByUserName) {
        return new Comment(commentString, commentedByUserName);
    }

    @Override
    public DeadlineDAO createDeadline() {
        return new Deadline();
    }

    @Override
    public HumanTaskJobDAO createHumanTaskJobDao() {
        return new HumanTaskJob();
    }

    @Override
    public List<String> getNodeIds() {
        Query q = this.entityManager.createQuery("SELECT DISTINCT t.nodeId FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t");
        return q.getResultList();
    }

    @Override
    public List<HumanTaskJobDAO> dequeueImmediate(String nodeId, long maxtime, int maxjobs) {
        Query q = this.entityManager.createQuery("SELECT DISTINCT t FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t WHERE t.nodeId = ?1 AND t.time < ?2 order by t.time");
        q.setParameter(1, (Object)nodeId);
        q.setParameter(2, (Object)maxtime);
        q.setMaxResults(maxjobs);
        return q.getResultList();
    }

    @Override
    public int updateAssignToNode(String nodeId, int x, int y, long maxtime) {
        Query q = this.entityManager.createQuery("UPDATE org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t SET t.nodeId = ?1 WHERE t.nodeId IS NULL AND MOD(t.time, ?2) = ?3 and t.time < ?4");
        q.setParameter(1, (Object)nodeId);
        q.setParameter(2, (Object)y);
        q.setParameter(3, (Object)x);
        q.setParameter(4, (Object)maxtime);
        return q.executeUpdate();
    }

    @Override
    public int updateReassign(String oldnode, String newnode) {
        Query q = this.entityManager.createQuery("UPDATE org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t SET t.nodeId = ?1, t.scheduled = 0 WHERE t.nodeId = ?2");
        q.setParameter(1, (Object)newnode);
        q.setParameter(2, (Object)oldnode);
        return q.executeUpdate();
    }

    @Override
    public int deleteAllJobs() {
        Query q = this.entityManager.createQuery("DELETE FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob");
        return q.executeUpdate();
    }

    @Override
    public boolean delete(String jobId, String nodeId) {
        Query q = this.entityManager.createQuery("DELETE FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t WHERE t.id = ?1 AND t.nodeId = ?2");
        q.setParameter(1, (Object)jobId);
        q.setParameter(2, (Object)nodeId);
        return q.executeUpdate() == 1;
    }

    @Override
    public List<Long> deleteJobsForTask(Long taskId) {
        Query q = this.entityManager.createQuery("SELECT t.id FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t WHERE t.taskId = ?1");
        q.setParameter(1, (Object)taskId);
        List jobIds = q.getResultList();
        q = this.entityManager.createQuery("DELETE FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t WHERE t.taskId = ?1");
        q.setParameter(1, (Object)taskId);
        q.executeUpdate();
        return jobIds;
    }

    @Override
    public Long updateJob(Long taskId, String name, boolean immediate, boolean nearFuture, String nodeId, Long time) throws InvalidJobsInDbException {
        Query q = this.entityManager.createQuery("SELECT t.id FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t WHERE t.taskId = ?1 AND t.name = ?2");
        q.setParameter(1, (Object)taskId);
        q.setParameter(2, (Object)name);
        List jobIds = q.getResultList();
        if (jobIds.size() != 1) {
            return this.handleException(taskId, name, jobIds.size());
        }
        if (immediate) {
            log.info((Object)"Immediate");
            q = this.entityManager.createQuery("UPDATE org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t SET t.time = ?1, t.nodeId = ?2, t.scheduled = true WHERE t.taskId = ?3 AND t.name = ?4");
            q.setParameter(1, (Object)time);
            q.setParameter(2, (Object)nodeId);
            q.setParameter(3, (Object)taskId);
            q.setParameter(4, (Object)name);
        } else if (nearFuture) {
            log.info((Object)"near");
            q = this.entityManager.createQuery("UPDATE org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t SET t.time = ?1, t.nodeId = ?2, t.scheduled = false WHERE t.taskId = ?3 AND t.name = ?4");
            q.setParameter(1, (Object)time);
            q.setParameter(2, (Object)nodeId);
            q.setParameter(3, (Object)taskId);
            q.setParameter(4, (Object)name);
        } else {
            log.info((Object)"far");
            q = this.entityManager.createQuery("UPDATE org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.HumanTaskJob t SET t.time = ?1,t.nodeId = null, t.scheduled = false WHERE t.taskId = ?2 AND t.name = ?3");
            q.setParameter(1, (Object)time);
            q.setParameter(2, (Object)taskId);
            q.setParameter(3, (Object)name);
        }
        int size = q.executeUpdate();
        if (size != 1) {
            return this.handleException(taskId, name, size);
        }
        return (Long)jobIds.get(0);
    }

    private Long handleException(Long taskId, String name, int size) throws InvalidJobsInDbException {
        if (size == 0) {
            String errMsg = "There are no any jobs, corresponding to Task ID: " + taskId + " and Name: " + name;
            log.warn((Object)errMsg);
            return -1L;
        }
        String errMsg = "More than 1 (" + size + ") jobs are selected to Task ID: " + taskId + " and Name: " + name;
        log.error((Object)errMsg);
        throw new InvalidJobsInDbException(errMsg);
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public EventDAO createNewEventObject(TaskDAO task) {
        Event eventDAO = new Event();
        eventDAO.setTimeStamp(new Date());
        eventDAO.setOldState(task.getStatus());
        return eventDAO;
    }

    @Override
    public AttachmentDAO createAttachment() {
        return new Attachment();
    }
}

