/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.dao.jpa.openjpa;

import java.util.List;
import javax.xml.namespace.QName;
import org.wso2.carbon.humantask.TDescription;
import org.wso2.carbon.humantask.TGenericHumanRoleAssignment;
import org.wso2.carbon.humantask.TNotification;
import org.wso2.carbon.humantask.TPotentialOwnerAssignment;
import org.wso2.carbon.humantask.TPresentationElements;
import org.wso2.carbon.humantask.TPresentationParameter;
import org.wso2.carbon.humantask.TPresentationParameters;
import org.wso2.carbon.humantask.TTask;
import org.wso2.carbon.humantask.TText;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.PresentationParameterDAO;
import org.wso2.carbon.humantask.core.dao.TaskCreationContext;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.GenericHumanRole;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.PresentationDescription;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.PresentationName;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.PresentationParameter;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.PresentationSubject;
import org.wso2.carbon.humantask.core.engine.HumanTaskException;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.engine.runtime.api.EvaluationContext;
import org.wso2.carbon.humantask.core.engine.runtime.xpath.XPathEvaluatorUtil;
import org.wso2.carbon.humantask.core.engine.util.CommonTaskUtil;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.store.NotificationConfiguration;
import org.wso2.carbon.humantask.core.store.TaskConfiguration;

public final class JPATaskUtil {
    private JPATaskUtil() {
    }

    public static void processGenericHumanRoles(TaskDAO task, HumanTaskBaseConfiguration taskConfiguration, PeopleQueryEvaluator peopleQueryEvaluator, EvaluationContext evaluationContext) throws HumanTaskException {
        if (taskConfiguration.isTask()) {
            TGenericHumanRoleAssignment[] tExcludedOwners;
            TGenericHumanRoleAssignment[] tBusinessAdministrators;
            TGenericHumanRoleAssignment[] tStakeHolders;
            TTask tTask = ((TaskConfiguration)taskConfiguration).getTask();
            TPotentialOwnerAssignment[] tPotentialOwners = tTask.getPeopleAssignments().getPotentialOwnersArray();
            if (tPotentialOwners != null && tPotentialOwners.length > 0) {
                TPotentialOwnerAssignment tPotentialOwner = tPotentialOwners[0];
                List<OrganizationalEntityDAO> orgEntities = CommonTaskUtil.getOrganizationalEntities(peopleQueryEvaluator, tPotentialOwner.getFrom(), evaluationContext);
                GenericHumanRole potentialOwnersGHRole = new GenericHumanRole();
                potentialOwnersGHRole.setType(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
                potentialOwnersGHRole.setOrgEntities(orgEntities);
                potentialOwnersGHRole.setTask(task);
                for (OrganizationalEntityDAO oe : orgEntities) {
                    oe.addGenericHumanRole(potentialOwnersGHRole);
                }
                task.addHumanRole(potentialOwnersGHRole);
            }
            if ((tStakeHolders = tTask.getPeopleAssignments().getTaskStakeholdersArray()) != null && tStakeHolders.length > 0) {
                JPATaskUtil.assignHumanRoles(task, peopleQueryEvaluator, tStakeHolders[0], GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS, evaluationContext);
            }
            if ((tBusinessAdministrators = tTask.getPeopleAssignments().getBusinessAdministratorsArray()) != null && tBusinessAdministrators.length > 0) {
                JPATaskUtil.assignHumanRoles(task, peopleQueryEvaluator, tBusinessAdministrators[0], GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS, evaluationContext);
            }
            if ((tExcludedOwners = tTask.getPeopleAssignments().getExcludedOwnersArray()) != null && tExcludedOwners.length > 0) {
                JPATaskUtil.assignHumanRoles(task, peopleQueryEvaluator, tExcludedOwners[0], GenericHumanRoleDAO.GenericHumanRoleType.EXCLUDED_OWNERS, evaluationContext);
            }
        } else {
            TNotification tNotification = ((NotificationConfiguration)taskConfiguration).getNotificationDefinition();
            TGenericHumanRoleAssignment[] tRecipients = tNotification.getPeopleAssignments().getRecipientsArray();
            if (tRecipients != null && tRecipients.length > 0) {
                JPATaskUtil.assignHumanRoles(task, peopleQueryEvaluator, tRecipients[0], GenericHumanRoleDAO.GenericHumanRoleType.NOTIFICATION_RECIPIENTS, evaluationContext);
            }
        }
    }

    private static void assignHumanRoles(TaskDAO task, PeopleQueryEvaluator peopleQueryEvaluator, TGenericHumanRoleAssignment roleAssignment, GenericHumanRoleDAO.GenericHumanRoleType type, EvaluationContext evaluationContext) throws HumanTaskException {
        List<OrganizationalEntityDAO> orgEntities = CommonTaskUtil.getOrganizationalEntities(peopleQueryEvaluator, roleAssignment.getFrom(), evaluationContext);
        GenericHumanRole humanRole = new GenericHumanRole();
        humanRole.setType(type);
        humanRole.setOrgEntities(orgEntities);
        humanRole.setTask(task);
        for (OrganizationalEntityDAO oe : orgEntities) {
            oe.addGenericHumanRole(humanRole);
        }
        task.addHumanRole(humanRole);
    }

    public static void processPresentationElements(TaskDAO task, HumanTaskBaseConfiguration taskConfiguration, TaskCreationContext creationContext) {
        TText[] subjects;
        TText[] names;
        TPresentationElements presentationElements = taskConfiguration.getPresentationElements();
        TPresentationParameters presentationParameters = presentationElements.getPresentationParameters();
        if (presentationParameters != null) {
            TPresentationParameter[] params;
            String expressionLanguage = presentationParameters.getExpressionLanguage() == null ? taskConfiguration.getExpressionLanguage() : presentationParameters.getExpressionLanguage();
            for (TPresentationParameter param : params = presentationParameters.getPresentationParameterArray()) {
                PresentationParameter preParam = new PresentationParameter();
                preParam.setName(param.getName());
                preParam.setTask(task);
                preParam.setType(JPATaskUtil.getTypeFromQName(param.getType()));
                XPathEvaluatorUtil.evaluatePresentationParamXPath(preParam, param.newCursor().getTextValue().trim(), expressionLanguage, creationContext.getEvalContext());
                task.addPresentationParameter(preParam);
            }
        }
        for (TText name : names = presentationElements.getNameArray()) {
            PresentationName preName = new PresentationName();
            preName.setValue(CommonTaskUtil.replaceUsingPresentationParams(task.getPresentationParameters(), name.newCursor().getTextValue().trim()));
            preName.setXmlLang(name.getLang());
            preName.setTask(task);
            task.addPresentationName(preName);
        }
        for (TText subject : subjects = presentationElements.getSubjectArray()) {
            PresentationSubject preSubject = new PresentationSubject();
            preSubject.setValue(CommonTaskUtil.replaceUsingPresentationParams(task.getPresentationParameters(), subject.newCursor().getTextValue().trim()));
            preSubject.setXmlLang(subject.getLang());
            preSubject.setTask(task);
            task.addPresentationSubject(preSubject);
        }
        TDescription[] descriptions = presentationElements.getDescriptionArray();
        if (descriptions != null && descriptions.length > 0) {
            for (TDescription description : descriptions) {
                PresentationDescription preDesc = new PresentationDescription();
                preDesc.setValue(CommonTaskUtil.replaceUsingPresentationParams(task.getPresentationParameters(), description.newCursor().getTextValue().trim()));
                preDesc.setXmlLang(description.getLang());
                preDesc.setTask(task);
                task.addPresentationDescription(preDesc);
            }
        }
    }

    private static PresentationParameterDAO.Type getTypeFromQName(QName type) {
        if ("string".equalsIgnoreCase(type.getLocalPart())) {
            return PresentationParameterDAO.Type.XSD_STRING;
        }
        if ("int".equalsIgnoreCase(type.getLocalPart())) {
            return PresentationParameterDAO.Type.XSD_INT;
        }
        if ("bool".equalsIgnoreCase(type.getLocalPart())) {
            return PresentationParameterDAO.Type.XSD_BOOL;
        }
        if ("date".equalsIgnoreCase(type.getLocalPart())) {
            return PresentationParameterDAO.Type.XSD_DATE;
        }
        if ("decimal".equalsIgnoreCase(type.getLocalPart())) {
            return PresentationParameterDAO.Type.XSD_DECIMALE;
        }
        if ("double".equalsIgnoreCase(type.getLocalPart())) {
            return PresentationParameterDAO.Type.XSD_DOUBLE;
        }
        return PresentationParameterDAO.Type.XSD_ANYTYPE;
    }
}

