/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.dao.jpa.openjpa;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.util.GeneralException;

public class TransactionManagerProvider
implements ManagedRuntime {
    private TransactionManager txMgr;

    public TransactionManagerProvider(TransactionManager txMgr) {
        this.txMgr = txMgr;
    }

    public TransactionManager getTransactionManager() throws Exception {
        return this.txMgr;
    }

    public void setRollbackOnly(Throwable cause) throws Exception {
        this.getTransactionManager().getTransaction().setRollbackOnly();
    }

    public Throwable getRollbackCause() throws Exception {
        return null;
    }

    public Object getTransactionKey() throws Exception, SystemException {
        return this.txMgr.getTransaction();
    }

    public void doNonTransactionalWork(Runnable runnable) throws NotSupportedException {
        Transaction transaction;
        TransactionManager tm;
        try {
            tm = this.getTransactionManager();
            transaction = tm.suspend();
        }
        catch (Exception e) {
            NotSupportedException nse = new NotSupportedException(e.getMessage());
            nse.initCause((Throwable)e);
            throw nse;
        }
        runnable.run();
        try {
            tm.resume(transaction);
        }
        catch (Exception e) {
            try {
                transaction.setRollbackOnly();
            }
            catch (SystemException se2) {
                throw new GeneralException((Throwable)se2);
            }
            NotSupportedException nse = new NotSupportedException(e.getMessage());
            nse.initCause((Throwable)e);
            throw nse;
        }
    }
}

