/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.dao.jpa.openjpa.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.namespace.QName;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.w3c.dom.Element;
import org.wso2.carbon.humantask.core.dao.AttachmentDAO;
import org.wso2.carbon.humantask.core.dao.CommentDAO;
import org.wso2.carbon.humantask.core.dao.DeadlineDAO;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.MessageDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.PresentationDescriptionDAO;
import org.wso2.carbon.humantask.core.dao.PresentationNameDAO;
import org.wso2.carbon.humantask.core.dao.PresentationParameterDAO;
import org.wso2.carbon.humantask.core.dao.PresentationSubjectDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.dao.TaskType;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Attachment;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Comment;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Deadline;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Event;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.GenericHumanRole;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Message;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.OpenJPAEntity;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.PresentationDescription;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.PresentationName;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.PresentationParameter;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.PresentationSubject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="HT_TASK")
public class Task
extends OpenJPAEntity
implements TaskDAO,
PersistenceCapable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(name="TENANT_ID", nullable=false)
    private Integer tenantId;
    @Column(name="TASK_NAME", nullable=false)
    private String name;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TASK_TYPE", nullable=false)
    private TaskType type;
    @Enumerated(value=EnumType.STRING)
    @Column(name="STATUS", nullable=false)
    private TaskStatus status;
    @Enumerated(value=EnumType.STRING)
    @Column(name="STATUS_BEFORE_SUSPENSION", nullable=true)
    private TaskStatus statusBeforeSuspension;
    @Column(name="PRIORITY", nullable=false)
    private Integer priority = 5;
    @OneToMany(targetEntity=Task.class, mappedBy="parentTask", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<TaskDAO> subTasks = new ArrayList<TaskDAO>();
    @ManyToOne
    private Task parentTask;
    @OneToMany(targetEntity=GenericHumanRole.class, mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<GenericHumanRoleDAO> humanRoles = new ArrayList<GenericHumanRoleDAO>();
    @Column(name="CREATED_ON")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn;
    @Column(name="UPDATED_ON")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updatedOn;
    @Column(name="ACTIVATION_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date activationTime;
    @Column(name="EXPIRATION_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date expirationTime;
    @Column(name="START_BY_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startByTime;
    @Column(name="COMPLETE_BY_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date completeByTime;
    @Column(name="INPUT_MESSAGE")
    @OneToOne(targetEntity=Message.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private MessageDAO inputMessage;
    @Column(name="OUTPUT_MESSAGE")
    @OneToOne(targetEntity=Message.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private MessageDAO outputMessage;
    @Column(name="FAILURE_MESSAGE")
    @OneToOne(targetEntity=Message.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private MessageDAO failureMessage;
    @OneToMany(targetEntity=Comment.class, mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<CommentDAO> comments = new ArrayList<CommentDAO>();
    @OneToMany(targetEntity=Attachment.class, mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<AttachmentDAO> attachments = new ArrayList<AttachmentDAO>();
    @Column(name="SKIPABLE", length=1)
    private String skipableStr = "N";
    @Transient
    private Boolean skipable;
    @Column(name="ESCALATED", length=1)
    private String escalatedStr = "N";
    @Transient
    private Boolean escalated;
    @OneToMany(targetEntity=PresentationParameter.class, mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<PresentationParameterDAO> presentationParameters = new ArrayList<PresentationParameterDAO>();
    @OneToMany(targetEntity=PresentationSubject.class, mappedBy="task", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<PresentationSubjectDAO> presentationSubjects = new ArrayList<PresentationSubjectDAO>();
    @OneToMany(targetEntity=PresentationName.class, mappedBy="task", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<PresentationNameDAO> presentationNames = new ArrayList<PresentationNameDAO>();
    @OneToMany(targetEntity=PresentationDescription.class, mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<PresentationDescriptionDAO> presentationDescriptions = new ArrayList<PresentationDescriptionDAO>();
    @OneToMany(targetEntity=Deadline.class, mappedBy="task", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<DeadlineDAO> deadlines = new ArrayList<DeadlineDAO>();
    @OneToMany(targetEntity=Event.class, mappedBy="task", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<EventDAO> events = new ArrayList<EventDAO>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$wso2$carbon$humantask$core$dao$MessageDAO;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Lorg$wso2$carbon$humantask$core$dao$TaskStatus;
    static /* synthetic */ Class class$Lorg$wso2$carbon$humantask$core$dao$TaskType;
    private transient Object pcDetachedState;

    public Task() {
    }

    public Task(QName name, TaskType type, Integer tenantId) {
        this.createdOn = new Date();
        this.status = TaskStatus.UNDEFINED;
        this.name = name.toString();
        this.type = type;
        this.tenantId = tenantId;
    }

    @Override
    public Long getId() {
        return Task.pcGetid(this);
    }

    public void setId(Long id) {
        Task.pcSetid(this, id);
    }

    @Override
    public void setInputMessage(MessageDAO input) {
        Task.pcSetinputMessage(this, input);
    }

    @Override
    public MessageDAO getFailureMessage() {
        return Task.pcGetfailureMessage(this);
    }

    @Override
    public void setFailureMessage(MessageDAO failureMessage) {
        Task.pcSetfailureMessage(this, failureMessage);
    }

    @Override
    public void setTenantId(Integer tenantId) {
        Task.pcSettenantId(this, tenantId);
    }

    @Override
    public Integer getTenantId() {
        return Task.pcGettenantId(this);
    }

    @Override
    public void addPresentationParameter(PresentationParameterDAO param) {
        Task.pcGetpresentationParameters(this).add(param);
    }

    @Override
    public List<PresentationParameterDAO> getPresentationParameters() {
        return Task.pcGetpresentationParameters(this);
    }

    @Override
    public void addPresentationName(PresentationNameDAO preName) {
        Task.pcGetpresentationNames(this).add(preName);
    }

    @Override
    public void addPresentationSubject(PresentationSubjectDAO preSubject) {
        Task.pcGetpresentationSubjects(this).add(preSubject);
    }

    @Override
    public void addPresentationDescription(PresentationDescriptionDAO preDesc) {
        Task.pcGetpresentationDescriptions(this).add(preDesc);
    }

    @Override
    public void addHumanRole(GenericHumanRoleDAO humanRole) {
        Task.pcGethumanRoles(this).add(humanRole);
    }

    @Override
    public List<GenericHumanRoleDAO> getHumanRoles() {
        ArrayList<GenericHumanRoleDAO> humanRoleDAOs = new ArrayList<GenericHumanRoleDAO>();
        if (Task.pcGethumanRoles(this) != null) {
            humanRoleDAOs.addAll(Task.pcGethumanRoles(this));
        }
        return humanRoleDAOs;
    }

    @Override
    public String getName() {
        return Task.pcGetname(this);
    }

    public void setName(String name) {
        Task.pcSetname(this, name);
    }

    @Override
    public TaskType getType() {
        return Task.pcGettype(this);
    }

    public void setType(TaskType type) {
        Task.pcSettype(this, type);
    }

    @Override
    public TaskStatus getStatusBeforeSuspension() {
        return Task.pcGetstatusBeforeSuspension(this);
    }

    @Override
    public void setStatusBeforeSuspension(TaskStatus statusBeforeSuspension) {
        Task.pcSetstatusBeforeSuspension(this, statusBeforeSuspension);
    }

    @Override
    public Integer getPriority() {
        return Task.pcGetpriority(this);
    }

    @Override
    public void setPriority(Integer priority) {
        Task.pcSetpriority(this, priority);
    }

    @Override
    public Date getCreatedOn() {
        return new Date(Task.pcGetcreatedOn(this).getTime());
    }

    @Override
    public void setCreatedOn(Date createdOn) {
        Task.pcSetcreatedOn(this, new Date(createdOn.getTime()));
    }

    @Override
    public Date getUpdatedOn() {
        return Task.pcGetupdatedOn(this);
    }

    @Override
    public void setUpdatedOn(Date updatedOn) {
        Task.pcSetupdatedOn(this, updatedOn);
    }

    @Override
    public Date getActivationTime() {
        if (Task.pcGetactivationTime(this) != null) {
            return new Date(Task.pcGetactivationTime(this).getTime());
        }
        return null;
    }

    @Override
    public void setActivationTime(Date activationTime) {
        if (activationTime != null) {
            Task.pcSetactivationTime(this, new Date(activationTime.getTime()));
        }
    }

    @Override
    public Date getExpirationTime() {
        if (Task.pcGetexpirationTime(this) != null) {
            return new Date(Task.pcGetexpirationTime(this).getTime());
        }
        return null;
    }

    @Override
    public void setExpirationTime(Date expirationTime) {
        if (expirationTime != null) {
            Task.pcSetexpirationTime(this, new Date(expirationTime.getTime()));
        }
    }

    @Override
    public Date getStartByTime() {
        return Task.pcGetstartByTime(this);
    }

    @Override
    public void setStartByTime(Date startByTime) {
        Task.pcSetstartByTime(this, startByTime);
    }

    @Override
    public Date getCompleteByTime() {
        return Task.pcGetcompleteByTime(this);
    }

    @Override
    public void setCompleteByTime(Date completeByTime) {
        Task.pcSetcompleteByTime(this, completeByTime);
    }

    @Override
    public MessageDAO getOutputMessage() {
        return Task.pcGetoutputMessage(this);
    }

    @Override
    public void setOutputMessage(MessageDAO outputMessage) {
        Task.pcSetoutputMessage(this, outputMessage);
    }

    @Override
    public List<AttachmentDAO> getAttachments() {
        return Task.pcGetattachments(this);
    }

    @Override
    public void setAttachments(List<AttachmentDAO> attachments) {
        Task.pcSetattachments(this, attachments);
    }

    @Override
    public boolean addAttachment(AttachmentDAO attachment) {
        return Task.pcGetattachments(this).add(attachment);
    }

    @Override
    public Boolean isEscalated() {
        return "Y".equalsIgnoreCase(Task.pcGetescalatedStr(this));
    }

    @Override
    public void setEscalated(Boolean escalated) {
        this.escalated = escalated;
        if (escalated.booleanValue()) {
            Task.pcSetescalatedStr(this, "Y");
        } else {
            Task.pcSetescalatedStr(this, "N");
        }
    }

    public String getSkipableStr() {
        return this.skipable != false ? "Y" : "N";
    }

    public void setSkipableStr(String skipableStr) {
        Task.pcSetskipableStr(this, skipableStr);
        this.skipable = "Y".equalsIgnoreCase(skipableStr);
    }

    public String getEscalatedStr() {
        return this.escalated != false ? "Y" : "N";
    }

    public void setEscalatedStr(String escalatedStr) {
        Task.pcSetescalatedStr(this, escalatedStr);
    }

    @Override
    public List<PresentationSubjectDAO> getPresentationSubjects() {
        return Task.pcGetpresentationSubjects(this);
    }

    @Override
    public List<PresentationNameDAO> getPresentationNames() {
        return Task.pcGetpresentationNames(this);
    }

    @Override
    public List<PresentationDescriptionDAO> getPresentationDescriptions() {
        return Task.pcGetpresentationDescriptions(this);
    }

    @Override
    public List<DeadlineDAO> getDeadlines() {
        return Task.pcGetdeadlines(this);
    }

    @Override
    public void addDeadline(DeadlineDAO deadlineDAO) {
        Task.pcGetdeadlines(this).add(deadlineDAO);
    }

    @Override
    public List<EventDAO> getEvents() {
        return Task.pcGetevents(this);
    }

    @Override
    public void setEvents(List<EventDAO> events) {
        Task.pcSetevents(this, events);
    }

    @Override
    public void addEvent(EventDAO event) {
        Task.pcGetevents(this).add(event);
    }

    @Override
    public void persistEvent(EventDAO event) {
        event.setTask(this);
        this.getEvents().add(event);
    }

    @Override
    public List<TaskDAO> getSubTasks() {
        return Task.pcGetsubTasks(this);
    }

    @Override
    public void setSubTasks(List<TaskDAO> subTasks) {
        Task.pcSetsubTasks(this, subTasks);
    }

    @Override
    public Task getParentTask() {
        return Task.pcGetparentTask(this);
    }

    @Override
    public void setParentTask(TaskDAO parentTask) {
        Task.pcSetparentTask(this, (Task)parentTask);
    }

    @Override
    public TaskStatus getStatus() {
        return Task.pcGetstatus(this);
    }

    @Override
    public void setStatus(TaskStatus status) {
        Task.pcSetstatus(this, status);
    }

    @Override
    public void start() {
        this.setStatus(TaskStatus.IN_PROGRESS);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void stop() {
        this.setStatus(TaskStatus.RESERVED);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void suspend() {
        this.setStatusBeforeSuspension(this.getStatus());
        this.setStatus(TaskStatus.SUSPENDED);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void complete(MessageDAO response) {
        response.setTask(this);
        this.setOutputMessage(response);
        this.setStatus(TaskStatus.COMPLETED);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void claim(OrganizationalEntityDAO caller) {
        ArrayList<OrganizationalEntityDAO> organizationalEntities = new ArrayList<OrganizationalEntityDAO>();
        organizationalEntities.add(caller);
        GenericHumanRole actualOwnerRole = new GenericHumanRole();
        actualOwnerRole.setType(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        actualOwnerRole.setOrgEntities(organizationalEntities);
        actualOwnerRole.setTask(this);
        caller.addGenericHumanRole(actualOwnerRole);
        this.addHumanRole(actualOwnerRole);
        this.setStatus(TaskStatus.RESERVED);
    }

    @Override
    public void exit() {
        this.setStatus(TaskStatus.EXITED);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void delegate(OrganizationalEntityDAO delegatee) {
        this.claim(delegatee);
    }

    @Override
    public CommentDAO persistComment(CommentDAO comment) {
        ArrayList<CommentDAO> originalCommentList = new ArrayList<CommentDAO>(this.getComments());
        comment.setTask(this);
        this.getComments().add(comment);
        this.getEntityManager().merge((Object)this);
        List<CommentDAO> newCommentList = this.getComments();
        if (newCommentList.size() - originalCommentList.size() == 1) {
            return (CommentDAO)ListUtils.subtract(newCommentList, originalCommentList).get(0);
        }
        return null;
    }

    @Override
    public void deleteComment(Long commentId) {
        Iterator<CommentDAO> i = this.getComments().iterator();
        while (i.hasNext()) {
            CommentDAO comment = i.next();
            if (!comment.getId().equals(commentId)) continue;
            this.getEntityManager().remove((Object)comment);
            i.remove();
            this.getEntityManager().merge((Object)this);
            break;
        }
    }

    @Override
    public void forward(OrganizationalEntityDAO orgEntity) {
        throw new UnsupportedOperationException("The delegate operation is no supported currently.");
    }

    @Override
    public List<CommentDAO> getComments() {
        return Task.pcGetcomments(this);
    }

    @Override
    public String getTaskDescription(String contentType) {
        String presentationDescriptionString = null;
        for (PresentationDescriptionDAO preDesc : this.getPresentationDescriptions()) {
            if (!preDesc.getContentType().trim().equals(contentType.trim())) continue;
            presentationDescriptionString = preDesc.getValue();
            break;
        }
        return presentationDescriptionString;
    }

    @Override
    public void release() {
        Iterator<GenericHumanRoleDAO> iterator = this.getHumanRoles().iterator();
        while (iterator.hasNext()) {
            GenericHumanRoleDAO ghr = iterator.next();
            if (!GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER.equals((Object)ghr.getType())) continue;
            for (OrganizationalEntityDAO orgEntity : ghr.getOrgEntities()) {
                orgEntity.getGenericHumanRoles().clear();
                orgEntity.setGenericHumanRoles(null);
            }
            ghr.getOrgEntities().clear();
            ghr.setOrgEntities(null);
            ghr.setTask(null);
            iterator.remove();
            this.getEntityManager().remove((Object)ghr);
            break;
        }
        this.setStatus(TaskStatus.READY);
    }

    @Override
    public void remove() {
        this.getEntityManager().remove((Object)this.getInputMessage());
        this.getEntityManager().remove(this.getHumanRoles());
        this.getEntityManager().remove((Object)this);
    }

    @Override
    public void resume() {
        this.setStatus(this.getStatusBeforeSuspension());
        this.setStatusBeforeSuspension(null);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void activate() {
        this.setStatus(TaskStatus.READY);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void skip() {
        this.setStatus(TaskStatus.OBSOLETE);
    }

    @Override
    public void updateAndPersistComment(Long commentId, String newComment, String modifiedBy) {
        for (CommentDAO comment : this.getComments()) {
            if (!comment.getId().equals(commentId)) continue;
            comment.setModifiedBy(modifiedBy);
            comment.setModifiedDate(new Date());
            comment.setCommentText(newComment);
            break;
        }
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public Boolean isSkipable() {
        return "Y".equalsIgnoreCase(Task.pcGetskipableStr(this));
    }

    @Override
    public MessageDAO getInputMessage() {
        return Task.pcGetinputMessage(this);
    }

    @Override
    public void setSkipable(Boolean skipable) {
        this.skipable = skipable;
        if (skipable.booleanValue()) {
            Task.pcSetskipableStr(this, "Y");
        } else {
            Task.pcSetskipableStr(this, "N");
        }
    }

    @Override
    public void nominate(List<OrganizationalEntityDAO> nominees) {
        if (nominees != null && nominees.size() > 0) {
            if (nominees.size() == 1) {
                OrganizationalEntityDAO nominee = nominees.get(0);
                if (OrganizationalEntityDAO.OrganizationalEntityType.GROUP.equals((Object)nominee.getOrgEntityType())) {
                    throw new UnsupportedOperationException("Group nominees are not supported");
                }
                GenericHumanRole actualOwnerRole = new GenericHumanRole();
                actualOwnerRole.setType(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
                actualOwnerRole.setTask(this);
                actualOwnerRole.setOrgEntities(nominees);
                for (OrganizationalEntityDAO orgE : nominees) {
                    orgE.addGenericHumanRole(actualOwnerRole);
                }
                this.addHumanRole(actualOwnerRole);
                this.setStatus(TaskStatus.RESERVED);
            } else {
                throw new UnsupportedOperationException("Multiple nominees are not supported yet.");
            }
        }
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void persistPriority(Integer newPriority) {
        this.setPriority(newPriority);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void fail(String faultName, Element faultData) {
        if (faultData != null && StringUtils.isNotEmpty((String)faultName)) {
            Message faultMessage = new Message();
            faultMessage.setMessageType(MessageDAO.MessageType.FAILURE);
            faultMessage.setData(faultData);
            faultMessage.setName(QName.valueOf(faultName));
            faultMessage.setTask((TaskDAO)this);
            this.setFailureMessage(faultMessage);
        }
        this.setStatus(TaskStatus.FAILED);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void deleteFault() {
        this.getEntityManager().remove((Object)this.getFailureMessage());
        this.setFailureMessage(null);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void deleteOutput() {
        this.getEntityManager().remove((Object)this.getOutputMessage());
        this.setOutputMessage(null);
        this.getEntityManager().merge((Object)this);
    }

    @Override
    public void persistFault(String faultName, Element faultData) {
        if (StringUtils.isNotEmpty((String)faultName) && faultData != null) {
            Message faultMessage = new Message();
            faultMessage.setMessageType(MessageDAO.MessageType.FAILURE);
            faultMessage.setData(faultData);
            faultMessage.setName(QName.valueOf(faultName));
            faultMessage.setTask((TaskDAO)this);
            this.setFailureMessage(faultMessage);
            this.getEntityManager().merge((Object)this);
        }
    }

    @Override
    public void persistOutput(String outputName, Element outputData) {
        if (StringUtils.isNotEmpty((String)outputName) && outputData != null) {
            Message message = new Message();
            message.setMessageType(MessageDAO.MessageType.OUTPUT);
            message.setData(outputData);
            message.setName(QName.valueOf(outputName));
            message.setTask((TaskDAO)this);
            this.setOutputMessage(message);
            this.getEntityManager().merge((Object)this);
        }
    }

    @Override
    public void persistToPotentialOwners(OrganizationalEntityDAO delegatee) {
        for (GenericHumanRoleDAO role : this.getHumanRoles()) {
            if (!GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS.equals((Object)role.getType())) continue;
            delegatee.addGenericHumanRole(role);
            role.addOrgEntity(delegatee);
            break;
        }
    }

    @Override
    public GenericHumanRoleDAO getGenericHumanRole(GenericHumanRoleDAO.GenericHumanRoleType type) {
        GenericHumanRoleDAO matchingRole = null;
        for (GenericHumanRoleDAO role : this.getHumanRoles()) {
            if (!type.equals((Object)role.getType())) continue;
            matchingRole = role;
        }
        return matchingRole;
    }

    @Override
    public void replaceOrgEntitiesForLogicalPeopleGroup(GenericHumanRoleDAO.GenericHumanRoleType type, List<OrganizationalEntityDAO> orgEntities) {
        for (GenericHumanRoleDAO role : this.getHumanRoles()) {
            if (!type.equals((Object)role.getType())) continue;
            role.getOrgEntities().clear();
            for (OrganizationalEntityDAO orgEntity : orgEntities) {
                orgEntity.addGenericHumanRole(role);
                role.addOrgEntity(orgEntity);
            }
        }
        this.release();
    }

    @PrePersist
    @PreUpdate
    private void persistLastUpdated() {
        this.setUpdatedOn(new Date());
    }

    public int pcGetEnhancementContractVersion() {
        return 128166;
    }

    static {
        pcFieldNames = new String[]{"activationTime", "attachments", "comments", "completeByTime", "createdOn", "deadlines", "escalatedStr", "events", "expirationTime", "failureMessage", "humanRoles", "id", "inputMessage", "name", "outputMessage", "parentTask", "presentationDescriptions", "presentationNames", "presentationParameters", "presentationSubjects", "priority", "skipableStr", "startByTime", "status", "statusBeforeSuspension", "subTasks", "tenantId", "type", "updatedOn"};
        Class[] classArray = new Class[29];
        Class clazz = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Task.class$("java.util.Date"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Task.class$("java.util.List"));
        classArray[1] = clazz2;
        classArray[2] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Task.class$("java.util.List"));
        classArray[3] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Task.class$("java.util.Date"));
        classArray[4] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Task.class$("java.util.Date"));
        classArray[5] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Task.class$("java.util.List"));
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Task.class$("java.lang.String"));
        classArray[6] = clazz3;
        classArray[7] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Task.class$("java.util.List"));
        classArray[8] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Task.class$("java.util.Date"));
        Class clazz4 = class$Lorg$wso2$carbon$humantask$core$dao$MessageDAO != null ? class$Lorg$wso2$carbon$humantask$core$dao$MessageDAO : (class$Lorg$wso2$carbon$humantask$core$dao$MessageDAO = Task.class$("org.wso2.carbon.humantask.core.dao.MessageDAO"));
        classArray[9] = clazz4;
        classArray[10] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Task.class$("java.util.List"));
        Class clazz5 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = Task.class$("java.lang.Long"));
        classArray[11] = clazz5;
        classArray[12] = class$Lorg$wso2$carbon$humantask$core$dao$MessageDAO != null ? class$Lorg$wso2$carbon$humantask$core$dao$MessageDAO : (class$Lorg$wso2$carbon$humantask$core$dao$MessageDAO = Task.class$("org.wso2.carbon.humantask.core.dao.MessageDAO"));
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Task.class$("java.lang.String"));
        classArray[14] = class$Lorg$wso2$carbon$humantask$core$dao$MessageDAO != null ? class$Lorg$wso2$carbon$humantask$core$dao$MessageDAO : (class$Lorg$wso2$carbon$humantask$core$dao$MessageDAO = Task.class$("org.wso2.carbon.humantask.core.dao.MessageDAO"));
        Class clazz6 = class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task != null ? class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task : (class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task = Task.class$("org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task"));
        classArray[15] = clazz6;
        classArray[16] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Task.class$("java.util.List"));
        classArray[17] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Task.class$("java.util.List"));
        classArray[18] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Task.class$("java.util.List"));
        classArray[19] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Task.class$("java.util.List"));
        Class clazz7 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Task.class$("java.lang.Integer"));
        classArray[20] = clazz7;
        classArray[21] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Task.class$("java.lang.String"));
        classArray[22] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Task.class$("java.util.Date"));
        Class clazz8 = class$Lorg$wso2$carbon$humantask$core$dao$TaskStatus != null ? class$Lorg$wso2$carbon$humantask$core$dao$TaskStatus : (class$Lorg$wso2$carbon$humantask$core$dao$TaskStatus = Task.class$("org.wso2.carbon.humantask.core.dao.TaskStatus"));
        classArray[23] = clazz8;
        classArray[24] = class$Lorg$wso2$carbon$humantask$core$dao$TaskStatus != null ? class$Lorg$wso2$carbon$humantask$core$dao$TaskStatus : (class$Lorg$wso2$carbon$humantask$core$dao$TaskStatus = Task.class$("org.wso2.carbon.humantask.core.dao.TaskStatus"));
        classArray[25] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Task.class$("java.util.List"));
        classArray[26] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Task.class$("java.lang.Integer"));
        Class clazz9 = class$Lorg$wso2$carbon$humantask$core$dao$TaskType != null ? class$Lorg$wso2$carbon$humantask$core$dao$TaskType : (class$Lorg$wso2$carbon$humantask$core$dao$TaskType = Task.class$("org.wso2.carbon.humantask.core.dao.TaskType"));
        classArray[27] = clazz9;
        classArray[28] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Task.class$("java.util.Date"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 5, 5, 26, 26, 10, 26, 5, 26, 5, 5, 26, 5, 26, 5, 10, 5, 10, 5, 10, 26, 26, 26, 26, 26, 5, 26, 26, 26};
        PCRegistry.register((Class)(class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task != null ? class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task : (class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task = Task.class$("org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task"))), (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Task", (PersistenceCapable)new Task());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.activationTime = null;
        this.attachments = null;
        this.comments = null;
        this.completeByTime = null;
        this.createdOn = null;
        this.deadlines = null;
        this.escalatedStr = null;
        this.events = null;
        this.expirationTime = null;
        this.failureMessage = null;
        this.humanRoles = null;
        this.id = null;
        this.inputMessage = null;
        this.name = null;
        this.outputMessage = null;
        this.parentTask = null;
        this.presentationDescriptions = null;
        this.presentationNames = null;
        this.presentationParameters = null;
        this.presentationSubjects = null;
        this.priority = null;
        this.skipableStr = null;
        this.startByTime = null;
        this.status = null;
        this.statusBeforeSuspension = null;
        this.subTasks = null;
        this.tenantId = null;
        this.type = null;
        this.updatedOn = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Task task = new Task();
        if (bl) {
            task.pcClearFields();
        }
        task.pcStateManager = stateManager;
        task.pcCopyKeyFieldsFromObjectId(object);
        return task;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Task task = new Task();
        if (bl) {
            task.pcClearFields();
        }
        task.pcStateManager = stateManager;
        return task;
    }

    protected static int pcGetManagedFieldCount() {
        return 29;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.activationTime = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.attachments = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.comments = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.completeByTime = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.createdOn = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.deadlines = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.escalatedStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.events = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.expirationTime = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.failureMessage = (MessageDAO)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.humanRoles = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.inputMessage = (MessageDAO)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.outputMessage = (MessageDAO)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.parentTask = (Task)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.presentationDescriptions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.presentationNames = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.presentationParameters = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.presentationSubjects = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.priority = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.skipableStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.startByTime = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 23: {
                this.status = (TaskStatus)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 24: {
                this.statusBeforeSuspension = (TaskStatus)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 25: {
                this.subTasks = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 26: {
                this.tenantId = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 27: {
                this.type = (TaskType)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 28: {
                this.updatedOn = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.activationTime);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.attachments);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.comments);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.completeByTime);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdOn);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.deadlines);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.escalatedStr);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.events);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.expirationTime);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.failureMessage);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.humanRoles);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.inputMessage);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.outputMessage);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.parentTask);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.presentationDescriptions);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.presentationNames);
                return;
            }
            case 18: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.presentationParameters);
                return;
            }
            case 19: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.presentationSubjects);
                return;
            }
            case 20: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.priority);
                return;
            }
            case 21: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.skipableStr);
                return;
            }
            case 22: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.startByTime);
                return;
            }
            case 23: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.status);
                return;
            }
            case 24: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.statusBeforeSuspension);
                return;
            }
            case 25: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.subTasks);
                return;
            }
            case 26: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.tenantId);
                return;
            }
            case 27: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
            case 28: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.updatedOn);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Task task, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.activationTime = task.activationTime;
                return;
            }
            case 1: {
                this.attachments = task.attachments;
                return;
            }
            case 2: {
                this.comments = task.comments;
                return;
            }
            case 3: {
                this.completeByTime = task.completeByTime;
                return;
            }
            case 4: {
                this.createdOn = task.createdOn;
                return;
            }
            case 5: {
                this.deadlines = task.deadlines;
                return;
            }
            case 6: {
                this.escalatedStr = task.escalatedStr;
                return;
            }
            case 7: {
                this.events = task.events;
                return;
            }
            case 8: {
                this.expirationTime = task.expirationTime;
                return;
            }
            case 9: {
                this.failureMessage = task.failureMessage;
                return;
            }
            case 10: {
                this.humanRoles = task.humanRoles;
                return;
            }
            case 11: {
                this.id = task.id;
                return;
            }
            case 12: {
                this.inputMessage = task.inputMessage;
                return;
            }
            case 13: {
                this.name = task.name;
                return;
            }
            case 14: {
                this.outputMessage = task.outputMessage;
                return;
            }
            case 15: {
                this.parentTask = task.parentTask;
                return;
            }
            case 16: {
                this.presentationDescriptions = task.presentationDescriptions;
                return;
            }
            case 17: {
                this.presentationNames = task.presentationNames;
                return;
            }
            case 18: {
                this.presentationParameters = task.presentationParameters;
                return;
            }
            case 19: {
                this.presentationSubjects = task.presentationSubjects;
                return;
            }
            case 20: {
                this.priority = task.priority;
                return;
            }
            case 21: {
                this.skipableStr = task.skipableStr;
                return;
            }
            case 22: {
                this.startByTime = task.startByTime;
                return;
            }
            case 23: {
                this.status = task.status;
                return;
            }
            case 24: {
                this.statusBeforeSuspension = task.statusBeforeSuspension;
                return;
            }
            case 25: {
                this.subTasks = task.subTasks;
                return;
            }
            case 26: {
                this.tenantId = task.tenantId;
                return;
            }
            case 27: {
                this.type = task.type;
                return;
            }
            case 28: {
                this.updatedOn = task.updatedOn;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        Task task = (Task)object;
        if (task.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(task, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(11 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task != null ? class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task : (class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task = Task.class$("org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task != null ? class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task : (class$Lorg$wso2$carbon$humantask$core$dao$jpa$openjpa$model$Task = Task.class$("org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task"));
        return new LongId(clazz, this.id);
    }

    private static final Date pcGetactivationTime(Task task) {
        if (task.pcStateManager == null) {
            return task.activationTime;
        }
        int n = pcInheritedFieldCount + 0;
        task.pcStateManager.accessingField(n);
        return task.activationTime;
    }

    private static final void pcSetactivationTime(Task task, Date date) {
        if (task.pcStateManager == null) {
            task.activationTime = date;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 0, (Object)task.activationTime, (Object)date, 0);
    }

    private static final List pcGetattachments(Task task) {
        if (task.pcStateManager == null) {
            return task.attachments;
        }
        int n = pcInheritedFieldCount + 1;
        task.pcStateManager.accessingField(n);
        return task.attachments;
    }

    private static final void pcSetattachments(Task task, List list) {
        if (task.pcStateManager == null) {
            task.attachments = list;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 1, task.attachments, (Object)list, 0);
    }

    private static final List pcGetcomments(Task task) {
        if (task.pcStateManager == null) {
            return task.comments;
        }
        int n = pcInheritedFieldCount + 2;
        task.pcStateManager.accessingField(n);
        return task.comments;
    }

    private static final void pcSetcomments(Task task, List list) {
        if (task.pcStateManager == null) {
            task.comments = list;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 2, task.comments, (Object)list, 0);
    }

    private static final Date pcGetcompleteByTime(Task task) {
        if (task.pcStateManager == null) {
            return task.completeByTime;
        }
        int n = pcInheritedFieldCount + 3;
        task.pcStateManager.accessingField(n);
        return task.completeByTime;
    }

    private static final void pcSetcompleteByTime(Task task, Date date) {
        if (task.pcStateManager == null) {
            task.completeByTime = date;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 3, (Object)task.completeByTime, (Object)date, 0);
    }

    private static final Date pcGetcreatedOn(Task task) {
        if (task.pcStateManager == null) {
            return task.createdOn;
        }
        int n = pcInheritedFieldCount + 4;
        task.pcStateManager.accessingField(n);
        return task.createdOn;
    }

    private static final void pcSetcreatedOn(Task task, Date date) {
        if (task.pcStateManager == null) {
            task.createdOn = date;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 4, (Object)task.createdOn, (Object)date, 0);
    }

    private static final List pcGetdeadlines(Task task) {
        if (task.pcStateManager == null) {
            return task.deadlines;
        }
        int n = pcInheritedFieldCount + 5;
        task.pcStateManager.accessingField(n);
        return task.deadlines;
    }

    private static final void pcSetdeadlines(Task task, List list) {
        if (task.pcStateManager == null) {
            task.deadlines = list;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 5, task.deadlines, (Object)list, 0);
    }

    private static final String pcGetescalatedStr(Task task) {
        if (task.pcStateManager == null) {
            return task.escalatedStr;
        }
        int n = pcInheritedFieldCount + 6;
        task.pcStateManager.accessingField(n);
        return task.escalatedStr;
    }

    private static final void pcSetescalatedStr(Task task, String string) {
        if (task.pcStateManager == null) {
            task.escalatedStr = string;
            return;
        }
        task.pcStateManager.settingStringField((PersistenceCapable)task, pcInheritedFieldCount + 6, task.escalatedStr, string, 0);
    }

    private static final List pcGetevents(Task task) {
        if (task.pcStateManager == null) {
            return task.events;
        }
        int n = pcInheritedFieldCount + 7;
        task.pcStateManager.accessingField(n);
        return task.events;
    }

    private static final void pcSetevents(Task task, List list) {
        if (task.pcStateManager == null) {
            task.events = list;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 7, task.events, (Object)list, 0);
    }

    private static final Date pcGetexpirationTime(Task task) {
        if (task.pcStateManager == null) {
            return task.expirationTime;
        }
        int n = pcInheritedFieldCount + 8;
        task.pcStateManager.accessingField(n);
        return task.expirationTime;
    }

    private static final void pcSetexpirationTime(Task task, Date date) {
        if (task.pcStateManager == null) {
            task.expirationTime = date;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 8, (Object)task.expirationTime, (Object)date, 0);
    }

    private static final MessageDAO pcGetfailureMessage(Task task) {
        if (task.pcStateManager == null) {
            return task.failureMessage;
        }
        int n = pcInheritedFieldCount + 9;
        task.pcStateManager.accessingField(n);
        return task.failureMessage;
    }

    private static final void pcSetfailureMessage(Task task, MessageDAO messageDAO) {
        if (task.pcStateManager == null) {
            task.failureMessage = messageDAO;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 9, (Object)task.failureMessage, (Object)messageDAO, 0);
    }

    private static final List pcGethumanRoles(Task task) {
        if (task.pcStateManager == null) {
            return task.humanRoles;
        }
        int n = pcInheritedFieldCount + 10;
        task.pcStateManager.accessingField(n);
        return task.humanRoles;
    }

    private static final void pcSethumanRoles(Task task, List list) {
        if (task.pcStateManager == null) {
            task.humanRoles = list;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 10, task.humanRoles, (Object)list, 0);
    }

    private static final Long pcGetid(Task task) {
        if (task.pcStateManager == null) {
            return task.id;
        }
        int n = pcInheritedFieldCount + 11;
        task.pcStateManager.accessingField(n);
        return task.id;
    }

    private static final void pcSetid(Task task, Long l) {
        if (task.pcStateManager == null) {
            task.id = l;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 11, (Object)task.id, (Object)l, 0);
    }

    private static final MessageDAO pcGetinputMessage(Task task) {
        if (task.pcStateManager == null) {
            return task.inputMessage;
        }
        int n = pcInheritedFieldCount + 12;
        task.pcStateManager.accessingField(n);
        return task.inputMessage;
    }

    private static final void pcSetinputMessage(Task task, MessageDAO messageDAO) {
        if (task.pcStateManager == null) {
            task.inputMessage = messageDAO;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 12, (Object)task.inputMessage, (Object)messageDAO, 0);
    }

    private static final String pcGetname(Task task) {
        if (task.pcStateManager == null) {
            return task.name;
        }
        int n = pcInheritedFieldCount + 13;
        task.pcStateManager.accessingField(n);
        return task.name;
    }

    private static final void pcSetname(Task task, String string) {
        if (task.pcStateManager == null) {
            task.name = string;
            return;
        }
        task.pcStateManager.settingStringField((PersistenceCapable)task, pcInheritedFieldCount + 13, task.name, string, 0);
    }

    private static final MessageDAO pcGetoutputMessage(Task task) {
        if (task.pcStateManager == null) {
            return task.outputMessage;
        }
        int n = pcInheritedFieldCount + 14;
        task.pcStateManager.accessingField(n);
        return task.outputMessage;
    }

    private static final void pcSetoutputMessage(Task task, MessageDAO messageDAO) {
        if (task.pcStateManager == null) {
            task.outputMessage = messageDAO;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 14, (Object)task.outputMessage, (Object)messageDAO, 0);
    }

    private static final Task pcGetparentTask(Task task) {
        if (task.pcStateManager == null) {
            return task.parentTask;
        }
        int n = pcInheritedFieldCount + 15;
        task.pcStateManager.accessingField(n);
        return task.parentTask;
    }

    private static final void pcSetparentTask(Task task, Task task2) {
        if (task.pcStateManager == null) {
            task.parentTask = task2;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 15, (Object)task.parentTask, (Object)task2, 0);
    }

    private static final List pcGetpresentationDescriptions(Task task) {
        if (task.pcStateManager == null) {
            return task.presentationDescriptions;
        }
        int n = pcInheritedFieldCount + 16;
        task.pcStateManager.accessingField(n);
        return task.presentationDescriptions;
    }

    private static final void pcSetpresentationDescriptions(Task task, List list) {
        if (task.pcStateManager == null) {
            task.presentationDescriptions = list;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 16, task.presentationDescriptions, (Object)list, 0);
    }

    private static final List pcGetpresentationNames(Task task) {
        if (task.pcStateManager == null) {
            return task.presentationNames;
        }
        int n = pcInheritedFieldCount + 17;
        task.pcStateManager.accessingField(n);
        return task.presentationNames;
    }

    private static final void pcSetpresentationNames(Task task, List list) {
        if (task.pcStateManager == null) {
            task.presentationNames = list;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 17, task.presentationNames, (Object)list, 0);
    }

    private static final List pcGetpresentationParameters(Task task) {
        if (task.pcStateManager == null) {
            return task.presentationParameters;
        }
        int n = pcInheritedFieldCount + 18;
        task.pcStateManager.accessingField(n);
        return task.presentationParameters;
    }

    private static final void pcSetpresentationParameters(Task task, List list) {
        if (task.pcStateManager == null) {
            task.presentationParameters = list;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 18, task.presentationParameters, (Object)list, 0);
    }

    private static final List pcGetpresentationSubjects(Task task) {
        if (task.pcStateManager == null) {
            return task.presentationSubjects;
        }
        int n = pcInheritedFieldCount + 19;
        task.pcStateManager.accessingField(n);
        return task.presentationSubjects;
    }

    private static final void pcSetpresentationSubjects(Task task, List list) {
        if (task.pcStateManager == null) {
            task.presentationSubjects = list;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 19, task.presentationSubjects, (Object)list, 0);
    }

    private static final Integer pcGetpriority(Task task) {
        if (task.pcStateManager == null) {
            return task.priority;
        }
        int n = pcInheritedFieldCount + 20;
        task.pcStateManager.accessingField(n);
        return task.priority;
    }

    private static final void pcSetpriority(Task task, Integer n) {
        if (task.pcStateManager == null) {
            task.priority = n;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 20, (Object)task.priority, (Object)n, 0);
    }

    private static final String pcGetskipableStr(Task task) {
        if (task.pcStateManager == null) {
            return task.skipableStr;
        }
        int n = pcInheritedFieldCount + 21;
        task.pcStateManager.accessingField(n);
        return task.skipableStr;
    }

    private static final void pcSetskipableStr(Task task, String string) {
        if (task.pcStateManager == null) {
            task.skipableStr = string;
            return;
        }
        task.pcStateManager.settingStringField((PersistenceCapable)task, pcInheritedFieldCount + 21, task.skipableStr, string, 0);
    }

    private static final Date pcGetstartByTime(Task task) {
        if (task.pcStateManager == null) {
            return task.startByTime;
        }
        int n = pcInheritedFieldCount + 22;
        task.pcStateManager.accessingField(n);
        return task.startByTime;
    }

    private static final void pcSetstartByTime(Task task, Date date) {
        if (task.pcStateManager == null) {
            task.startByTime = date;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 22, (Object)task.startByTime, (Object)date, 0);
    }

    private static final TaskStatus pcGetstatus(Task task) {
        if (task.pcStateManager == null) {
            return task.status;
        }
        int n = pcInheritedFieldCount + 23;
        task.pcStateManager.accessingField(n);
        return task.status;
    }

    private static final void pcSetstatus(Task task, TaskStatus taskStatus) {
        if (task.pcStateManager == null) {
            task.status = taskStatus;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 23, (Object)task.status, (Object)taskStatus, 0);
    }

    private static final TaskStatus pcGetstatusBeforeSuspension(Task task) {
        if (task.pcStateManager == null) {
            return task.statusBeforeSuspension;
        }
        int n = pcInheritedFieldCount + 24;
        task.pcStateManager.accessingField(n);
        return task.statusBeforeSuspension;
    }

    private static final void pcSetstatusBeforeSuspension(Task task, TaskStatus taskStatus) {
        if (task.pcStateManager == null) {
            task.statusBeforeSuspension = taskStatus;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 24, (Object)task.statusBeforeSuspension, (Object)taskStatus, 0);
    }

    private static final List pcGetsubTasks(Task task) {
        if (task.pcStateManager == null) {
            return task.subTasks;
        }
        int n = pcInheritedFieldCount + 25;
        task.pcStateManager.accessingField(n);
        return task.subTasks;
    }

    private static final void pcSetsubTasks(Task task, List list) {
        if (task.pcStateManager == null) {
            task.subTasks = list;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 25, task.subTasks, (Object)list, 0);
    }

    private static final Integer pcGettenantId(Task task) {
        if (task.pcStateManager == null) {
            return task.tenantId;
        }
        int n = pcInheritedFieldCount + 26;
        task.pcStateManager.accessingField(n);
        return task.tenantId;
    }

    private static final void pcSettenantId(Task task, Integer n) {
        if (task.pcStateManager == null) {
            task.tenantId = n;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 26, (Object)task.tenantId, (Object)n, 0);
    }

    private static final TaskType pcGettype(Task task) {
        if (task.pcStateManager == null) {
            return task.type;
        }
        int n = pcInheritedFieldCount + 27;
        task.pcStateManager.accessingField(n);
        return task.type;
    }

    private static final void pcSettype(Task task, TaskType taskType) {
        if (task.pcStateManager == null) {
            task.type = taskType;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 27, (Object)task.type, (Object)taskType, 0);
    }

    private static final Date pcGetupdatedOn(Task task) {
        if (task.pcStateManager == null) {
            return task.updatedOn;
        }
        int n = pcInheritedFieldCount + 28;
        task.pcStateManager.accessingField(n);
        return task.updatedOn;
    }

    private static final void pcSetupdatedOn(Task task, Date date) {
        if (task.pcStateManager == null) {
            task.updatedOn = date;
            return;
        }
        task.pcStateManager.settingObjectField((PersistenceCapable)task, pcInheritedFieldCount + 28, (Object)task.updatedOn, (Object)date, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

