/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.dao.jpa.openjpa.util;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.api.client.TransformerUtils;
import org.wso2.carbon.humantask.core.dao.MessageDAO;
import org.wso2.carbon.humantask.core.dao.TaskCreationContext;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.dao.TaskType;
import org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task;
import org.wso2.carbon.humantask.core.engine.HumanTaskException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;

public class HumanTaskBuilderImpl {
    private static Log log = LogFactory.getLog(HumanTaskBuilderImpl.class);
    private TaskCreationContext creationContext;
    private MessageDAO inputMessage;

    public HumanTaskBuilderImpl addTaskCreationContext(TaskCreationContext creationContext) {
        this.creationContext = creationContext;
        return this;
    }

    public HumanTaskBuilderImpl addInputMessage(MessageDAO inputMessage) {
        this.inputMessage = inputMessage;
        return this;
    }

    public TaskDAO build() {
        this.validateParams();
        HumanTaskBaseConfiguration taskConfiguration = this.creationContext.getTaskConfiguration();
        int tenantId = this.creationContext.getTenantId();
        Task task = this.creationContext.getTaskConfiguration().isTask() ? new Task(taskConfiguration.getName(), TaskType.TASK, tenantId) : new Task(taskConfiguration.getName(), TaskType.NOTIFICATION, tenantId);
        task.setInputMessage(this.inputMessage);
        task.setSkipable(false);
        task.setEscalated(false);
        task.setStatus(TaskStatus.CREATED);
        task.setActivationTime(new Date());
        try {
            task.setAttachments(TransformerUtils.generateAttachmentDAOListFromIDs(task, this.creationContext.getAttachmentIDs()));
        }
        catch (HumanTaskException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return task;
    }

    private void validateParams() {
        if (this.inputMessage == null) {
            throw new HumanTaskRuntimeException("the input message cannot be null");
        }
        if (this.creationContext == null) {
            throw new HumanTaskRuntimeException("the task creation context cannot be null");
        }
    }
}

