/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.dao.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.SimpleQueryCriteria;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.dao.TaskType;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTaskJPQLQueryBuilder {
    private static final String SELECT_TASKS = " SELECT t FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task t ";
    private static final String JOIN_HUMAN_ROLES_JOIN_ORG_ENTITIES = " JOIN t.humanRoles hr JOIN hr.orgEntities oe WHERE  ";
    private static final String OE_NAME_IN_NAMES = " oe.name IN :names ";
    private static final String AND = " AND ";
    private static final String HR_TYPE_ROLE_TYPE = " hr.type = :roleType ";
    private static final String T_TYPE_TASK_TYPE = " t.type = :taskType ";
    private static final String T_TENANT_ID_TENANT_ID = " t.tenantId = :tenantId ";
    private static final String ORDER_BY_T_CREATED_ON_DESC = " ORDER BY t.createdOn DESC ";
    private static final String T_STATUS_IN_TASK_STATUSES = " t.status IN :taskStatuses ";
    private static final String T_STATUS_NOT_IN_TASK_STATUSES = " t.status NOT IN :taskStatuses ";
    private static final String NAMES = "names";
    private static final String TENANT_ID = "tenantId";
    private static final String ROLE_TYPE = "roleType";
    private static final String TASK_TYPE = "taskType";
    private static final String TASK_STATUSES = "taskStatuses";
    private SimpleQueryCriteria queryCriteria;
    private EntityManager em;

    public HumanTaskJPQLQueryBuilder(SimpleQueryCriteria criteria, EntityManager em) {
        this.queryCriteria = criteria;
        this.em = em;
    }

    public Query build() {
        switch (this.queryCriteria.getSimpleQueryType()) {
            case ASSIGNED_TO_ME: {
                return this.buildAssignedToMeQuery();
            }
            case ASSIGNABLE: {
                return this.buildAdministrableTasksQuery();
            }
            case CLAIMABLE: {
                return this.buildClaimableQuery();
            }
            case ALL_TASKS: {
                return this.buildAllTasksQuery();
            }
            case NOTIFICATIONS: {
                return this.buildNotificationsQuery();
            }
            case REMOVE_TASKS: {
                return this.buildRemoveTasksQuery();
            }
        }
        return null;
    }

    private Query buildAdministrableTasksQuery() {
        Query administrableTasksQuery = this.em.createQuery(" SELECT t FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task t  JOIN t.humanRoles hr JOIN hr.orgEntities oe WHERE   oe.name IN :names  AND  hr.type = :roleType  AND  t.type = :taskType  AND  t.tenantId = :tenantId  ORDER BY t.createdOn DESC ");
        List<String> rolesAndNamesList = this.getNameListForUser(this.queryCriteria.getCaller(), true);
        administrableTasksQuery.setParameter(NAMES, rolesAndNamesList);
        administrableTasksQuery.setParameter(TENANT_ID, (Object)this.queryCriteria.getCallerTenantId());
        administrableTasksQuery.setParameter(ROLE_TYPE, (Object)GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        administrableTasksQuery.setParameter(TASK_TYPE, (Object)TaskType.TASK);
        return administrableTasksQuery;
    }

    private Query buildClaimableQuery() {
        Query claimableTasksQuery = this.em.createQuery(" SELECT t FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task t  JOIN t.humanRoles hr JOIN hr.orgEntities oe WHERE   oe.name IN :names  AND  hr.type = :roleType  AND  t.type = :taskType  AND  t.tenantId = :tenantId  AND  t.status IN :taskStatuses  ORDER BY t.createdOn DESC ");
        List<String> rolesAndNamesList = this.getNameListForUser(this.queryCriteria.getCaller(), false);
        claimableTasksQuery.setParameter(NAMES, rolesAndNamesList);
        claimableTasksQuery.setParameter(TENANT_ID, (Object)this.queryCriteria.getCallerTenantId());
        claimableTasksQuery.setParameter(ROLE_TYPE, (Object)GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        claimableTasksQuery.setParameter(TASK_TYPE, (Object)TaskType.TASK);
        List<TaskStatus> statusList = Arrays.asList(TaskStatus.READY);
        claimableTasksQuery.setParameter(TASK_STATUSES, statusList);
        return claimableTasksQuery;
    }

    private Query buildAllTasksQuery() {
        Query allTasksQuery = this.em.createQuery(" SELECT DISTINCT t FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task t  JOIN t.humanRoles hr JOIN hr.orgEntities oe WHERE   oe.name IN :names  AND  t.status NOT IN :taskStatuses  AND  t.type = :taskType  AND  t.tenantId = :tenantId  ORDER BY t.createdOn DESC ");
        List<String> rolesAndNamesList = this.getNameListForUser(this.queryCriteria.getCaller(), true);
        allTasksQuery.setParameter(NAMES, rolesAndNamesList);
        allTasksQuery.setParameter(TENANT_ID, (Object)this.queryCriteria.getCallerTenantId());
        List<TaskStatus> statusList = Arrays.asList(TaskStatus.OBSOLETE);
        allTasksQuery.setParameter(TASK_STATUSES, statusList);
        allTasksQuery.setParameter(TASK_TYPE, (Object)TaskType.TASK);
        return allTasksQuery;
    }

    private Query buildAssignedToMeQuery() {
        Query assignedToMeQuery = this.em.createQuery(" SELECT t FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task t  JOIN t.humanRoles hr JOIN hr.orgEntities oe WHERE   oe.name = :name  AND  hr.type = :roleType  AND  t.tenantId = :tenantId  AND  t.type = :taskType  AND  t.status NOT IN :taskStatuses  ORDER BY t.createdOn DESC ");
        assignedToMeQuery.setParameter(TENANT_ID, (Object)this.queryCriteria.getCallerTenantId());
        assignedToMeQuery.setParameter("name", (Object)this.queryCriteria.getCaller());
        assignedToMeQuery.setParameter(TASK_TYPE, (Object)TaskType.TASK);
        assignedToMeQuery.setParameter(ROLE_TYPE, (Object)GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        List<TaskStatus> statusList = Arrays.asList(TaskStatus.COMPLETED, TaskStatus.OBSOLETE, TaskStatus.FAILED, TaskStatus.REMOVED);
        assignedToMeQuery.setParameter(TASK_STATUSES, statusList);
        return assignedToMeQuery;
    }

    private Query buildRemoveTasksQuery() {
        Query removeTasksQuery = this.em.createQuery(" DELETE FROM  org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task t   WHERE t.status in :removableStatuses");
        removeTasksQuery.setParameter("removableStatuses", this.queryCriteria.getStatuses());
        return removeTasksQuery;
    }

    private Query buildNotificationsQuery() {
        Query notificationsQuery = this.em.createQuery(" SELECT t FROM org.wso2.carbon.humantask.core.dao.jpa.openjpa.model.Task t  JOIN t.humanRoles hr JOIN hr.orgEntities oe WHERE   oe.name IN :names  AND  hr.type = :roleType  AND  t.tenantId = :tenantId  AND  t.type = :taskType  ORDER BY t.createdOn DESC ");
        notificationsQuery.setParameter(TENANT_ID, (Object)this.queryCriteria.getCallerTenantId());
        List<String> rolesAndNamesList = this.getNameListForUser(this.queryCriteria.getCaller(), true);
        notificationsQuery.setParameter(NAMES, rolesAndNamesList);
        notificationsQuery.setParameter(ROLE_TYPE, (Object)GenericHumanRoleDAO.GenericHumanRoleType.NOTIFICATION_RECIPIENTS);
        notificationsQuery.setParameter(TASK_TYPE, (Object)TaskType.NOTIFICATION);
        return notificationsQuery;
    }

    private List<String> getNameListForUser(String userName, boolean includeUserName) {
        ArrayList<String> roleNameList = new ArrayList<String>();
        if (includeUserName) {
            roleNameList.add(userName);
        }
        PeopleQueryEvaluator peopleQueryEvaluator = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getPeopleQueryEvaluator();
        roleNameList.addAll(peopleQueryEvaluator.getRoleNameListForUser(userName));
        return roleNameList;
    }
}

