/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.db;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.configuration.HumanTaskServerConfiguration;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnectionFactoryJDBC;
import org.wso2.carbon.humantask.core.db.DatabaseConfigurationException;
import org.wso2.carbon.humantask.core.engine.HumanTaskServerException;
import org.wso2.carbon.humantask.core.utils.HumanTaskDatabaseCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private static final Log log = LogFactory.getLog(Database.class);
    private HumanTaskServerConfiguration serverConfiguration;
    private boolean started;
    private TransactionManager tnxManager;
    private DataSource dataSource;

    public synchronized DataSource getDataSource() {
        if (this.dataSource == null) {
            throw new RuntimeException("Human Task Database is not properly initialised!");
        }
        return this.dataSource;
    }

    public Database(HumanTaskServerConfiguration htConfig) {
        if (htConfig == null) {
            throw new IllegalArgumentException("Must provide the human task server configuration!");
        }
        this.serverConfiguration = htConfig;
    }

    public synchronized void start() throws DatabaseConfigurationException, HumanTaskServerException {
        if (this.started) {
            return;
        }
        this.dataSource = null;
        this.initDataSource();
        this.setupHumanTaskDatabase();
    }

    private void setupHumanTaskDatabase() throws HumanTaskServerException {
        if (System.getProperty("setup") != null) {
            HumanTaskDatabaseCreator humantaskDBCreator;
            try {
                humantaskDBCreator = new HumanTaskDatabaseCreator(this.getDataSource());
            }
            catch (Exception e) {
                String errMsg = "Error creating HumanTaskDatabaseCreator";
                log.error((Object)errMsg, (Throwable)e);
                throw new HumanTaskServerException(errMsg, e);
            }
            if (!humantaskDBCreator.isDatabaseStructureCreated("SELECT * FROM HT_JOB")) {
                try {
                    humantaskDBCreator.createRegistryDatabase();
                }
                catch (Exception e) {
                    String errMsg = "Error creating HumanTask database";
                    log.error((Object)errMsg, (Throwable)e);
                    throw new HumanTaskServerException(errMsg, e);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"HumanTask database already exists. Using the old database.");
            }
        }
    }

    public synchronized void shutdown() {
        if (!this.started) {
            return;
        }
        this.dataSource = null;
        this.started = false;
    }

    private void initDataSource() throws DatabaseConfigurationException {
        this.initExternalDb();
    }

    private void initExternalDb() throws DatabaseConfigurationException {
        try {
            this.dataSource = (DataSource)this.lookupInJndi(this.serverConfiguration.getDataSourceName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("HumanTask Server using external DataSource " + this.serverConfiguration.getDataSourceName()));
            }
        }
        catch (Exception e) {
            String errorMsg = "Failed to resolved external DataSource at " + this.serverConfiguration.getDataSourceName();
            log.error((Object)errorMsg, (Throwable)e);
            throw new DatabaseConfigurationException(errorMsg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T lookupInJndi(String objName) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Object object;
            block13: {
                InitialContext ctx = null;
                try {
                    if (this.serverConfiguration.getDataSourceJNDIRepoInitialContextFactory() != null && this.serverConfiguration.getDataSourceJNDIRepoProviderURL() != null) {
                        Properties jndiProps = new Properties();
                        jndiProps.setProperty("java.naming.factory.initial", this.serverConfiguration.getDataSourceJNDIRepoInitialContextFactory());
                        jndiProps.setProperty("java.naming.provider.url", this.serverConfiguration.getDataSourceJNDIRepoProviderURL());
                        ctx = new InitialContext(jndiProps);
                    } else {
                        ctx = new InitialContext();
                    }
                    object = ctx.lookup(objName);
                    if (ctx == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Exception ex1) {
                            log.error((Object)"Error closing JNDI connection.", (Throwable)ex1);
                        }
                    }
                    throw throwable;
                }
                try {
                    ctx.close();
                }
                catch (Exception ex1) {
                    log.error((Object)"Error closing JNDI connection.", (Throwable)ex1);
                }
            }
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void setTransactionManager(TransactionManager tnxManager) {
        this.tnxManager = tnxManager;
    }

    public HumanTaskDAOConnectionFactoryJDBC createDAOConnectionFactory() throws DatabaseConfigurationException {
        HumanTaskDAOConnectionFactoryJDBC humanTaskDAOConnectionFactoryJDBC;
        String connectionFactoryClassName = this.serverConfiguration.getDaoConnectionFactoryClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using DAO connection factory class: " + connectionFactoryClassName));
        }
        try {
            humanTaskDAOConnectionFactoryJDBC = (HumanTaskDAOConnectionFactoryJDBC)Class.forName(connectionFactoryClassName).newInstance();
        }
        catch (Exception ex) {
            String errMsg = "Human Task DAO Connection Factory instantiation failed!";
            log.error((Object)errMsg);
            throw new DatabaseConfigurationException(errMsg, ex);
        }
        humanTaskDAOConnectionFactoryJDBC.setDataSource(this.getDataSource());
        humanTaskDAOConnectionFactoryJDBC.setTransactionManager(this.getTnxManager());
        humanTaskDAOConnectionFactoryJDBC.setDAOConnectionFactoryProperties(this.getGenericDAOFactoryProperties());
        humanTaskDAOConnectionFactoryJDBC.init();
        return humanTaskDAOConnectionFactoryJDBC;
    }

    private Map<String, Object> getGenericDAOFactoryProperties() {
        HashMap<String, Object> daoFactoryProperties = new HashMap<String, Object>();
        daoFactoryProperties.put("org.wso2.carbon.humantask.DataSource", this.getDataSource());
        daoFactoryProperties.put("org.wso2.carbon.humantask.DDLGeneration", this.serverConfiguration.isGenerateDdl());
        daoFactoryProperties.put("org.wso2.carbon.humantask.SQLTracing", this.serverConfiguration.isShowSql());
        daoFactoryProperties.put("org.wso2.carbon.humantask.DAOFactory", this.serverConfiguration.getDaoConnectionFactoryClass());
        return daoFactoryProperties;
    }

    public TransactionManager getTnxManager() {
        return this.tnxManager;
    }
}

