/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.deployment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.wso2.carbon.humantask.HumanInteractionsDocument;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentException;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentUnitBuilder;
import org.wso2.carbon.humantask.core.deployment.config.HTDeploymentConfigDocument;
import org.wso2.carbon.humantask.core.utils.FileUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveBasedHumanTaskDeploymentUnitBuilder
extends HumanTaskDeploymentUnitBuilder {
    private static Log log = LogFactory.getLog(ArchiveBasedHumanTaskDeploymentUnitBuilder.class);
    private File humantaskDir;
    private String fileName;
    private List<Definition> wsdlDefinitions = new ArrayList<Definition>();
    private InputStream hiDefinition;
    private InputStream hiConfiguration;
    private File humanTaskDefinitionFile;
    private Map<String, InputStream> wsdlsMap = new HashMap<String, InputStream>();
    private Map<String, InputStream> schemasMap = new HashMap<String, InputStream>();
    private static final FileFilter wsdlFilter = new FileFilter(){

        public boolean accept(File path) {
            return path.getName().endsWith(".wsdl") && path.isFile();
        }
    };
    private static final FileFilter xsdFilter = new FileFilter(){

        public boolean accept(File path) {
            return path.getName().endsWith(".xsd") && path.isFile();
        }
    };
    private static final FileFilter humantaskFilter = new FileFilter(){

        public boolean accept(File path) {
            return path.getName().endsWith(".ht") && path.isFile();
        }
    };

    public ArchiveBasedHumanTaskDeploymentUnitBuilder(File hiArchiveZip, int tenantId) throws HumanTaskDeploymentException {
        String hiArchiveZipName = hiArchiveZip.getName();
        this.fileName = hiArchiveZipName.substring(0, hiArchiveZipName.lastIndexOf(46));
        this.humantaskDir = ArchiveBasedHumanTaskDeploymentUnitBuilder.extractBPELArchive(hiArchiveZip, tenantId);
        this.buildHumanInteractionDocuments();
        this.buildDeploymentConfiguration();
        this.buildWSDLs();
        this.buildSchemas();
    }

    @Override
    public void buildHumanInteractionDocuments() throws HumanTaskDeploymentException {
        if (this.hiDefinition == null) {
            List<File> hiDefinitionFiles = FileUtils.directoryEntriesInPath(this.humantaskDir, humantaskFilter);
            if (hiDefinitionFiles.size() != 1) {
                String errMsg = hiDefinitionFiles.size() == 0 ? "No human task definition files were found in " + this.fileName : hiDefinitionFiles.size() + " human task definition files were found in " + this.fileName;
                log.error((Object)errMsg);
                throw new HumanTaskDeploymentException(errMsg);
            }
            try {
                this.hiDefinition = new FileInputStream(hiDefinitionFiles.get(0));
                this.humanTaskDefinitionFile = hiDefinitionFiles.get(0);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage());
                throw new HumanTaskDeploymentException("Error building humantask archive; " + this.fileName, e);
            }
        }
    }

    @Override
    public void buildDeploymentConfiguration() throws HumanTaskDeploymentException {
        if (this.hiConfiguration == null) {
            File humantaskConfFile = new File(this.humantaskDir, "htconfig.xml");
            if (!humantaskConfFile.exists()) {
                String errMsg = "htconfig.xml file not found for the " + this.fileName;
                log.error((Object)errMsg);
                throw new HumanTaskDeploymentException(errMsg);
            }
            try {
                this.hiConfiguration = new FileInputStream(humantaskConfFile);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage());
                throw new HumanTaskDeploymentException("Error building humantask archive: " + this.fileName, e);
            }
        }
    }

    @Override
    public void buildWSDLs() throws HumanTaskDeploymentException {
        for (File file : FileUtils.directoryEntriesInPath(this.humantaskDir, wsdlFilter)) {
            FileInputStream is;
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage());
                throw new HumanTaskDeploymentException("Error building humantask archive: " + this.fileName, e);
            }
            this.wsdlsMap.put(file.getName(), is);
        }
    }

    @Override
    public void buildSchemas() throws HumanTaskDeploymentException {
        for (File file : FileUtils.directoryEntriesInPath(this.humantaskDir, xsdFilter)) {
            FileInputStream is;
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage());
                throw new HumanTaskDeploymentException("Error building humantask archive: " + this.fileName, e);
            }
            this.schemasMap.put(file.getName(), is);
        }
    }

    @Override
    public HumanInteractionsDocument getHumanInteractionsDocument() throws HumanTaskDeploymentException {
        HumanInteractionsDocument hiDoc;
        try {
            hiDoc = HumanInteractionsDocument.Factory.parse(this.hiDefinition);
        }
        catch (Exception e) {
            String errMsg = "Error occurred while parsing the human interaction definition";
            log.error((Object)errMsg, (Throwable)e);
            throw new HumanTaskDeploymentException(errMsg, e);
        }
        return hiDoc;
    }

    @Override
    public HTDeploymentConfigDocument getHTDeploymentConfigDocument() throws HumanTaskDeploymentException {
        HTDeploymentConfigDocument hiConf;
        try {
            hiConf = HTDeploymentConfigDocument.Factory.parse(this.hiConfiguration);
        }
        catch (Exception e) {
            String errMsg = "Error occurred while parsing the human interaction configuration file: htconfig.xml";
            log.error((Object)errMsg, (Throwable)e);
            throw new HumanTaskDeploymentException(errMsg, e);
        }
        return hiConf;
    }

    @Override
    public String getArchiveName() {
        return this.fileName;
    }

    @Override
    public List<Definition> getWsdlDefinitions() throws HumanTaskDeploymentException {
        if (this.wsdlDefinitions.size() == 0) {
            for (Map.Entry<String, InputStream> wsdl : this.wsdlsMap.entrySet()) {
                try {
                    this.wsdlDefinitions.add(ArchiveBasedHumanTaskDeploymentUnitBuilder.readInTheWSDLFile(wsdl.getValue(), "/humantask/deploymentunits/" + this.fileName + "/" + wsdl.getKey(), false));
                }
                catch (WSDLException e) {
                    String errMsg = "Error occurred while converting the wsdl input stream to wsdl definition";
                    throw new HumanTaskDeploymentException(errMsg, e);
                }
            }
        }
        return this.wsdlDefinitions;
    }

    public static Definition readInTheWSDLFile(InputStream in, String entryName, boolean fromRegistry) throws WSDLException {
        Document doc;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        try {
            doc = XMLUtils.newDocument((InputStream)in);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Parser Configuration Error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSDLException("PARSER_ERROR", "Parser SAX Error", (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLException("INVALID_WSDL", "IO Error", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading 1.1 WSDL with base uri = " + entryName));
            log.debug((Object)("  the document base uri = " + entryName));
        }
        if (fromRegistry) {
            throw new UnsupportedOperationException("This operation is not currently supported in this version of WSO2 BPS.");
        }
        Definition def = reader.readWSDL(entryName, doc.getDocumentElement());
        def.setDocumentBaseURI(entryName);
        return def;
    }

    @Override
    public File getHumanTaskDefinitionFile() {
        return this.humanTaskDefinitionFile;
    }

    public static File extractBPELArchive(File archiveFile, int tenantId) throws HumanTaskDeploymentException {
        try {
            ZipEntry entry;
            String humantaskExtractionLocation = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "humantasks" + File.separator + tenantId + File.separator + FilenameUtils.removeExtension((String)archiveFile.getName());
            ZipInputStream zipStream = new ZipInputStream(new FileInputStream(archiveFile));
            while ((entry = zipStream.getNextEntry()) != null) {
                File destFile;
                if (entry.isDirectory()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Extracting directory " + entry.getName()));
                    }
                    if (new File(humantaskExtractionLocation, entry.getName()).mkdirs() || new File(humantaskExtractionLocation, entry.getName()).exists()) continue;
                    throw new HumanTaskDeploymentException("Archive extraction failed. Cannot create directory: " + new File(humantaskExtractionLocation, entry.getName()).getAbsolutePath() + ".");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Extracting file " + entry.getName()));
                }
                if (!(destFile = new File(humantaskExtractionLocation, entry.getName())).getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
                    throw new HumanTaskDeploymentException("Archive extraction failed. Cannot create directory: " + destFile.getParentFile().getAbsolutePath());
                }
                ArchiveBasedHumanTaskDeploymentUnitBuilder.copyInputStream(zipStream, new BufferedOutputStream(new FileOutputStream(destFile)));
            }
            zipStream.close();
            return new File(humantaskExtractionLocation);
        }
        catch (IOException e) {
            String errMsg = "Error occurred during extracting the archive: " + archiveFile;
            log.error((Object)errMsg, (Throwable)e);
            throw new HumanTaskDeploymentException(errMsg, e);
        }
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.close();
    }
}

