/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.deployment;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.humantask.core.dao.TaskType;
import org.wso2.carbon.humantask.core.deployment.SimpleTaskDefinitionInfo;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.store.NotificationConfiguration;
import org.wso2.carbon.humantask.core.store.TaskConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeploymentUtil {
    private DeploymentUtil() {
    }

    public static List<SimpleTaskDefinitionInfo> getTaskConfigurationsInfoList(List<HumanTaskBaseConfiguration> taskBaseConfigs) {
        ArrayList<SimpleTaskDefinitionInfo> simpleTaskInfoList = new ArrayList<SimpleTaskDefinitionInfo>();
        for (HumanTaskBaseConfiguration taskConfig : taskBaseConfigs) {
            simpleTaskInfoList.add(DeploymentUtil.getSimpleTaskDefinitionInfo(taskConfig));
        }
        return simpleTaskInfoList;
    }

    public static SimpleTaskDefinitionInfo getSimpleTaskDefinitionInfo(HumanTaskBaseConfiguration baseConfiguration) {
        SimpleTaskDefinitionInfo taskInfo = new SimpleTaskDefinitionInfo();
        taskInfo.setPackageName(baseConfiguration.getPackageName());
        taskInfo.setTaskName(baseConfiguration.getName().toString());
        taskInfo.setHumanTaskDefinitionFile(baseConfiguration.getHumanTaskDefinitionFile());
        if (baseConfiguration instanceof NotificationConfiguration) {
            taskInfo.setTaskType(TaskType.NOTIFICATION);
        } else if (baseConfiguration instanceof TaskConfiguration) {
            taskInfo.setTaskType(TaskType.TASK);
        }
        taskInfo.setPackageStatus(baseConfiguration.getPackageStatus());
        taskInfo.setErroneous(baseConfiguration.isErroneous());
        taskInfo.setDeploymentError(baseConfiguration.getDeploymentError());
        return taskInfo;
    }
}

