/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.deployment;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.wso2.carbon.humantask.HumanInteractionsDocument;
import org.wso2.carbon.humantask.TDeadline;
import org.wso2.carbon.humantask.TDeadlines;
import org.wso2.carbon.humantask.TEscalation;
import org.wso2.carbon.humantask.TNotification;
import org.wso2.carbon.humantask.TTask;
import org.wso2.carbon.humantask.core.deployment.config.HTDeploymentConfigDocument;
import org.wso2.carbon.humantask.core.deployment.config.THTDeploymentConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumanTaskDeploymentUnit {
    private HumanInteractionsDocument humanInteraction;
    private HTDeploymentConfigDocument deploymentConfiguration;
    private List<Definition> wsdls;
    private String name;
    private String targetNamespace;
    private File humanTaskDefinitionFile;

    public void setHumanInteractionsDefinition(HumanInteractionsDocument hiDefinition) {
        this.humanInteraction = hiDefinition;
        this.targetNamespace = hiDefinition.getHumanInteractions().getTargetNamespace();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWSDLs(List<Definition> wsdls) {
        this.wsdls = wsdls;
    }

    public void setDeploymentConfiguration(HTDeploymentConfigDocument configDocument) {
        this.deploymentConfiguration = configDocument;
    }

    public String getName() {
        return this.name;
    }

    public HumanInteractionsDocument getHumanInteractionsDefinition() {
        return this.humanInteraction;
    }

    public List<Definition> getWSDLs() {
        return this.wsdls;
    }

    public String getNamespace() {
        return this.targetNamespace;
    }

    public HTDeploymentConfigDocument getDeploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public TTask[] getTasks() {
        if (this.humanInteraction.getHumanInteractions().isSetTasks() && this.humanInteraction.getHumanInteractions().getTasks().sizeOfTaskArray() > 0) {
            return this.humanInteraction.getHumanInteractions().getTasks().getTaskArray();
        }
        return null;
    }

    public THTDeploymentConfig.Task getTaskServiceInfo(QName taskName) {
        for (THTDeploymentConfig.Task task : this.deploymentConfiguration.getHTDeploymentConfig().getTaskArray()) {
            if (!task.getName().equals(taskName)) continue;
            return task;
        }
        return null;
    }

    public THTDeploymentConfig.Notification getNotificationServiceInfo(QName notificationName) {
        for (THTDeploymentConfig.Notification notification : this.deploymentConfiguration.getHTDeploymentConfig().getNotificationArray()) {
            if (!notification.getName().equals(notificationName)) continue;
            return notification;
        }
        return null;
    }

    public TNotification[] getNotifications() {
        if (this.humanInteraction.getHumanInteractions().isSetNotifications() && this.humanInteraction.getHumanInteractions().getNotifications().sizeOfNotificationArray() > 0) {
            return this.humanInteraction.getHumanInteractions().getNotifications().getNotificationArray();
        }
        return null;
    }

    public File getHumanTaskDefinitionFile() {
        return this.humanTaskDefinitionFile;
    }

    public void setHumanTaskDefinitionFile(File humanTaskDefinitionFile) {
        this.humanTaskDefinitionFile = humanTaskDefinitionFile;
    }

    public List<TNotification> getInlineNotifications() {
        ArrayList<TNotification> notifications = new ArrayList<TNotification>();
        TTask[] tasks = this.getTasks();
        if (tasks == null) {
            return notifications;
        }
        for (TTask task : tasks) {
            if (!task.isSetDeadlines()) continue;
            TDeadlines deadlines = task.getDeadlines();
            TDeadline[] deadlineArray = deadlines.getStartDeadlineArray();
            if (deadlineArray != null) {
                for (TDeadline deadline : deadlineArray) {
                    for (TEscalation escalation : deadline.getEscalationArray()) {
                        if (!escalation.isSetNotification()) continue;
                        notifications.add(escalation.getNotification());
                    }
                }
            }
            if ((deadlineArray = deadlines.getCompletionDeadlineArray()) == null) continue;
            for (TDeadline deadline : deadlineArray) {
                for (TEscalation escalation : deadline.getEscalationArray()) {
                    if (!escalation.isSetNotification()) continue;
                    notifications.add(escalation.getNotification());
                }
            }
        }
        return notifications;
    }
}

