/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.deployment;

import java.io.File;
import java.util.List;
import javax.wsdl.Definition;
import org.wso2.carbon.humantask.HumanInteractionsDocument;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentException;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentUnit;
import org.wso2.carbon.humantask.core.deployment.config.HTDeploymentConfigDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HumanTaskDeploymentUnitBuilder {
    private HumanTaskDeploymentUnit htDeploymentUnit;

    public HumanTaskDeploymentUnit createNewHumanTaskDeploymentUnit() throws HumanTaskDeploymentException {
        if (this.isValidHumanTaskDeploymentUnit()) {
            throw new IllegalStateException("Please build the Human Task Deployment unit completely.");
        }
        this.htDeploymentUnit = new HumanTaskDeploymentUnit();
        this.htDeploymentUnit.setHumanInteractionsDefinition(this.getHumanInteractionsDocument());
        this.htDeploymentUnit.setDeploymentConfiguration(this.getHTDeploymentConfigDocument());
        this.htDeploymentUnit.setWSDLs(this.getWsdlDefinitions());
        this.htDeploymentUnit.setName(this.getArchiveName());
        this.htDeploymentUnit.setHumanTaskDefinitionFile(this.getHumanTaskDefinitionFile());
        return this.htDeploymentUnit;
    }

    private boolean isValidHumanTaskDeploymentUnit() {
        return this.htDeploymentUnit != null && this.htDeploymentUnit.getHumanInteractionsDefinition() != null && this.htDeploymentUnit.getWSDLs() != null && this.htDeploymentUnit.getName() != null && this.htDeploymentUnit.getDeploymentConfiguration() != null;
    }

    public abstract void buildHumanInteractionDocuments() throws HumanTaskDeploymentException;

    public abstract void buildDeploymentConfiguration() throws HumanTaskDeploymentException;

    public abstract void buildWSDLs() throws HumanTaskDeploymentException;

    public abstract void buildSchemas() throws HumanTaskDeploymentException;

    public abstract HumanInteractionsDocument getHumanInteractionsDocument() throws HumanTaskDeploymentException;

    public abstract HTDeploymentConfigDocument getHTDeploymentConfigDocument() throws HumanTaskDeploymentException;

    public abstract String getArchiveName();

    public abstract File getHumanTaskDefinitionFile();

    public abstract List<Definition> getWsdlDefinitions() throws HumanTaskDeploymentException;
}

