/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.wso2.carbon.bpel.common.WSDLAwareMessage;
import org.wso2.carbon.humantask.core.api.scheduler.Scheduler;
import org.wso2.carbon.humantask.core.dao.HumanTaskDAOConnectionFactory;
import org.wso2.carbon.humantask.core.dao.TaskCreationContext;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.engine.HumanTaskException;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.engine.event.processor.EventProcessor;
import org.wso2.carbon.humantask.core.engine.runtime.api.ExpressionLanguageRuntime;
import org.wso2.carbon.humantask.core.engine.runtime.xpath.XPathExpressionRuntime;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.store.HumanTaskBaseConfiguration;
import org.wso2.carbon.humantask.core.store.HumanTaskStore;

public class HumanTaskEngine {
    private HumanTaskDAOConnectionFactory daoConnectionFactory;
    private PeopleQueryEvaluator peopleQueryEvaluator;
    private Map<String, ExpressionLanguageRuntime> expressionLanguageRuntimeRegistry;
    private EventProcessor eventProcessor;
    private Scheduler scheduler;

    public HumanTaskEngine() {
        this.initExpressionLanguageRuntimes();
    }

    private void initExpressionLanguageRuntimes() {
        this.expressionLanguageRuntimeRegistry = new HashMap<String, ExpressionLanguageRuntime>();
        this.expressionLanguageRuntimeRegistry.put("urn:wsht:sublang:xpath2.0", new XPathExpressionRuntime());
    }

    private TaskDAO createTask(WSDLAwareMessage message, HumanTaskBaseConfiguration taskConfiguration, int tenantId) throws HumanTaskException {
        TaskCreationContext creationContext = new TaskCreationContext();
        creationContext.setTaskConfiguration(taskConfiguration);
        creationContext.setTenantId(tenantId);
        creationContext.setMessageBodyParts(message.getBodyPartElements());
        creationContext.setMessageHeaderParts(message.getHeaderPartElements());
        creationContext.setPeopleQueryEvaluator(this.peopleQueryEvaluator);
        return this.getDaoConnectionFactory().getConnection().createTask(creationContext);
    }

    public String invoke(final WSDLAwareMessage message) throws Exception {
        TaskDAO task = this.scheduler.execTransaction(new Callable<TaskDAO>(){

            @Override
            public TaskDAO call() throws Exception {
                HumanTaskStore taskStore = HumanTaskServiceComponent.getHumanTaskServer().getTaskStoreManager().getHumanTaskStore(message.getTenantId());
                return HumanTaskEngine.this.createTask(message, taskStore.getTaskConfiguration(message.getPortTypeName(), message.getOperationName()), message.getTenantId());
            }
        });
        return task.getId().toString();
    }

    public HumanTaskDAOConnectionFactory getDaoConnectionFactory() {
        return this.daoConnectionFactory;
    }

    public void setDaoConnectionFactory(HumanTaskDAOConnectionFactory daoConnectionFactory) {
        this.daoConnectionFactory = daoConnectionFactory;
    }

    public void setPeopleQueryEvaluator(PeopleQueryEvaluator pqe) {
        this.peopleQueryEvaluator = pqe;
    }

    public PeopleQueryEvaluator getPeopleQueryEvaluator() {
        return this.peopleQueryEvaluator;
    }

    public ExpressionLanguageRuntime getExpressionLanguageRuntime(String language) {
        ExpressionLanguageRuntime epxLanguageRuntime = null;
        if (this.expressionLanguageRuntimeRegistry != null) {
            epxLanguageRuntime = this.expressionLanguageRuntimeRegistry.get(language);
        }
        return epxLanguageRuntime;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setEventProcessor(EventProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    public EventProcessor getEventProcessor() {
        return this.eventProcessor;
    }
}

