/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.api.event.TaskEventInfo;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskEventType;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.dao.TaskType;
import org.wso2.carbon.humantask.core.engine.HumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.HumanTaskEngine;
import org.wso2.carbon.humantask.core.engine.commands.Claim;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalAccessException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalArgumentException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalOperationException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalStateException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.engine.util.CommonTaskUtil;
import org.wso2.carbon.humantask.core.engine.util.OperationAuthorizationUtil;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHumanTaskCommand
implements HumanTaskCommand {
    private static final Log log = LogFactory.getLog(Claim.class);
    private HumanTaskEngine engine = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine();
    private TaskDAO task;
    private OrganizationalEntityDAO operationInvoker;
    private EventDAO event;

    protected HumanTaskEngine getEngine() {
        return this.engine;
    }

    protected TaskDAO getTask() {
        return this.task;
    }

    protected OrganizationalEntityDAO getOperationInvoker() {
        return this.operationInvoker;
    }

    protected EventDAO getEvent() {
        return this.event;
    }

    public AbstractHumanTaskCommand(String invokerUserName, Long taskId) {
        this.validateCaller(invokerUserName);
        this.operationInvoker = this.engine.getDaoConnectionFactory().getConnection().createNewOrgEntityObject(invokerUserName, OrganizationalEntityDAO.OrganizationalEntityType.USER);
        this.task = this.engine.getDaoConnectionFactory().getConnection().getTask(taskId);
        this.event = this.engine.getDaoConnectionFactory().getConnection().createNewEventObject(this.task);
    }

    private void validateCaller(String callerId) {
        if (StringUtils.isEmpty((String)callerId) || !this.engine.getPeopleQueryEvaluator().isExistingUser(callerId)) {
            String errMsg = String.format("The caller[name:%s] is not a valid user in the user store.", this.operationInvoker.getName());
            log.error((Object)errMsg);
            throw new HumanTaskIllegalArgumentException(errMsg);
        }
    }

    public void checkForValidTask() {
        if (this.task == null) {
            throw new HumanTaskRuntimeException("The task is not loaded properly");
        }
        if (!TaskType.TASK.equals((Object)this.task.getType())) {
            String errMsg = String.format("The task[%d] is a notification, hence cannot perform [%s].", this.task.getId(), this.getClass().getSimpleName());
            log.error((Object)errMsg);
            throw new HumanTaskIllegalArgumentException(errMsg);
        }
    }

    public void checkForValidNotification() {
        if (this.task == null) {
            throw new HumanTaskRuntimeException("The task is not loaded properly");
        }
        if (!TaskType.NOTIFICATION.equals((Object)this.task.getType())) {
            String errMsg = String.format("The task[%d] is a task, hence cannot perform [%s].", this.task.getId(), this.getClass().getSimpleName());
            log.error((Object)errMsg);
            throw new HumanTaskIllegalOperationException(errMsg);
        }
    }

    protected void checkPostState(TaskStatus expectedStatus) {
        if (!expectedStatus.equals((Object)this.task.getStatus())) {
            String errMsg = String.format("Operation [%s] was not successfully performed on task[id: %d] as it's state is still in[%s]", new Object[]{this.getClass().getSimpleName(), this.task.getId(), this.task.getStatus()});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected void checkPreState(TaskStatus expectedStatus) {
        if (!expectedStatus.equals((Object)this.task.getStatus())) {
            String errMsg = String.format("User[%s] cannot [%s] task[id:%d] as the task is in state[%s]. [%s] operation can be performed on tasks in state[%s]!", new Object[]{this.operationInvoker.getName(), this.getClass().getSimpleName(), this.task.getId(), this.task.getStatus(), this.getClass().getSimpleName(), expectedStatus});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected void checkPreStates(List<TaskStatus> expectedStates) {
        if (!expectedStates.contains((Object)this.task.getStatus())) {
            String errMsg = String.format("User[%s] cannot [%s] task[id:%d] as the task is in state[%s]. [%s] operation can be performed on tasks in states[%s]!", new Object[]{this.operationInvoker.getName(), this.getClass().getSimpleName(), this.task.getId(), this.task.getStatus(), this.getClass().getSimpleName(), expectedStates});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected void authoriseRoles(List<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles) {
        if (!OperationAuthorizationUtil.authoriseUser(this.task, this.operationInvoker, allowedRoles, this.engine.getPeopleQueryEvaluator())) {
            throw new HumanTaskIllegalAccessException(String.format("The user[%s] cannot perform [%s] operation as he is not in task roles[%s]", this.operationInvoker.getName(), this.getClass().getSimpleName(), allowedRoles));
        }
    }

    protected void reloadTask() {
        this.task = this.engine.getDaoConnectionFactory().getConnection().getTask(this.task.getId());
    }

    protected abstract void checkPreConditions();

    protected abstract void authorise();

    protected abstract void checkState();

    protected abstract void checkPostConditions();

    protected EventDAO createTaskEvent() {
        this.event.setTask(this.task);
        this.event.setType(TaskEventType.valueOf(this.getClass().getSimpleName().toUpperCase()));
        this.event.setUser(this.operationInvoker.getName());
        this.event.setNewState(this.task.getStatus());
        return this.event;
    }

    protected EventDAO getTaskEvent() {
        return this.event;
    }

    protected void processTaskEvent() {
        EventDAO eventDAO = this.createTaskEvent();
        this.getTask().persistEvent(eventDAO);
        TaskEventInfo taskEventInfo = CommonTaskUtil.populateTaskEventInfo(eventDAO, this.task);
        this.getEngine().getEventProcessor().processEvent(taskEventInfo);
    }
}

