/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import java.util.Date;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalStateException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.engine.util.CommonTaskUtil;

public class Activate
extends AbstractHumanTaskCommand {
    public Activate(String callerId, Long taskId) {
        super(callerId, taskId);
    }

    protected void checkPreConditions() {
        this.checkForValidTask();
        TaskDAO task = this.getTask();
        if (task.getActivationTime() == null) {
            throw new HumanTaskRuntimeException(String.format("The task[id:%d] does not have a defined activation time.", task.getId()));
        }
        if (task.getActivationTime().before(new Date())) {
            throw new HumanTaskRuntimeException(String.format("The task[id:%d] activation time has already expired.", task.getId()));
        }
        if (CommonTaskUtil.getOrgEntitiesForRole(task, GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS).size() < 1) {
            throw new HumanTaskIllegalStateException(String.format("The are no matching users for the task's[id:%d] potential owners", task.getId()));
        }
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.TASK_INITIATOR);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
        this.checkPreState(TaskStatus.CREATED);
    }

    protected void checkPostConditions() {
        this.checkPostState(TaskStatus.READY);
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        this.checkPreConditions();
        this.checkState();
        this.getTask().activate();
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

