/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.wso2.carbon.humantask.core.dao.CommentDAO;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;

public class AddComment
extends AbstractHumanTaskCommand {
    private String commentString;
    private CommentDAO persistedComment;

    public AddComment(String callerId, Long taskId, String commentString) {
        super(callerId, taskId);
        this.commentString = commentString;
    }

    protected void checkPreConditions() {
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
    }

    protected void checkPostConditions() {
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        this.checkPreConditions();
        this.checkState();
        this.persistedComment = this.getTask().persistComment(this.getEngine().getDaoConnectionFactory().getConnection().getCommentDAO(this.commentString, this.getOperationInvoker().getName()));
        this.processTaskEvent();
        this.checkPostConditions();
    }

    public CommentDAO getPersistedComment() {
        return this.persistedComment;
    }
}

