/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalOperationException;

public class Claim
extends AbstractHumanTaskCommand {
    private static final Log log = LogFactory.getLog(Claim.class);

    public Claim(String callerId, Long taskId) {
        super(callerId, taskId);
    }

    protected void checkPreConditions() {
        this.checkForValidTask();
        TaskDAO task = this.getTask();
        for (GenericHumanRoleDAO humanRole : task.getHumanRoles()) {
            if (!GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER.equals((Object)humanRole.getType()) || humanRole.getOrgEntities().size() <= 0) continue;
            throw new HumanTaskIllegalOperationException(String.format("The task[%d] already has an actual owner[%s]", task.getId(), humanRole.getOrgEntities()));
        }
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
        this.checkPreState(TaskStatus.READY);
    }

    protected void checkPostConditions() {
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        OrganizationalEntityDAO caller = this.getOperationInvoker();
        TaskDAO task = this.getTask();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("User[%s] claiming task[%d]", caller.getName(), task.getId()));
        }
        this.authorise();
        this.checkPreConditions();
        this.checkState();
        task.claim(caller);
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

