/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis2.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.MessageDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalArgumentException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;
import org.wso2.carbon.humantask.core.store.TaskConfiguration;
import org.wso2.carbon.humantask.core.utils.DOMUtils;

public class Complete
extends AbstractHumanTaskCommand {
    private Element taskOutput;

    public Complete(String callerId, Long taskId, Element output) {
        super(callerId, taskId);
        if (output == null) {
            throw new HumanTaskIllegalArgumentException("The task output cannot be null.");
        }
        this.taskOutput = output;
    }

    protected void checkPreConditions() {
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
        this.checkPreState(TaskStatus.IN_PROGRESS);
    }

    protected void checkPostConditions() {
        this.checkPostState(TaskStatus.COMPLETED);
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.complete(this.createMessage());
        TaskConfiguration taskConf = (TaskConfiguration)HumanTaskServiceComponent.getHumanTaskServer().getTaskStoreManager().getHumanTaskStore(task.getTenantId()).getTaskConfiguration(QName.valueOf(task.getName()));
        try {
            taskConf.getCallBackService().invoke(XMLUtils.toOM((Element)this.taskOutput), task.getId());
        }
        catch (Exception e) {
            throw new HumanTaskRuntimeException("Error occurred while invoking callback service", e);
        }
        this.processTaskEvent();
        this.checkPostConditions();
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    private MessageDAO createMessage() {
        MessageDAO output = this.getEngine().getDaoConnectionFactory().getConnection().createMessage();
        output.setMessageType(MessageDAO.MessageType.OUTPUT);
        output.setTask(this.getTask());
        Document doc = DOMUtils.newDocument();
        Element message = doc.createElement("message");
        doc.appendChild(message);
        Node importedNode = doc.importNode(this.taskOutput, true);
        message.appendChild(importedNode);
        output.setHeader(message);
        output.setData(message);
        return output;
    }
}

