/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalAccessException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalArgumentException;

public class Delegate
extends AbstractHumanTaskCommand {
    private static final Log log = LogFactory.getLog(Delegate.class);
    private OrganizationalEntityDAO delegatee;

    public Delegate(String callerId, Long taskId, OrganizationalEntityDAO delegatee) {
        super(callerId, taskId);
        this.delegatee = delegatee;
    }

    protected void checkPreConditions() {
        this.checkForValidTask();
        OrganizationalEntityDAO caller = this.getOperationInvoker();
        TaskDAO task = this.getTask();
        if (!this.getEngine().getPeopleQueryEvaluator().isExistingUser(this.delegatee.getName())) {
            String errMsg = String.format("The user[%s] cannot delegate task[id:%d] to the given delegatee[name:%s] as he/she does not exist in the user store", caller.getName(), task.getId(), this.delegatee.getName());
            log.error((Object)errMsg);
            throw new HumanTaskIllegalArgumentException(errMsg);
        }
        if (TaskStatus.RESERVED.equals((Object)task.getStatus()) || TaskStatus.IN_PROGRESS.equals((Object)task.getStatus())) {
            ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
            try {
                this.authoriseRoles(allowedRoles);
            }
            catch (Exception ex) {
                String err = String.format("The task[id:%d] can be only delegated after it's released. But for the task to be released you need to be a business administrator or the actual owner of the task. Given user[%s] is not in those roles!", task.getId(), caller.getName());
                log.error((Object)err);
                throw new HumanTaskIllegalAccessException(err, ex);
            }
            task.release();
        }
        GenericHumanRoleDAO potentialOwnersRole = task.getGenericHumanRole(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        if (this.getEngine().getPeopleQueryEvaluator().isOrgEntityInRole(this.delegatee, potentialOwnersRole)) {
            task.persistToPotentialOwners(this.delegatee);
        }
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
        ArrayList<TaskStatus> allowedStates = new ArrayList<TaskStatus>();
        allowedStates.add(TaskStatus.READY);
        allowedStates.add(TaskStatus.RESERVED);
        allowedStates.add(TaskStatus.IN_PROGRESS);
        this.checkPreStates(allowedStates);
    }

    protected void checkPostConditions() {
        this.checkPostState(TaskStatus.RESERVED);
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.delegate(this.delegatee);
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

