/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.commands.Claim;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalStateException;

public class Exit
extends AbstractHumanTaskCommand {
    private static final Log log = LogFactory.getLog(Claim.class);

    public Exit(String callerId, Long taskId) {
        super(callerId, taskId);
    }

    protected void checkPreConditions() {
    }

    protected void authorise() {
    }

    protected void checkState() {
        TaskDAO task = this.getTask();
        boolean isInFinalState = false;
        if (TaskStatus.EXITED.equals((Object)task.getStatus()) || TaskStatus.ERROR.equals((Object)task.getStatus()) || TaskStatus.FAILED.equals((Object)task.getStatus()) || TaskStatus.OBSOLETE.equals((Object)task.getStatus()) || TaskStatus.COMPLETED.equals((Object)task.getStatus())) {
            isInFinalState = true;
        }
        if (isInFinalState) {
            String errMsg = String.format("User[%s] cannot perform [%s] operation on task[%d] as the task is in state[%s]. [%s] operation can be performed only on tasks not in states[%s,%s,%s,%s,%s]", new Object[]{this.getOperationInvoker().getName(), Exit.class, task.getId(), task.getStatus(), Exit.class, TaskStatus.EXITED, TaskStatus.ERROR, TaskStatus.FAILED, TaskStatus.OBSOLETE, TaskStatus.COMPLETED});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected void checkPostConditions() {
        TaskDAO task = this.getTask();
        if (!TaskStatus.EXITED.equals((Object)task.getStatus())) {
            String errMsg = String.format("The task[id:%d] did not exit successfully as it's state is still in [%s]", new Object[]{task.getId(), task.getStatus()});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.exit();
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

