/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.util.CommonTaskUtil;

public class GetInput
extends AbstractHumanTaskCommand {
    private Element inputElement;
    private String partName;

    public GetInput(String callerId, Long taskId, String partName) {
        super(callerId, taskId);
        this.partName = partName;
    }

    protected void checkPreConditions() {
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.TASK_INITIATOR);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.NOTIFICATION_RECIPIENTS);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
    }

    protected void checkPostConditions() {
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        this.inputElement = StringUtils.isNotEmpty((String)this.partName) ? CommonTaskUtil.getMessagePart(task.getInputMessage(), this.partName) : (Element)task.getInputMessage().getBodyData().getFirstChild().getFirstChild();
        this.checkPostConditions();
    }

    public Element getInputElement() {
        return this.inputElement;
    }
}

