/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.MessageDAO;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.util.CommonTaskUtil;

public class GetOutput
extends AbstractHumanTaskCommand {
    private String partName;
    private Element outputData;

    public GetOutput(String callerId, Long taskId, String partName) {
        super(callerId, taskId);
        this.partName = partName;
    }

    protected void checkPreConditions() {
        this.checkForValidTask();
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.TASK_INITIATOR);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
    }

    protected void checkPostConditions() {
    }

    public void execute() {
        this.authorise();
        this.checkPreConditions();
        this.checkState();
        MessageDAO outputMessage = this.getTask().getOutputMessage();
        this.outputData = StringUtils.isNotEmpty((String)this.partName) ? CommonTaskUtil.getMessagePart(outputMessage, this.partName) : outputMessage.getBodyData();
        this.checkPostConditions();
    }

    public Element getOutputData() {
        return this.outputData;
    }
}

