/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.PeopleQueryEvaluator;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalStateException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nominate
extends AbstractHumanTaskCommand {
    private static Log log = LogFactory.getLog(Nominate.class);
    private List<OrganizationalEntityDAO> nominees = new ArrayList<OrganizationalEntityDAO>();

    public Nominate(String callerId, Long taskId, List<OrganizationalEntityDAO> nominees) {
        super(callerId, taskId);
        if (nominees == null || nominees.size() < 1) {
            throw new HumanTaskRuntimeException("At least 1 nominee should be provided.");
        }
        this.nominees = nominees;
    }

    @Override
    protected void checkPreConditions() {
        PeopleQueryEvaluator pqe = this.getEngine().getPeopleQueryEvaluator();
        pqe.checkOrgEntitiesExist(this.nominees);
    }

    @Override
    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        this.authoriseRoles(allowedRoles);
    }

    @Override
    protected void checkState() {
        this.checkPreState(TaskStatus.CREATED);
    }

    @Override
    protected void checkPostConditions() {
        TaskDAO task = this.getTask();
        if (!TaskStatus.RESERVED.equals((Object)task.getStatus()) && !TaskStatus.READY.equals((Object)task.getStatus())) {
            String errMsg = String.format("The task nomination failed. Task status is not in Reserved or Ready.", new Object[0]);
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    @Override
    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    @Override
    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.nominate(this.nominees);
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

