/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalAccessException;
import org.wso2.carbon.humantask.core.engine.util.OperationAuthorizationUtil;

public class Release
extends AbstractHumanTaskCommand {
    public Release(String callerId, Long taskId) {
        super(callerId, taskId);
    }

    protected void checkPreConditions() {
        TaskDAO task = this.getTask();
        OrganizationalEntityDAO caller = this.getOperationInvoker();
        this.checkForValidTask();
        if (TaskStatus.IN_PROGRESS.equals((Object)task.getStatus())) {
            ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
            if (!OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, this.getEngine().getPeopleQueryEvaluator())) {
                throw new HumanTaskIllegalAccessException(String.format("The user[%s] cannot perform [%s] operation as he is not in task roles[%s]", caller.getName(), Release.class, allowedRoles));
            }
            task.stop();
            this.reloadTask();
        }
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
        this.checkPreState(TaskStatus.RESERVED);
    }

    protected void checkPostConditions() {
        this.checkPostState(TaskStatus.READY);
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.release();
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

