/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.commands.Start;
import org.wso2.carbon.humantask.core.engine.commands.Suspend;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalStateException;

public class Resume
extends AbstractHumanTaskCommand {
    private static final Log log = LogFactory.getLog(Start.class);

    public Resume(String callerId, Long taskId) {
        super(callerId, taskId);
    }

    protected void checkPreConditions() {
        this.checkForValidTask();
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
        TaskDAO task = this.getTask();
        OrganizationalEntityDAO caller = this.getOperationInvoker();
        if (!TaskStatus.SUSPENDED.equals((Object)task.getStatus())) {
            String errMsg = String.format("User[%s] cannot [%s] task[%d] as the task is in state[%s]. Only tasks in [%s] state can be resumed!", new Object[]{caller.getName(), Resume.class, task.getId(), task.getStatus(), TaskStatus.SUSPENDED});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
        boolean isInResumableState = false;
        if (TaskStatus.IN_PROGRESS.equals((Object)task.getStatusBeforeSuspension()) || TaskStatus.READY.equals((Object)task.getStatusBeforeSuspension()) || TaskStatus.RESERVED.equals((Object)task.getStatusBeforeSuspension())) {
            isInResumableState = true;
        }
        if (!isInResumableState) {
            String errMsg = String.format("User[%s] cannot perform [%s] operation on task[%d] as the task is in state[%s]. [%s] operation can be performed only on tasks in states[%s,%s,%s]", new Object[]{caller.getName(), Suspend.class, task.getId(), task.getStatus(), Suspend.class, TaskStatus.RESERVED, TaskStatus.READY, TaskStatus.IN_PROGRESS});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected void checkPostConditions() {
        TaskDAO task = this.getTask();
        boolean isInSuspendableState = false;
        if (TaskStatus.IN_PROGRESS.equals((Object)task.getStatus()) || TaskStatus.READY.equals((Object)task.getStatus()) || TaskStatus.RESERVED.equals((Object)task.getStatus())) {
            isInSuspendableState = true;
        }
        if (!isInSuspendableState) {
            String errMsg = String.format("The task[id:%d] did not resume successfully as it's state is still in [%s]", new Object[]{task.getId(), task.getStatus()});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.resume();
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

