/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;

public class SetOutput
extends AbstractHumanTaskCommand {
    private Element outputData;
    private String outputName;

    public SetOutput(String callerId, Long taskId, String outputName, Element outputData) {
        super(callerId, taskId);
        this.outputData = outputData;
        this.outputName = outputName;
    }

    protected void checkPreConditions() {
        this.checkForValidTask();
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
        this.checkPreState(TaskStatus.IN_PROGRESS);
    }

    protected void checkPostConditions() {
        this.checkPostState(TaskStatus.IN_PROGRESS);
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.persistOutput(this.outputName, this.outputData);
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

