/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;

public class SetPriority
extends AbstractHumanTaskCommand {
    private int newPriority;

    public SetPriority(String callerId, Long taskId, Integer newPriority) {
        super(callerId, taskId);
        this.newPriority = newPriority;
    }

    protected void checkPreConditions() {
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
    }

    protected void checkPostConditions() {
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("Priority changed to :" + this.newPriority);
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.persistPriority(this.newPriority);
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

