/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.OrganizationalEntityDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.commands.Claim;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalAccessException;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalStateException;
import org.wso2.carbon.humantask.core.engine.util.OperationAuthorizationUtil;

public class Start
extends AbstractHumanTaskCommand {
    private static final Log log = LogFactory.getLog(Start.class);

    public Start(String callerId, Long taskId) {
        super(callerId, taskId);
    }

    protected void checkPreConditions() {
        TaskDAO task = this.getTask();
        OrganizationalEntityDAO caller = this.getOperationInvoker();
        this.checkForValidTask();
        if (TaskStatus.READY.equals((Object)task.getStatus())) {
            ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
            allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
            if (!OperationAuthorizationUtil.authoriseUser(task, caller, allowedRoles, this.getEngine().getPeopleQueryEvaluator())) {
                throw new HumanTaskIllegalAccessException(String.format("The user[%s] cannot perform [%s] operation as he is not in task roles[%s]", caller.getName(), Claim.class, allowedRoles));
            }
            task.claim(caller);
            this.reloadTask();
        }
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
        TaskDAO task = this.getTask();
        if (!TaskStatus.RESERVED.equals((Object)task.getStatus())) {
            String errMsg = String.format("User[%s] cannot perform [%s] operation on task[%d] as the task is in state[%s]. [%s] operation can be performed only on tasks in [%s] state", new Object[]{this.getOperationInvoker().getName(), Start.class, task.getId(), task.getStatus(), Start.class, TaskStatus.RESERVED});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected void checkPostConditions() {
        TaskDAO task = this.getTask();
        if (!TaskStatus.IN_PROGRESS.equals((Object)task.getStatus())) {
            String errMsg = String.format("The task[id:%d] did not start successfully as it's state is still in [%s]", new Object[]{task.getId(), task.getStatus()});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.checkPreConditions();
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkState();
        task.start();
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

