/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalStateException;

public class Stop
extends AbstractHumanTaskCommand {
    private static final Log log = LogFactory.getLog(Stop.class);

    public Stop(String callerId, Long taskId) {
        super(callerId, taskId);
    }

    protected void checkPreConditions() {
        this.checkForValidTask();
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
        TaskDAO task = this.getTask();
        this.checkPreState(TaskStatus.IN_PROGRESS);
        if (!TaskStatus.IN_PROGRESS.equals((Object)task.getStatus())) {
            String errMsg = String.format("User[%s] cannot claim task[%d] as the task is in state[%s]. Only tasks in [%s] can be claimed!", new Object[]{this.getOperationInvoker().getName(), task.getId(), task.getStatus(), TaskStatus.IN_PROGRESS});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected void checkPostConditions() {
        this.checkPostState(TaskStatus.RESERVED);
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.stop();
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

