/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.dao.TaskStatus;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;
import org.wso2.carbon.humantask.core.engine.commands.Start;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskIllegalStateException;

public class Suspend
extends AbstractHumanTaskCommand {
    private static final Log log = LogFactory.getLog(Start.class);

    public Suspend(String callerId, Long taskId) {
        super(callerId, taskId);
    }

    protected void checkPreConditions() {
        this.checkForValidTask();
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
        TaskDAO task = this.getTask();
        boolean isInSuspendableState = false;
        if (TaskStatus.IN_PROGRESS.equals((Object)task.getStatus()) || TaskStatus.READY.equals((Object)task.getStatus()) || TaskStatus.RESERVED.equals((Object)task.getStatus())) {
            isInSuspendableState = true;
        }
        if (!isInSuspendableState) {
            String errMsg = String.format("User[%s] cannot perform [%s] operation on task[%d] as the task is in state[%s]. [%s] operation can be performed only on tasks in states[%s,%s,%s]", new Object[]{this.getOperationInvoker().getName(), Suspend.class, task.getId(), task.getStatus(), Suspend.class, TaskStatus.RESERVED, TaskStatus.READY, TaskStatus.IN_PROGRESS});
            log.error((Object)errMsg);
            throw new HumanTaskIllegalStateException(errMsg);
        }
    }

    protected void checkPostConditions() {
        this.checkPostState(TaskStatus.SUSPENDED);
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.suspend();
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

