/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.commands;

import java.util.ArrayList;
import org.wso2.carbon.humantask.core.dao.EventDAO;
import org.wso2.carbon.humantask.core.dao.GenericHumanRoleDAO;
import org.wso2.carbon.humantask.core.dao.TaskDAO;
import org.wso2.carbon.humantask.core.engine.commands.AbstractHumanTaskCommand;

public class UpdateComment
extends AbstractHumanTaskCommand {
    private String updatedCommentString;
    private Long updatingCommentId;

    public UpdateComment(String callerId, Long taskId, Long commentId, String commentString) {
        super(callerId, taskId);
        this.updatedCommentString = commentString;
        this.updatingCommentId = commentId;
    }

    protected void checkPreConditions() {
    }

    protected void authorise() {
        ArrayList<GenericHumanRoleDAO.GenericHumanRoleType> allowedRoles = new ArrayList<GenericHumanRoleDAO.GenericHumanRoleType>();
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.ACTUAL_OWNER);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.POTENTIAL_OWNERS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.BUSINESS_ADMINISTRATORS);
        allowedRoles.add(GenericHumanRoleDAO.GenericHumanRoleType.STAKEHOLDERS);
        this.authoriseRoles(allowedRoles);
    }

    protected void checkState() {
    }

    protected void checkPostConditions() {
    }

    protected EventDAO createTaskEvent() {
        EventDAO taskEvent = super.createTaskEvent();
        taskEvent.setDetails("");
        return taskEvent;
    }

    public void execute() {
        this.authorise();
        TaskDAO task = this.getTask();
        this.checkPreConditions();
        this.checkState();
        task.updateAndPersistComment(this.updatingCommentId, this.updatedCommentString, this.getOperationInvoker().getName());
        this.processTaskEvent();
        this.checkPostConditions();
    }
}

