/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.runtime.xpath;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.util.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.humantask.core.dao.MessageDAO;
import org.wso2.carbon.humantask.core.engine.runtime.api.EvaluationContext;
import org.wso2.carbon.humantask.core.engine.runtime.api.HumanTaskRuntimeException;

public class JaxpFunctionResolver
implements XPathFunctionResolver {
    private static final Log log = LogFactory.getLog(JaxpFunctionResolver.class);
    private EvaluationContext evalCtx;

    public XPathFunction resolveFunction(QName functionName, int arity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving function: " + functionName));
        }
        if (functionName.getNamespaceURI() == null) {
            throw new NullPointerException("Undeclared namespace for " + functionName);
        }
        if ("http://docs.oasis-open.org/ns/bpel4people/ws-humantask/200803".equals(functionName.getNamespaceURI())) {
            String localPart = functionName.getLocalPart();
            if ("getPotentialOwners".equals(localPart)) {
                return new GetPotentialOwners();
            }
            String errMsg = "This operation is not currently supported in this version of WSO2 BPS.";
            if ("getActualOwner".equals(localPart)) {
                throw new UnsupportedOperationException(errMsg);
            }
            if ("getBusinessAdministrators".equals(localPart)) {
                throw new UnsupportedOperationException(errMsg);
            }
            if ("getExcludedOwners".equals(localPart)) {
                throw new UnsupportedOperationException(errMsg);
            }
            if ("getInput".equals(localPart)) {
                return new GetInput();
            }
            if ("getTaskInitiator".equals(localPart)) {
                throw new UnsupportedOperationException(errMsg);
            }
            if ("getTaskPriority".equals(localPart)) {
                throw new UnsupportedOperationException(errMsg);
            }
            if ("getTaskStakeholders".equals(localPart)) {
                throw new UnsupportedOperationException(errMsg);
            }
            if ("getLogicalPeopleGroup".equals(localPart)) {
                throw new UnsupportedOperationException(errMsg);
            }
            if ("intersect".equals(localPart)) {
                throw new UnsupportedOperationException(errMsg);
            }
            if ("union".equals(localPart)) {
                throw new UnsupportedOperationException(errMsg);
            }
            if ("except".equals(localPart)) {
                throw new UnsupportedOperationException(errMsg);
            }
            throw new IllegalArgumentException("Unknown Human Task Function: " + localPart);
        }
        return null;
    }

    public JaxpFunctionResolver(EvaluationContext evalCtx) {
        this.evalCtx = evalCtx;
    }

    public static class GetPotentialOwners
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            return null;
        }
    }

    public class GetInput
    implements XPathFunction {
        public Object evaluate(List args) throws XPathFunctionException {
            MessageDAO inputMsg = JaxpFunctionResolver.this.evalCtx.getInput();
            String partName = (String)args.get(0);
            Node matchingElement = null;
            if (StringUtils.isNullOrEmpty((String)partName)) {
                throw new HumanTaskRuntimeException("The getInput function should be provided with the part name");
            }
            if (inputMsg.getBodyData().hasChildNodes()) {
                NodeList nodeList = inputMsg.getBodyData().getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (!partName.trim().equals(nodeList.item(i).getNodeName())) continue;
                    matchingElement = nodeList.item(i);
                }
            }
            if (matchingElement == null || matchingElement.getFirstChild() == null) {
                throw new HumanTaskRuntimeException("Cannot find a matching Element for expression evaluation: getInput");
            }
            return matchingElement.getFirstChild();
        }
    }
}

