/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.humantask.core.engine.runtime.xpath;

import java.math.BigDecimal;
import org.wso2.carbon.humantask.core.dao.PresentationParameterDAO;
import org.wso2.carbon.humantask.core.engine.runtime.api.EvaluationContext;
import org.wso2.carbon.humantask.core.engine.runtime.api.ExpressionLanguageRuntime;
import org.wso2.carbon.humantask.core.internal.HumanTaskServiceComponent;

public final class XPathEvaluatorUtil {
    private XPathEvaluatorUtil() {
    }

    public static void evaluatePresentationParamXPath(PresentationParameterDAO param, String expression, String expLang, EvaluationContext evalCtx) {
        ExpressionLanguageRuntime expLangRuntime = HumanTaskServiceComponent.getHumanTaskServer().getTaskEngine().getExpressionLanguageRuntime(expLang);
        PresentationParameterDAO.Type type = param.getType();
        if (type == PresentationParameterDAO.Type.XSD_BOOL) {
            Boolean result = expLangRuntime.evaluateAsBoolean(expression, evalCtx);
            param.setValue(result.toString());
        } else if (type == PresentationParameterDAO.Type.XSD_STRING) {
            String result = expLangRuntime.evaluateAsString(expression, evalCtx);
            param.setValue(result);
        } else if (type == PresentationParameterDAO.Type.XSD_INT) {
            Number result = expLangRuntime.evaluateAsNumber(expression, evalCtx);
            param.setValue(Integer.toString(result.intValue()));
        } else if (type == PresentationParameterDAO.Type.XSD_DECIMALE) {
            Number result = expLangRuntime.evaluateAsNumber(expression, evalCtx);
            param.setValue(BigDecimal.valueOf(result.doubleValue()).toString());
        } else if (type == PresentationParameterDAO.Type.XSD_DOUBLE) {
            Number result = expLangRuntime.evaluateAsNumber(expression, evalCtx);
            param.setValue(Double.toString(result.doubleValue()));
        }
    }
}

